/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.search.IFilePartInfo;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.internal.search.UnresolvablePartInfo;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLProject;

public class PartInfoFactory {
    private String[] fProjects = PartInfoFactory.getProjectList();
    private PartInfo fLast = null;
    private char[] fBuffer = new char[512];
    private static final String EGL = "egl";

    public PartInfo create(char[] packageName, char[] typeName, char[][] enclosingName, char partType, String path, IPath projectPath) {
        String pn = this.getPackageName(packageName);
        String tn = new String(typeName);
        PartInfo result = null;
        String eglarDefProject = this.getProject(path);
        if (eglarDefProject != null) {
            result = this.createPartDeclarationInfo(pn, tn, enclosingName, partType, path, PartInfoFactory.getIFilePartInfo(this.fLast), projectPath.toString());
        } else if (eglarDefProject == null) {
            result = this.createExternalPartDeclarationInfo(pn, tn, enclosingName, partType, path, PartInfoFactory.getIFilePartInfo(this.fLast), projectPath.toString());
        }
        if (result == null) {
            result = new UnresolvablePartInfo(pn, tn, enclosingName, path);
        } else {
            this.fLast = result;
        }
        return result;
    }

    private static IFilePartInfo getIFilePartInfo(PartInfo info) {
        if (info == null || info.getElementType() != 3) {
            return null;
        }
        return (IFilePartInfo)info;
    }

    private PartInfo createPartDeclarationInfo(String packageName, String typeName, char[][] enclosingName, char partType, String path, IFilePartInfo last, String project) {
        String rest;
        String src = null;
        String file = null;
        String extension = null;
        String container = null;
        int index = -1;
        if (path.startsWith("/") && (index = path.indexOf("/")) == -1) {
            return null;
        }
        if ((index = path.indexOf("/", index + 1)) == -1) {
            return null;
        }
        container = path.substring(0, index);
        if (container.startsWith("/")) {
            container = container.substring(1);
        }
        if ((index = (rest = path.substring(index)).indexOf("|")) == -1) {
            index = rest.lastIndexOf(47);
            if (index == -1) {
                return null;
            }
            String middle = rest.substring(0, index + 1);
            if ((index = (rest = rest.substring(index + 1)).lastIndexOf(46)) == -1) {
                return null;
            }
            file = rest.substring(0, index);
            extension = rest.substring(index + 1);
            if (!this.packageMatchesDirectoryStructure(middle, packageName)) {
                packageName = "";
                src = middle.substring(1, middle.length());
            } else {
                int ml = middle.length() - 1;
                int pl = packageName.length();
                if (ml > 0 && ml - 1 > pl) {
                    src = middle.substring(1, ml - pl - (pl > 0 ? 1 : 0));
                }
            }
            if (last != null && src != null && src.equals(last.getFolder())) {
                src = last.getFolder();
            }
            file = typeName.equals(file) ? typeName : this.createString(file);
            extension = EGL.equals(extension) ? EGL : this.createString(extension);
        } else {
            src = rest.substring(1, index);
            rest = rest.substring(index + 1);
            if (packageName != null && packageName.length() > 0) {
                int ind = rest.lastIndexOf(47);
                if (ind == -1) {
                    return null;
                }
                rest = rest.substring(ind + 1);
            }
            if ((index = rest.lastIndexOf(46)) == -1) {
                return null;
            }
            file = rest.substring(0, index);
            extension = rest.substring(index + 1);
        }
        if (project.startsWith(File.separator) || project.startsWith("/")) {
            project = project.substring(1);
        }
        return new PartDeclarationInfo(packageName, typeName, enclosingName, project, container, src, file, extension, partType, false);
    }

    private boolean packageMatchesDirectoryStructure(String path, String pkgName) {
        if (pkgName == null || pkgName.length() == 0) {
            return true;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(pkgName, ".", false);
        while (tokenizer.hasMoreTokens()) {
            String pkgElem = String.valueOf(tokenizer.nextToken()) + '/';
            list.add(0, pkgElem);
        }
        for (String pkgElem : list) {
            if (path.endsWith(pkgElem)) {
                path = path.substring(0, path.length() - pkgElem.length());
                continue;
            }
            return false;
        }
        return true;
    }

    private PartInfo createExternalPartDeclarationInfo(String packageName, String typeName, char[][] enclosingName, char partType, String path, IFilePartInfo last, String project) {
        int index;
        String rest = path;
        if (rest.startsWith("eglar://")) {
            rest = rest.substring("eglar://".length());
        }
        if ((index = rest.lastIndexOf("|")) == -1) {
            return null;
        }
        String src = rest.substring(0, index);
        rest = rest.substring(index + 1);
        String file = null;
        String extension = null;
        if (packageName != null && packageName.length() > 0) {
            int ind = rest.lastIndexOf(47);
            if (ind == -1) {
                return null;
            }
            rest = rest.substring(ind + 1);
        }
        if ((index = rest.lastIndexOf(46)) == -1) {
            return null;
        }
        file = rest.substring(0, index);
        extension = rest.substring(index + 1);
        index = src.lastIndexOf(File.separator);
        String fileFolder = null;
        if (index == -1) {
            return null;
        }
        fileFolder = src.substring(0, index);
        src = src.substring(index + 1);
        if (project.startsWith(File.separator) || project.startsWith("/")) {
            project = project.substring(1);
        }
        return new PartDeclarationInfo(packageName, typeName, enclosingName, project, fileFolder, src, file, extension, partType, true);
    }

    private String getPackageName(char[] packageName) {
        if (this.fLast == null) {
            return new String(packageName);
        }
        char[] lastPackageName = this.fLast.getPackageName().toCharArray();
        if (lastPackageName.equals(packageName)) {
            return lastPackageName.toString();
        }
        return new String(packageName);
    }

    private String getProject(String path) {
        int i = 0;
        while (i < this.fProjects.length) {
            String project = this.fProjects[i];
            if (path.startsWith(project, 1)) {
                return project;
            }
            ++i;
        }
        return null;
    }

    private String createString(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length > this.fBuffer.length) {
            this.fBuffer = new char[length];
        }
        s.getChars(0, length, this.fBuffer, 0);
        return new String(this.fBuffer, 0, length);
    }

    private static String[] getProjectList() {
        String[] result;
        IEGLModel model = EGLCore.create(ResourcesPlugin.getWorkspace().getRoot());
        try {
            IEGLProject[] projects = model.getEGLProjects();
            result = new String[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = projects[i].getElementName();
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {
            result = new String[]{};
        }
        Arrays.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                int l2;
                int l1 = ((String)o1).length();
                if (l1 < (l2 = ((String)o2).length())) {
                    return 1;
                }
                if (l2 < l1) {
                    return -1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        });
        return result;
    }
}

