/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AssignmentLocator;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EGLWidgetDefinitionDeleteStragegy {
    private static final String CHILDREN_PROPERTY_NAME = NameUtile.getAsName((String)"children");
    private static final String MVC_PROPERTY_NAME = NameUtile.getAsName((String)"mvc");
    private static final String VIEW_PROPERTY_NAME = NameUtile.getAsName((String)"view");
    private static final String CONTROLLER_PROPERTY_NAME = NameUtile.getAsName((String)"controller");
    private static final String NAME_LABEL_PROPERTY_NAME = NameUtile.getAsName((String)"nameLabel");
    private static final String ERROR_LABEL_PROPERTY_NAME = NameUtile.getAsName((String)"errorLabel");
    private static final String ENTRIES_PROPERTY_NAME = NameUtile.getAsName((String)"entries");
    private static final String CONTROLLER_TYPE_NAME = NameUtile.getAsName((String)"Controller");
    private static final String FORM_FIELD_TYPE_NAME = NameUtile.getAsName((String)"FormField");
    private static final String FORM_FIELD_TYPE_FULL_NAME = NameUtile.getAsName((String)"org.eclipse.edt.rui.mvc.FormField");
    private static final String FORM_MANAGER_TYPE_NAME = NameUtile.getAsName((String)"FormManager");
    private IEGLDocument currentDocument;
    private IPart modelPart;
    private ASTRewrite rewrite;
    private ChildrenRecursiveVisitor childrenVisitor;
    private ControllerVisitor controllerVisitor;
    private FormFieldVisitor formFieldVisitor;
    private FormManagerVisitor formManagerVisitor;
    private Set<String> deleteFormFieldNames;
    private Set<String> oldFormFieldNames;
    private Set<Node> deletedFormFieldNodes;
    private Assignment currentFormManagerEntitiesAssignment;
    private Assignment formManagerEntitiesAssignment;
    private TextEdit textEdit;

    public EGLWidgetDefinitionDeleteStragegy(IEGLDocument currentDocument, IPart modelPart, ASTRewrite rewrite) {
        this.currentDocument = currentDocument;
        this.modelPart = modelPart;
        this.rewrite = rewrite;
        this.deleteFormFieldNames = new HashSet<String>();
        this.oldFormFieldNames = new HashSet<String>();
        this.deletedFormFieldNodes = new HashSet<Node>();
    }

    public void deleteWidgetDefinition(String widgetName) throws Exception {
        this.childrenVisitor = new ChildrenRecursiveVisitor(this.modelPart, this.rewrite);
        this.controllerVisitor = new ControllerVisitor(this.rewrite);
        this.formFieldVisitor = new FormFieldVisitor();
        this.formManagerVisitor = new FormManagerVisitor();
        IField[] fields = this.modelPart.getFields();
        int j = 0;
        while (j < fields.length) {
            IField field = fields[j];
            if (field.getElementName().equalsIgnoreCase(widgetName)) {
                Node widgetNameNode = this.currentDocument.getNewModelNodeAtOffset(field.getNameRange().getOffset(), field.getNameRange().getLength());
                Node widgetDefinition = widgetNameNode.getParent();
                widgetDefinition.accept((IASTVisitor)this.childrenVisitor);
                this.controllerVisitor.setWidgetName(widgetName);
                widgetDefinition.getParent().accept((IASTVisitor)this.controllerVisitor);
                this.formFieldVisitor.setDeleteLabelPropertyName(widgetName);
                this.formFieldVisitor.setDeleteControllerPropertyName(this.controllerVisitor.getContorllerName());
                widgetDefinition.getParent().accept((IASTVisitor)this.formFieldVisitor);
                widgetDefinition.getParent().accept((IASTVisitor)this.formManagerVisitor);
                this.rewrite.removeNode(widgetDefinition);
                this.textEdit = this.rewrite.rewriteAST((IDocument)this.currentDocument);
                break;
            }
            ++j;
        }
        this.deleteFormFields();
    }

    private void deleteFormFields() {
        try {
            IField[] fields = this.modelPart.getFields();
            int j = 0;
            while (j < fields.length) {
                Node formFieldNameNode;
                Node formFieldNode;
                IField field = fields[j];
                if (this.deleteFormFieldNames.contains(field.getElementName()) && !this.deletedFormFieldNodes.contains(formFieldNode = (formFieldNameNode = this.currentDocument.getNewModelNodeAtOffset(field.getNameRange().getOffset(), field.getNameRange().getLength())).getParent())) {
                    this.rewrite.removeNode(formFieldNode);
                    this.textEdit = this.rewrite.rewriteAST((IDocument)this.currentDocument);
                    this.deletedFormFieldNodes.add(formFieldNode);
                }
                ++j;
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Delete Form Field Definition: Error deleting definition", (Throwable)e));
        }
    }

    public void modifyFormManagerEntities() {
        if (this.formManagerEntitiesAssignment != null) {
            ArrayList<String> newFormFieldNames = new ArrayList<String>();
            for (String oldFormFieldName : this.oldFormFieldNames) {
                if (this.deleteFormFieldNames.contains(oldFormFieldName)) continue;
                newFormFieldNames.add(oldFormFieldName);
            }
            StringBuffer sbNewFormFields = new StringBuffer("entries = [ ");
            int i = 0;
            while (i < newFormFieldNames.size()) {
                sbNewFormFields.append((String)newFormFieldNames.get(i));
                if (i != newFormFieldNames.size() - 1) {
                    sbNewFormFields.append(", ");
                }
                ++i;
            }
            String sNewFormFields = sbNewFormFields.append(" ]").toString();
            this.rewrite.setText((Node)this.formManagerEntitiesAssignment, sNewFormFields);
            this.textEdit = this.rewrite.rewriteAST((IDocument)this.currentDocument);
        }
    }

    public TextEdit getTextEdit() {
        return this.textEdit;
    }

    private class ChildrenRecursiveVisitor
    extends DefaultASTVisitor {
        private final IPart modelPart;
        private final ASTRewrite rewrite;

        public ChildrenRecursiveVisitor(IPart modelPart, ASTRewrite rewrite) {
            this.modelPart = modelPart;
            this.rewrite = rewrite;
        }

        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            if (classDataDeclaration.hasSettingsBlock()) {
                SettingsBlock settingsBlockOpt = classDataDeclaration.getSettingsBlockOpt();
                AssignmentLocator assignmentLocator = new AssignmentLocator(CHILDREN_PROPERTY_NAME);
                settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                Assignment assignment = assignmentLocator.getAssignment();
                if (assignment != null) {
                    assignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(ArrayLiteral arrayLiteral) {
                            try {
                                List expressions = arrayLiteral.getExpressions();
                                if (expressions.size() > 0) {
                                    int i = 0;
                                    while (i < expressions.size()) {
                                        Object expression = expressions.get(i);
                                        if (expression instanceof SimpleName) {
                                            SimpleName simpleName = (SimpleName)expression;
                                            String childWidgetName = simpleName.getCanonicalName();
                                            IField[] fields = ChildrenRecursiveVisitor.this.modelPart.getFields();
                                            int j = 0;
                                            while (j < fields.length) {
                                                IField field = fields[j];
                                                if (childWidgetName.equalsIgnoreCase(field.getElementName())) {
                                                    Node childWidgetNameNode = EGLWidgetDefinitionDeleteStragegy.this.currentDocument.getNewModelNodeAtOffset(field.getNameRange().getOffset(), field.getNameRange().getLength());
                                                    Node childWidgetDefinition = childWidgetNameNode.getParent();
                                                    childWidgetDefinition.accept((IASTVisitor)EGLWidgetDefinitionDeleteStragegy.this.childrenVisitor);
                                                    EGLWidgetDefinitionDeleteStragegy.this.controllerVisitor.setWidgetName(childWidgetName);
                                                    childWidgetDefinition.getParent().accept((IASTVisitor)EGLWidgetDefinitionDeleteStragegy.this.controllerVisitor);
                                                    EGLWidgetDefinitionDeleteStragegy.this.formFieldVisitor.setDeleteLabelPropertyName(childWidgetName);
                                                    EGLWidgetDefinitionDeleteStragegy.this.formFieldVisitor.setDeleteControllerPropertyName(EGLWidgetDefinitionDeleteStragegy.this.controllerVisitor.getContorllerName());
                                                    childWidgetDefinition.getParent().accept((IASTVisitor)EGLWidgetDefinitionDeleteStragegy.this.formFieldVisitor);
                                                    childWidgetDefinition.getParent().accept((IASTVisitor)EGLWidgetDefinitionDeleteStragegy.this.formManagerVisitor);
                                                    ChildrenRecursiveVisitor.this.rewrite.removeNode(childWidgetDefinition);
                                                    ChildrenRecursiveVisitor.this.rewrite.rewriteAST((IDocument)EGLWidgetDefinitionDeleteStragegy.this.currentDocument);
                                                    break;
                                                }
                                                ++j;
                                            }
                                        }
                                        ++i;
                                    }
                                }
                            }
                            catch (Exception e) {
                                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Delete Widget Definition: Error deleting definition", (Throwable)e));
                            }
                            return false;
                        }
                    });
                }
            }
            return false;
        }
    }

    private class ControllerVisitor
    extends DefaultASTVisitor {
        private final ASTRewrite rewrite;
        private String widgetName;
        private String contorllerName;

        public ControllerVisitor(ASTRewrite rewrite) {
            this.rewrite = rewrite;
        }

        public void setWidgetName(String widgetName) {
            this.widgetName = widgetName;
        }

        public String getContorllerName() {
            return this.contorllerName;
        }

        public boolean visit(Handler handler) {
            return true;
        }

        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            if (classDataDeclaration.getType().getCanonicalName().equalsIgnoreCase(CONTROLLER_TYPE_NAME) && classDataDeclaration.hasSettingsBlock()) {
                SettingsBlock settingsBlockOpt = classDataDeclaration.getSettingsBlockOpt();
                List settings = settingsBlockOpt.getSettings();
                int i = 0;
                while (i < settings.size()) {
                    SetValuesExpression setValuesExpression;
                    Object oSetting = settings.get(i);
                    if (oSetting instanceof SetValuesExpression && (setValuesExpression = (SetValuesExpression)oSetting).getExpression().getCanonicalString().equalsIgnoreCase(MVC_PROPERTY_NAME)) {
                        String rightHandSide;
                        String rightHandSideFieldName;
                        SettingsBlock settingsBlock = setValuesExpression.getSettingsBlock();
                        AssignmentLocator assignmentLocator = new AssignmentLocator(VIEW_PROPERTY_NAME);
                        settingsBlock.accept((IASTVisitor)assignmentLocator);
                        Assignment assignment = assignmentLocator.getAssignment();
                        if (assignment != null && (rightHandSideFieldName = (rightHandSide = assignment.getRightHandSide().getCanonicalString().trim()).split(" ")[0]).equalsIgnoreCase(this.widgetName)) {
                            this.contorllerName = ((SimpleName)classDataDeclaration.getNames().get(0)).getCanonicalName();
                            this.rewrite.removeNode((Node)classDataDeclaration);
                            EGLWidgetDefinitionDeleteStragegy.this.textEdit = this.rewrite.rewriteAST((IDocument)EGLWidgetDefinitionDeleteStragegy.this.currentDocument);
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    private class FormFieldVisitor
    extends DefaultASTVisitor {
        private String controllerName;
        private String nameLabelName;
        private String errorLabelName;
        private String deleteControllerPropertyName;
        private String deleteLabelPropertyName;

        private FormFieldVisitor() {
        }

        public void setDeleteLabelPropertyName(String deleteLabelPropertyName) {
            this.deleteLabelPropertyName = deleteLabelPropertyName;
        }

        public void setDeleteControllerPropertyName(String deleteControllerPropertyName) {
            this.deleteControllerPropertyName = deleteControllerPropertyName;
        }

        public boolean visit(Handler handler) {
            return true;
        }

        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            String theFormFieldName = classDataDeclaration.getType().getCanonicalName();
            if ((theFormFieldName.equalsIgnoreCase(FORM_FIELD_TYPE_NAME) || theFormFieldName.equalsIgnoreCase(FORM_FIELD_TYPE_FULL_NAME)) && classDataDeclaration.hasSettingsBlock()) {
                SettingsBlock settingsBlockOpt = classDataDeclaration.getSettingsBlockOpt();
                AssignmentLocator controllerAssignmentLocator = new AssignmentLocator(CONTROLLER_PROPERTY_NAME);
                settingsBlockOpt.accept((IASTVisitor)controllerAssignmentLocator);
                Assignment controllerAssignment = controllerAssignmentLocator.getAssignment();
                if (controllerAssignment != null) {
                    this.controllerName = controllerAssignment.getRightHandSide().getCanonicalString();
                }
                AssignmentLocator nameLabelAssignmentLocator = new AssignmentLocator(NAME_LABEL_PROPERTY_NAME);
                settingsBlockOpt.accept((IASTVisitor)nameLabelAssignmentLocator);
                Assignment nameLabelAssignment = nameLabelAssignmentLocator.getAssignment();
                if (nameLabelAssignment != null) {
                    this.nameLabelName = nameLabelAssignment.getRightHandSide().getCanonicalString();
                }
                AssignmentLocator errorLabelAssignmentLocator = new AssignmentLocator(ERROR_LABEL_PROPERTY_NAME);
                settingsBlockOpt.accept((IASTVisitor)errorLabelAssignmentLocator);
                Assignment errorLabelAssignment = errorLabelAssignmentLocator.getAssignment();
                if (errorLabelAssignment != null) {
                    this.errorLabelName = errorLabelAssignment.getRightHandSide().getCanonicalString();
                }
                String formFieldName = ((SimpleName)classDataDeclaration.getNames().get(0)).getCanonicalName();
                if (this.controllerName != null && this.controllerName.equalsIgnoreCase(this.deleteControllerPropertyName) || this.nameLabelName != null && this.nameLabelName.equalsIgnoreCase(this.deleteLabelPropertyName) || this.errorLabelName != null && this.errorLabelName.equalsIgnoreCase(this.deleteLabelPropertyName)) {
                    EGLWidgetDefinitionDeleteStragegy.this.deleteFormFieldNames.add(formFieldName);
                }
            }
            return false;
        }
    }

    private class FormManagerVisitor
    extends DefaultASTVisitor {
        private FormManagerVisitor() {
        }

        public boolean visit(Handler handler) {
            return true;
        }

        public boolean visit(ClassDataDeclaration classDataDeclaration) {
            if (classDataDeclaration.getType().getCanonicalName().equalsIgnoreCase(FORM_MANAGER_TYPE_NAME) && classDataDeclaration.hasSettingsBlock()) {
                SettingsBlock settingsBlockOpt = classDataDeclaration.getSettingsBlockOpt();
                AssignmentLocator assignmentLocator = new AssignmentLocator(ENTRIES_PROPERTY_NAME);
                settingsBlockOpt.accept((IASTVisitor)assignmentLocator);
                EGLWidgetDefinitionDeleteStragegy.this.currentFormManagerEntitiesAssignment = assignmentLocator.getAssignment();
                EGLWidgetDefinitionDeleteStragegy.this.currentFormManagerEntitiesAssignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                    public boolean visit(ArrayLiteral arrayLiteral) {
                        List expressions = arrayLiteral.getExpressions();
                        if (expressions.size() > 0) {
                            int i = 0;
                            while (i < expressions.size()) {
                                Node expression = (Node)expressions.get(i);
                                if (expression instanceof SimpleName) {
                                    SimpleName simpleName = (SimpleName)expression;
                                    if (EGLWidgetDefinitionDeleteStragegy.this.deleteFormFieldNames.contains(simpleName.getCanonicalName())) {
                                        EGLWidgetDefinitionDeleteStragegy.this.formManagerEntitiesAssignment = EGLWidgetDefinitionDeleteStragegy.this.currentFormManagerEntitiesAssignment;
                                    }
                                }
                                ++i;
                            }
                        }
                        return false;
                    }
                });
                if (EGLWidgetDefinitionDeleteStragegy.this.formManagerEntitiesAssignment != null) {
                    EGLWidgetDefinitionDeleteStragegy.this.formManagerEntitiesAssignment.getRightHandSide().accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(ArrayLiteral arrayLiteral) {
                            List expressions = arrayLiteral.getExpressions();
                            if (expressions.size() > 0) {
                                int i = 0;
                                while (i < expressions.size()) {
                                    Node expression = (Node)expressions.get(i);
                                    if (expression instanceof SimpleName) {
                                        SimpleName simpleName = (SimpleName)expression;
                                        EGLWidgetDefinitionDeleteStragegy.this.oldFormFieldNames.add(simpleName.getCanonicalName());
                                    }
                                    ++i;
                                }
                            }
                            return false;
                        }
                    });
                }
            }
            return false;
        }
    }
}

