/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AddImportOperation;
import org.eclipse.edt.ide.rui.document.utils.DocumentUtil;
import org.eclipse.edt.ide.rui.document.utils.TypeNameResolver;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;

public class InsertWidgetOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;

    public InsertWidgetOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public void insertWidget(String fieldName, String widgetPackage, String widgetType, String template, int index) {
        try {
            this.addClassFieldAtIndex(index, fieldName, widgetPackage, widgetType, template);
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Insert Widget: Error creating working copy", (Throwable)e));
        }
    }

    private Part getPart(File fileAST, String partName) {
        Part part = null;
        List parts = fileAST.getParts();
        for (Part nextPart : parts) {
            if (!NameUtile.equals((String)nextPart.getIdentifier(), (String)NameUtile.getAsName((String)partName))) continue;
            part = nextPart;
            break;
        }
        return part;
    }

    private void addClassFieldAtIndex(int index, String fieldName, String widgetPackage, String widgetType, String template) throws EGLModelException, MalformedTreeException, BadLocationException {
        AddImportOperation addImportOp;
        TypeNameResolver typeNameResolver;
        if (template == null) {
            if (widgetPackage.length() == 0) {
                template = String.valueOf(widgetType) + "{}";
            } else {
                typeNameResolver = new TypeNameResolver(this.currentFile);
                typeNameResolver.resolveTypeName(widgetPackage, widgetType);
                template = String.valueOf(typeNameResolver.getTypeName()) + "{}";
                if (typeNameResolver.requiresQualifiedImport()) {
                    addImportOp = new AddImportOperation(this.currentDocument, this.currentFile);
                    addImportOp.addFullyQualifiedImport(String.valueOf(widgetPackage) + "." + widgetType);
                }
            }
        } else if (template.length() >= "${typename}".length() && template.substring(0, "${typeName}".length()).equalsIgnoreCase("${typeName}")) {
            if (widgetPackage.length() == 0) {
                template = String.valueOf(widgetType) + template.substring("${typeName}".length());
            } else {
                typeNameResolver = new TypeNameResolver(this.currentFile);
                typeNameResolver.resolveTypeName(widgetPackage, widgetType);
                template = String.valueOf(typeNameResolver.getTypeName()) + template.substring("${typeName}".length());
                if (typeNameResolver.requiresQualifiedImport()) {
                    addImportOp = new AddImportOperation(this.currentDocument, this.currentFile);
                    addImportOp.addFullyQualifiedImport(String.valueOf(widgetPackage) + "." + widgetType);
                }
            }
        } else {
            fieldName = "\n\t" + fieldName;
        }
        ArrayList imports = new ArrayList();
        template = DocumentUtil.handleTypeNameVaraibles(this.currentFile, this.currentDocument, template, imports);
        DocumentUtil.addQualifiedImports(this.currentFile, this.currentDocument, imports);
        File fileAST = this.currentDocument.getNewModelEGLFile();
        String partName = new Path(this.currentFile.getName()).removeFileExtension().toString();
        Part part = this.getPart(fileAST, partName);
        ASTRewrite rewrite = ASTRewrite.create((File)fileAST);
        rewrite.addClassFieldAtIndex(part, fieldName, template, null, index);
        rewrite.rewriteAST((IDocument)this.currentDocument).apply((IDocument)this.currentDocument);
    }
}

