/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.internal.nls;

import java.util.HashMap;
import java.util.List;
import org.eclipse.edt.ide.rui.internal.HelpContextIDs;
import org.eclipse.edt.ide.rui.internal.nls.Locale;
import org.eclipse.edt.ide.rui.internal.nls.LocaleUtility;
import org.eclipse.edt.ide.rui.internal.nls.NewLocaleWizardPage;
import org.eclipse.edt.ide.rui.internal.nls.RUINlsStrings;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class EditLocaleWizardPage
extends NewLocaleWizardPage {
    private String originalCode;
    private String originalDescription;
    private String originalRuntimeCode;

    public EditLocaleWizardPage(String pageName, String title, Locale locale, List currentCodes, List currentDescriptions, HashMap combinations) {
        super(pageName, title, locale, currentCodes, currentDescriptions, combinations);
        this.originalCode = locale.getCode();
        this.originalDescription = locale.getDescription();
        this.originalRuntimeCode = locale.getRuntimeLocaleCode();
    }

    @Override
    public void createControl(Composite parent) {
        Composite twoCols = new Composite(parent, 0);
        this.createDialogControls(twoCols);
        this.setControl((Control)twoCols);
        this.setPageComplete(this.validatePage());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)twoCols, HelpContextIDs.RUI_New_Locale_Wizard);
        Dialog.applyDialogFont((Control)twoCols);
    }

    @Override
    protected void createDialogControls(Composite twoCols) {
        super.createDialogControls(twoCols);
        this.code.setText(this.locale.getCode());
        this.description.setText(this.locale.getDescription());
        this.runtimeLocaleChoicesCombo.setText(LocaleUtility.getRuntimeDescriptionForCode(this.locale.getRuntimeLocaleCode()));
    }

    @Override
    protected boolean validatePage() {
        String error = "";
        String code = this.code.getText();
        String description = this.description.getText();
        String runtimeCode = LocaleUtility.getRuntimeCodeForDescription(this.runtimeLocaleChoicesCombo.getText());
        if (this.description.getText().equals("")) {
            error = RUINlsStrings.NewLocaleDialog_Please_enter_a_unique_locale_descri_;
            this.description.setFocus();
        } else if (code.equals("")) {
            error = RUINlsStrings.NewLocaleDialog_Please_enter_a_unique_locale_cod_;
            this.code.setFocus();
        } else {
            List runtimes;
            if (error.length() == 0 && !description.equalsIgnoreCase(this.originalDescription) && this.currentDescriptions.contains(this.description.getText())) {
                error = RUINlsStrings.NewLocaleDialog_The_description_is_not_uniqu_;
                this.description.setFocus();
            }
            if ((!code.equalsIgnoreCase(this.originalCode) || !runtimeCode.equalsIgnoreCase(this.originalRuntimeCode)) && this.currentUserLocaleRuntimeLocaleCombinations.containsKey(code) && (runtimes = (List)this.currentUserLocaleRuntimeLocaleCombinations.get(code)).contains(runtimeCode)) {
                error = RUINlsStrings.NewLocaleDialog_locale_combo_already_exists;
                this.code.setFocus();
            }
        }
        if (error.length() > 0) {
            this.setMessage(error, 3);
            return false;
        }
        this.setMessage(null);
        this.locale.setCode(code);
        this.locale.setDescription(description);
        this.locale.setRuntimeLocaleCode(runtimeCode);
        return true;
    }
}

