/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.ArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.edt.debug.core.EGLPackageFragmentRootSourceContainer;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;

public abstract class EGLSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    protected void buildContainers(IProject project, List<ISourceContainer> allEntries, Set<IProject> seen) {
        if (seen.contains(project)) {
            return;
        }
        seen.add(project);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            if (project.hasNature(EGLCore.NATURE_ID)) {
                IEGLProject eglProject = EGLCore.create((IProject)project);
                IEGLPathEntry[] entries = eglProject.getResolvedEGLPath(true);
                int i = 0;
                while (i < entries.length) {
                    switch (entries[i].getEntryKind()) {
                        case 2: {
                            IResource member = root.findMember(entries[i].getPath());
                            if (member == null || member.getType() != 4 || !member.isAccessible()) break;
                            this.buildContainers((IProject)member, allEntries, seen);
                            break;
                        }
                        case 3: {
                            EGLPackageFragmentRootSourceContainer container;
                            IPackageFragmentRoot pkgRoot = eglProject.getPackageFragmentRoot(entries[i].getPath());
                            if (pkgRoot != null) {
                                EGLPackageFragmentRootSourceContainer container2 = new EGLPackageFragmentRootSourceContainer(pkgRoot);
                                if (allEntries.contains((Object)container2)) break;
                                allEntries.add((ISourceContainer)container2);
                                break;
                            }
                            IResource member = root.findMember(entries[i].getPath());
                            if (member == null || member.getType() != 2 || allEntries.contains((Object)(container = new FolderSourceContainer((IContainer)((IFolder)member), true)))) break;
                            allEntries.add((ISourceContainer)container);
                            break;
                        }
                        case 1: {
                            EGLPackageFragmentRootSourceContainer container;
                            IPath sourcePath = entries[i].getSourceAttachmentPath();
                            if (sourcePath == null || sourcePath.isEmpty()) break;
                            IPackageFragmentRoot pkgRoot = eglProject.getPackageFragmentRoot(entries[i].getPath());
                            if (pkgRoot != null) {
                                container = new EGLPackageFragmentRootSourceContainer(pkgRoot);
                                if (allEntries.contains((Object)container)) break;
                                allEntries.add((ISourceContainer)container);
                                break;
                            }
                            IResource file = root.findMember(sourcePath);
                            Object container3 = file != null && file.getType() == 1 ? new ArchiveSourceContainer((IFile)file, true) : new ExternalArchiveSourceContainer(sourcePath.toOSString(), true);
                            if (allEntries.contains(container3)) break;
                            allEntries.add((ISourceContainer)container3);
                        }
                    }
                    ++i;
                }
            } else {
                allEntries.add((ISourceContainer)new ProjectSourceContainer(project, true));
            }
        }
        catch (CoreException coreException) {}
        String[] stringArray = ProjectSettingsUtility.getSourceProjects((IProject)project.getProject());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            IProject p = root.getProject(name);
            if (p != null && p.isAccessible()) {
                this.buildContainers(p, allEntries, seen);
            }
            ++n2;
        }
    }
}

