/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.util.List;
import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.ArrayLiteral;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.AsExpression;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.IRUtils;

public class ArrayLiteralTemplate
extends JavaTemplate {
    public void genExpression(ArrayLiteral expr, Context ctx, TabbedWriter out) {
        List entries = expr.getEntries();
        if (entries == null || entries.size() == 0) {
            ctx.invoke("genInstantiation", expr.getType(), new Object[]{ctx, out});
        } else {
            Type type = expr.getType();
            ctx.invoke("genRuntimeTypeName", (Type)type.getClassifier(), new Object[]{ctx, out, JavaTemplate.TypeNameKind.EGLImplementation});
            out.print(".ezeNew(");
            Type elementType = ((ArrayType)type).getElementType();
            boolean firstElement = true;
            for (Expression element : entries) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    out.print(", ");
                }
                ctx.invoke("genExpression", IRUtils.makeExprCompatibleToType((Expression)element, (Type)elementType), (TemplateContext)ctx, out);
            }
        }
        out.print(')');
    }

    public void genExpression(ArrayLiteral expr, Context ctx, TabbedWriter out, AsExpression arg) {
        List entries = expr.getEntries();
        if (entries == null || entries.size() == 0) {
            ctx.invoke("genInstantiation", expr.getType(), new Object[]{ctx, out});
        } else {
            Type type = expr.getType();
            ctx.invoke("genRuntimeTypeName", (Type)type.getClassifier(), new Object[]{ctx, out, JavaTemplate.TypeNameKind.EGLImplementation});
            out.print(".ezeNew(");
            Type elementType = ((ArrayType)type).getElementType();
            Type baseType = this.getBaseType(arg.getType());
            if (baseType instanceof Delegate) {
                elementType = baseType;
            }
            boolean firstElement = true;
            for (Expression element : entries) {
                String functionSig;
                if (firstElement) {
                    firstElement = false;
                } else {
                    out.print(", ");
                }
                if (elementType instanceof Delegate) {
                    functionSig = ((Function)CommonUtilities.getMember((Expression)element)).getSignature();
                    ctx.put((Object)("Delegate_signature_for_function_" + functionSig), (Object)((Delegate)elementType).getTypeSignature());
                }
                ctx.invoke("genExpression", IRUtils.makeExprCompatibleToType((Expression)element, (Type)elementType), (TemplateContext)ctx, out);
                if (!(elementType instanceof Delegate)) continue;
                functionSig = ((Function)CommonUtilities.getMember((Expression)element)).getSignature();
                ctx.remove((Object)("Delegate_signature_for_function_" + functionSig));
            }
        }
        out.print(')');
    }

    private Type getBaseType(Type type) {
        if (type instanceof ArrayType) {
            return this.getBaseType(((ArrayType)type).getElementType());
        }
        return type;
    }
}

