/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.DecimalLiteral;

public class DecimalLiteralTemplate
extends JavaTemplate {
    public void genExpression(DecimalLiteral expr, Context ctx, TabbedWriter out) {
        BigDecimal bd = new BigDecimal(expr.getValue());
        if (bd.signum() == 0) {
            out.print("java.math.BigDecimal.ZERO");
        } else if (bd.compareTo(BigDecimal.ONE) == 0) {
            out.print("java.math.BigDecimal.ONE");
        } else if (bd.compareTo(BigDecimal.TEN) == 0) {
            out.print("java.math.BigDecimal.TEN");
        } else {
            BigInteger unscaled = bd.unscaledValue();
            if (unscaled.bitLength() < 63) {
                out.print("java.math.BigDecimal.valueOf(");
                out.print(unscaled.toString());
                out.print("L, ");
                out.print(bd.scale());
                out.print(')');
            } else {
                byte[] bytes = unscaled.toByteArray();
                out.print("new java.math.BigDecimal( new java.math.BigInteger( new byte[] {");
                int i = 0;
                while (i < bytes.length) {
                    if (bytes[i] >= 0) {
                        out.print(" 0x" + Integer.toHexString(bytes[i] & 0xFF));
                    } else {
                        out.print(" (byte)0x" + Integer.toHexString(bytes[i] & 0xFF));
                    }
                    if (i < bytes.length - 1) {
                        out.print(',');
                    }
                    ++i;
                }
                out.print(" } ), ");
                out.print(bd.scale());
                out.print(')');
            }
        }
    }
}

