/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.runtime.java.eglx.lang;

import eglx.lang.AnyException;
import eglx.lang.ENumber;
import eglx.lang.NullValueException;
import eglx.lang.NumericOverflowException;
import eglx.lang.TypeCastException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.edt.javart.AnyBoxedObject;
import org.eclipse.edt.runtime.java.eglx.lang.EAny;
import org.eclipse.edt.runtime.java.eglx.lang.EBytes;
import org.eclipse.edt.runtime.java.eglx.lang.EDecimal;
import org.eclipse.edt.runtime.java.eglx.lang.EFloat;
import org.eclipse.edt.runtime.java.eglx.lang.EInt;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallfloat;
import org.eclipse.edt.runtime.java.eglx.lang.ESmallint;
import org.eclipse.edt.runtime.java.eglx.lang.EString;

public class EBigint
extends AnyBoxedObject<Long>
implements ENumber {
    private static final long serialVersionUID = 10L;
    private static final long DefaultValue = 0L;
    private static final int Precision = 18;

    private EBigint(Long value) {
        super(value);
    }

    public static EBigint ezeBox(Long value) {
        return new EBigint(value);
    }

    public static Long ezeCast(Object value) throws AnyException {
        return (Long)EAny.ezeCast(value, "asBigint", EBigint.class, null, null);
    }

    public static boolean ezeIsa(Object value) {
        return value instanceof EBigint && ((EBigint)value).ezeUnbox() != null || value instanceof Long;
    }

    public String toString() {
        return EString.asString((Long)this.object, new Integer[0]);
    }

    public static Long asBigint(Short value) {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    public static Long asBigint(ESmallint value) {
        if (value == null) {
            return null;
        }
        return ((Short)value.ezeUnbox()).longValue();
    }

    public static Long asBigint(Integer value) {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    public static Long asBigint(EInt value) {
        if (value == null) {
            return null;
        }
        return ((Integer)value.ezeUnbox()).longValue();
    }

    public static Long asBigint(Long value) {
        return value;
    }

    public static Long asBigint(EBigint value) {
        if (value == null) {
            return null;
        }
        return (Long)value.ezeUnbox();
    }

    public static Long asBigint(Float value) {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        long result = 0L;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value.floatValue()).longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Float.valueOf(value.floatValue()).longValue();
        }
        return result;
    }

    public static Long asBigint(ESmallfloat value) {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        long result = 0L;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(((Float)value.ezeUnbox()).floatValue()).longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Float.valueOf(((Float)value.ezeUnbox()).floatValue()).longValue();
        }
        return result;
    }

    public static Long asBigint(Double value) {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        long result = 0L;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf(value).longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Double.valueOf(value).longValue();
        }
        return result;
    }

    public static Long asBigint(EFloat value) {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        long result = 0L;
        if (throwOverflowExceptions) {
            try {
                result = BigDecimal.valueOf((Double)value.ezeUnbox()).longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = Double.valueOf((Double)value.ezeUnbox()).longValue();
        }
        return result;
    }

    public static Long asBigint(BigDecimal value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        long result = 0L;
        if (throwOverflowExceptions) {
            try {
                result = value.longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = value.longValue();
        }
        return result;
    }

    public static Long asBigint(EDecimal value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        long result = 0L;
        if (throwOverflowExceptions) {
            try {
                result = ((BigDecimal)value.ezeUnbox()).longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = ((BigDecimal)value.ezeUnbox()).longValue();
        }
        return result;
    }

    public static Long asBigint(BigInteger value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        long result = 0L;
        if (throwOverflowExceptions) {
            try {
                result = new BigDecimal(value).longValueExact();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = value.longValue();
        }
        return result;
    }

    public static Long asBigint(Number value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        long result = 0L;
        if (throwOverflowExceptions) {
            try {
                result = value.longValue();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = value.longValue();
        }
        return result;
    }

    public static Long asBigint(ENumber value) throws AnyException {
        if (value == null) {
            return null;
        }
        boolean throwOverflowExceptions = false;
        long result = 0L;
        if (throwOverflowExceptions) {
            try {
                result = value.ezeUnbox().longValue();
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericOverflowException();
            }
        } else {
            result = value.ezeUnbox().longValue();
        }
        return result;
    }

    public static Long asBigint(String value) throws AnyException {
        if (value == null) {
            return null;
        }
        try {
            String input = value.charAt(0) == '+' ? value.substring(1) : value;
            return Long.valueOf(input);
        }
        catch (Exception exception) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "string";
            tcx.castToName = "bigint";
            throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
        }
    }

    public static Long asBigint(EString value) throws AnyException {
        if (value == null) {
            return null;
        }
        return EBigint.asBigint((String)value.ezeUnbox());
    }

    public static Long asBigint(byte[] value) throws AnyException {
        if (value == null) {
            return null;
        }
        if (value.length != 8) {
            TypeCastException tcx = new TypeCastException();
            tcx.actualTypeName = "bytes(" + value.length + ')';
            tcx.castToName = "bigint";
            throw tcx.fillInMessage("EGL0007E", value, tcx.actualTypeName, tcx.castToName);
        }
        return ((long)value[0] & 0xFFL) << 56 | ((long)value[1] & 0xFFL) << 48 | ((long)value[2] & 0xFFL) << 40 | ((long)value[3] & 0xFFL) << 32 | ((long)value[4] & 0xFFL) << 24 | ((long)value[5] & 0xFFL) << 16 | ((long)value[6] & 0xFFL) << 8 | (long)value[7] & 0xFFL;
    }

    public static Long asBigint(EBytes value) throws AnyException {
        if (value == null) {
            return null;
        }
        return EBigint.asBigint((byte[])value.ezeUnbox());
    }

    public static EBigint asNumber(Long value) throws AnyException {
        if (value == null) {
            return null;
        }
        return EBigint.ezeBox(value);
    }

    public static EBigint asNumber(EBigint value) throws AnyException {
        if (value == null) {
            return null;
        }
        return value;
    }

    public static long negate(Long op) throws AnyException {
        if (op == null) {
            NullValueException nvx = new NullValueException();
            throw nvx.fillInMessage("EGL0016E", new Object[0]);
        }
        return -op.longValue();
    }

    public static long plus(long op1, long op2) throws AnyException {
        return op1 + op2;
    }

    public static long minus(long op1, long op2) throws AnyException {
        return op1 - op2;
    }

    public static BigDecimal divide(long op1, long op2) throws AnyException {
        return BigDecimal.valueOf(op1).divide(BigDecimal.valueOf(op2), 32, 4);
    }

    public static long multiply(long op1, long op2) throws AnyException {
        return op1 * op2;
    }

    public static long remainder(long op1, long op2) throws AnyException {
        return op1 % op2;
    }

    public static double power(long op1, long op2) throws AnyException {
        return StrictMath.pow(op1, op2);
    }

    public static int compareTo(long op1, long op2) throws AnyException {
        return Long.valueOf(op1).compareTo(op2);
    }

    public static boolean equals(Long op1, Long op2) {
        if (op1 == op2) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.compareTo(op2) == 0;
    }

    public static boolean equals(Integer op1, Long op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return Long.valueOf(op1.longValue()).compareTo(op2) == 0;
    }

    public static boolean equals(Long op1, Integer op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.compareTo(op2.longValue()) == 0;
    }

    public static boolean equals(Short op1, Long op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return Long.valueOf(op1.longValue()).compareTo(op2) == 0;
    }

    public static boolean equals(Long op1, Short op2) {
        if (op1 == null && op2 == null) {
            return true;
        }
        if (op1 == null || op2 == null) {
            return false;
        }
        return op1.compareTo(op2.longValue()) == 0;
    }

    public static boolean notEquals(Long op1, Long op2) {
        return !EBigint.equals(op1, op2);
    }

    public static boolean notEquals(Integer op1, Long op2) {
        return !EBigint.equals(op1, op2);
    }

    public static boolean notEquals(Long op1, Integer op2) {
        return !EBigint.equals(op1, op2);
    }

    public static boolean notEquals(Short op1, Long op2) {
        return !EBigint.equals(op1, op2);
    }

    public static boolean notEquals(Long op1, Short op2) {
        return !EBigint.equals(op1, op2);
    }

    public static long defaultValue() {
        return 0L;
    }

    public static int precision() {
        return 18;
    }
}

