/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.enricher.resource;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.container.test.impl.enricher.resource.OperatesOnDeploymentAwareProvider;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.api.Secured;

public class URLResourceProvider
extends OperatesOnDeploymentAwareProvider {
    @Inject
    private Instance<ProtocolMetaData> protocolMetadata;

    public boolean canProvide(Class<?> type) {
        return type.isAssignableFrom(URL.class);
    }

    @Override
    public Object doLookup(ArquillianResource resource, Annotation ... qualifiers) {
        return this.locateURL(resource, qualifiers);
    }

    private Object locateURL(ArquillianResource resource, Annotation[] qualifiers) {
        ProtocolMetaData metaData = (ProtocolMetaData)this.protocolMetadata.get();
        if (metaData == null) {
            return null;
        }
        TargetsContainer targets = this.locateTargetQualification(qualifiers);
        Secured secured = this.locateSecureQualification(qualifiers);
        if (metaData.hasContext(HTTPContext.class)) {
            HTTPContext context = null;
            context = targets != null ? this.locateNamedHttpContext(metaData, targets.value()) : (HTTPContext)metaData.getContexts(HTTPContext.class).iterator().next();
            if (resource.value() != null && resource.value() != ArquillianResource.class) {
                Servlet servlet = context.getServletByName(resource.value().getSimpleName());
                if (servlet == null) {
                    servlet = context.getServletByName(resource.value().getName());
                }
                if (servlet == null) {
                    return null;
                }
                return this.toURL(servlet, secured);
            }
            if (this.allInSameContext(context.getServlets())) {
                return this.toURL((Servlet)context.getServlets().get(0), secured);
            }
            return this.toURL(context, secured);
        }
        return null;
    }

    private HTTPContext locateNamedHttpContext(ProtocolMetaData metaData, String value) {
        for (HTTPContext context : metaData.getContexts(HTTPContext.class)) {
            if (!value.equals(context.getName())) continue;
            return context;
        }
        throw new IllegalArgumentException("Could not find named context " + value + " in metadata. Please verify your @" + TargetsContainer.class.getName() + " definition");
    }

    private TargetsContainer locateTargetQualification(Annotation[] qualifiers) {
        for (Annotation qualifier : qualifiers) {
            if (!TargetsContainer.class.isAssignableFrom(qualifier.annotationType())) continue;
            return (TargetsContainer)TargetsContainer.class.cast(qualifier);
        }
        return null;
    }

    private Secured locateSecureQualification(Annotation[] qualifiers) {
        for (Annotation qualifier : qualifiers) {
            if (!Secured.class.isAssignableFrom(qualifier.annotationType())) continue;
            return (Secured)Secured.class.cast(qualifier);
        }
        return null;
    }

    private boolean allInSameContext(List<Servlet> servlets) {
        HashSet<String> context = new HashSet<String>();
        for (Servlet servlet : servlets) {
            context.add(servlet.getContextRoot());
        }
        return context.size() == 1;
    }

    private URL toURL(Servlet servlet, Secured secured) {
        try {
            URI baseURI = servlet.getBaseURI();
            String scheme = secured == null ? baseURI.getScheme() : secured.scheme();
            int port = secured == null ? baseURI.getPort() : secured.port();
            return new URI(scheme, baseURI.getUserInfo(), baseURI.getHost(), port, baseURI.getPath(), baseURI.getQuery(), baseURI.getFragment()).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert Servlet to URL, " + servlet, e);
        }
    }

    private URL toURL(HTTPContext context, Secured secured) {
        try {
            String scheme = secured == null ? context.getScheme() : secured.scheme();
            int port = secured == null ? context.getPort() : secured.port();
            return new URI(scheme, null, context.getHost(), port, null, null, null).toURL();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert HTTPContext to URL, " + context, e);
        }
    }
}

