/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.containerelement;

import jakarta.validation.Validator;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ContainerElementConstraintCustomContainerTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ContainerElementConstraintCustomContainerTest.webArchiveBuilder().withTestClass(ContainerElementConstraintCustomContainerTest.class)).build();
    }

    private static Validator getValidatorWithValueExtractor() {
        return TestUtil.getConfigurationUnderTest().addValueExtractor((ValueExtractor)new CustomContainerValueExtractor()).buildValidatorFactory().getValidator();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constraint_specified_on_type_parameter_of_custom_container_gets_validated() {
        TypeWithCustomContainer1 o = new TypeWithCustomContainer1();
        o.container = new CustomContainer<String>("");
        Set constraintViolations = ContainerElementConstraintCustomContainerTest.getValidatorWithValueExtractor().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withProperty("container").withInvalidValue(""));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="d"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constraints_specified_on_custom_container_and_on_type_parameter_of_custom_container_get_validated() {
        TypeWithCustomContainer2 o = new TypeWithCustomContainer2();
        o.container = new CustomContainer<String>("");
        Set constraintViolations = ContainerElementConstraintCustomContainerTest.getValidatorWithValueExtractor().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withProperty("container").withInvalidValue(""));
        o = new TypeWithCustomContainer2();
        o.container = null;
        constraintViolations = ContainerElementConstraintCustomContainerTest.getValidatorWithValueExtractor().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withProperty("container").withInvalidValue(null));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void getter_constraint_provided_on_type_parameter_of_an_custom_container_gets_validated() {
        TypeWithCustomContainer3 o = new TypeWithCustomContainer3();
        o.container = new CustomContainer<String>("");
        Set constraintViolations = ContainerElementConstraintCustomContainerTest.getValidatorWithValueExtractor().validate((Object)o, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withProperty("container").withInvalidValue(""));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void return_value_constraint_provided_on_type_parameter_of_an_custom_container_gets_validated() throws Exception {
        Method method = TypeWithCustomContainer4.class.getDeclaredMethod("returnContainer", new Class[0]);
        Set constraintViolations = ContainerElementConstraintCustomContainerTest.getValidatorWithValueExtractor().forExecutables().validateReturnValue((Object)new TypeWithCustomContainer4(), method, new CustomContainer<String>(""), new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("returnContainer").returnValue()).withInvalidValue(""));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void method_parameter_constraint_provided_as_type_parameter_of_an_custom_container_gets_validated() throws Exception {
        Method method = TypeWithCustomContainer5.class.getDeclaredMethod("setContainer", CustomContainer.class);
        Object[] values = new Object[]{new CustomContainer<String>("")};
        Set constraintViolations = ContainerElementConstraintCustomContainerTest.getValidatorWithValueExtractor().forExecutables().validateParameters((Object)new TypeWithCustomContainer5(), method, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().method("setContainer").parameter("parameter", 0)).withInvalidValue(""));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="a"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="b"), @SpecAssertion(section="constraintdeclarationvalidationprocess-containerelementconstraints", id="c"), @SpecAssertion(section="validationapi-constraintviolation", id="i")})
    public void constructor_parameter_constraint_provided_on_type_parameter_of_an_custom_container_gets_validated() throws Exception {
        Constructor constructor = TypeWithCustomContainer6.class.getDeclaredConstructor(CustomContainer.class);
        Object[] values = new Object[]{new CustomContainer<String>("")};
        Set constraintViolations = ContainerElementConstraintCustomContainerTest.getValidatorWithValueExtractor().forExecutables().validateConstructorParameters(constructor, values, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().constructor(TypeWithCustomContainer6.class).parameter("parameter", 0)).withInvalidValue(""));
    }

    private static class CustomContainerValueExtractor
    implements ValueExtractor<CustomContainer<?>> {
        private CustomContainerValueExtractor() {
        }

        public void extractValues(CustomContainer<?> originalValue, ValueExtractor.ValueReceiver receiver) {
            receiver.value(null, originalValue.property);
        }
    }

    private static class TypeWithCustomContainer1 {
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotBlank CustomContainer<String> container;

        private TypeWithCustomContainer1() {
        }
    }

    private class CustomContainer<T> {
        private T property;

        private CustomContainer(T property) {
            this.property = property;
        }
    }

    private static class TypeWithCustomContainer2 {
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotBlank @NotNull CustomContainer<String> container;

        private TypeWithCustomContainer2() {
        }
    }

    private static class TypeWithCustomContainer3 {
        private CustomContainer<String> container;

        private TypeWithCustomContainer3() {
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotBlank CustomContainer<String> getContainer() {
            return this.container;
        }
    }

    private static class TypeWithCustomContainer4 {
        private CustomContainer<String> container;

        private TypeWithCustomContainer4() {
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotBlank CustomContainer<String> returnContainer() {
            return this.container;
        }
    }

    private static class TypeWithCustomContainer5 {
        private TypeWithCustomContainer5() {
        }

        public void setContainer(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotBlank CustomContainer<String> parameter) {
        }
    }

    private static class TypeWithCustomContainer6 {
        public TypeWithCustomContainer6(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotBlank CustomContainer<String> parameter) {
        }
    }
}

