/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.time;

import jakarta.validation.ClockProvider;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.Future;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.time.ClockProviderPastTest;
import org.hibernate.beanvalidation.tck.tests.time.FixedClockProvider;
import org.hibernate.beanvalidation.tck.tests.time.FutureDummyEntity;
import org.hibernate.beanvalidation.tck.tests.time.FutureRelativePartialDummyEntity;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ClockProviderFutureTest
extends AbstractTCKTest {
    private static final ZoneId TZ_BERLIN = ZoneId.of("Europe/Berlin");

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ClockProviderFutureTest.webArchiveBuilder().withTestClassPackage(ClockProviderPastTest.class)).build();
    }

    @Test
    @SpecAssertion(section="builtinconstraints-future", id="a")
    public void clockProviderIsUsed() {
        FutureDummyEntity dummy = new FutureDummyEntity(ZonedDateTime.of(2099, 1, 12, 5, 0, 0, 0, TZ_BERLIN));
        Validator validator = TestUtil.getValidatorUnderTest();
        ConstraintViolationAssert.assertNoViolations(validator.validate((Object)dummy, new Class[0]));
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(2100, 2, 15, 4, 0, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Future.class).withProperty("date"), ConstraintViolationAssert.violationOf(Future.class).withProperty("calendar"), ConstraintViolationAssert.violationOf(Future.class).withProperty("instant"), ConstraintViolationAssert.violationOf(Future.class).withProperty("hijrahDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("japaneseDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("localDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("localDateTime"), ConstraintViolationAssert.violationOf(Future.class).withProperty("minguoDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("offsetDateTime"), ConstraintViolationAssert.violationOf(Future.class).withProperty("thaiBuddhistDate"), ConstraintViolationAssert.violationOf(Future.class).withProperty("year"), ConstraintViolationAssert.violationOf(Future.class).withProperty("yearMonth"), ConstraintViolationAssert.violationOf(Future.class).withProperty("zonedDateTime"));
    }

    @Test
    @SpecAssertion(section="builtinconstraints-future", id="a")
    public void clockProviderIsUsedForRelativePartials() {
        FutureRelativePartialDummyEntity dummy = new FutureRelativePartialDummyEntity(ZonedDateTime.of(2016, 6, 6, 14, 45, 0, 0, TZ_BERLIN));
        FixedClockProvider clockProvider = new FixedClockProvider(ZonedDateTime.of(2015, 2, 15, 4, 0, 0, 0, TZ_BERLIN));
        ValidatorFactory validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        ConstraintViolationAssert.assertNoViolations(validator.validate((Object)dummy, new Class[0]));
        clockProvider = new FixedClockProvider(ZonedDateTime.of(2016, 8, 17, 17, 45, 0, 0, TZ_BERLIN));
        validatorFactory = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider).buildValidatorFactory();
        validator = validatorFactory.getValidator();
        Set violations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Future.class).withProperty("localTime"), ConstraintViolationAssert.violationOf(Future.class).withProperty("monthDay"), ConstraintViolationAssert.violationOf(Future.class).withProperty("offsetTime"));
    }
}

