/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base;

import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.gjc.util.MethodExecutor;
import com.sun.gjc.util.StatementLeakDetector;
import com.sun.gjc.util.StatementLeakListener;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class StatementWrapper
implements Statement,
StatementLeakListener {
    protected static final Logger _logger = LogDomains.getLogger(MethodExecutor.class, (String)"javax.enterprise.resource.resourceadapter");
    protected Connection connection;
    protected Statement jdbcStatement;
    protected StatementLeakDetector leakDetector;
    private boolean markedForReclaim;
    protected MethodExecutor executor;
    private boolean closeOnCompletion;
    protected AtomicInteger resultSetCount = new AtomicInteger();

    public StatementWrapper(Connection con, Statement statement) {
        this.connection = con;
        this.jdbcStatement = statement;
        this.executor = new MethodExecutor();
        if (!(this instanceof PreparedStatement) && !(this instanceof CallableStatement)) {
            ConnectionHolder wrappedCon = (ConnectionHolder)con;
            this.leakDetector = wrappedCon.getManagedConnection().getLeakDetector();
            if (this.leakDetector != null) {
                this.leakDetector.startStatementLeakTracing(this.jdbcStatement, this);
            }
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.jdbcStatement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.leakDetector != null) {
            this.leakDetector.stopStatementLeakTracing(this.jdbcStatement, this);
        }
        this.jdbcStatement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.jdbcStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.jdbcStatement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.jdbcStatement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.jdbcStatement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.jdbcStatement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.jdbcStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.jdbcStatement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.jdbcStatement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.jdbcStatement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.jdbcStatement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.jdbcStatement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.jdbcStatement.execute(sql);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.jdbcStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.jdbcStatement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.jdbcStatement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.jdbcStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.jdbcStatement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.jdbcStatement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.jdbcStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.jdbcStatement.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.jdbcStatement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.jdbcStatement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.jdbcStatement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public Connection getActualConnection() throws SQLException {
        return this.jdbcStatement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.jdbcStatement.getMoreResults(current);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.jdbcStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.jdbcStatement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.jdbcStatement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.jdbcStatement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.jdbcStatement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.jdbcStatement.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.jdbcStatement.getResultSetHoldability();
    }

    @Override
    public void reclaimStatement() throws SQLException {
        this.markForReclaim(true);
        this.close();
    }

    public void markForReclaim(boolean reclaimStatus) {
        this.markedForReclaim = reclaimStatus;
    }

    public boolean isMarkedForReclaim() {
        return this.markedForReclaim;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        if (this.leakDetector != null) {
            _logger.log(Level.INFO, "jdbc.invalid_operation.close_on_completion");
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.closeOnCompletion = true;
    }

    public void actualCloseOnCompletion() throws SQLException {
        try {
            this.executor.invokeMethod(this.jdbcStatement, "closeOnCompletion", null, new Object[0]);
        }
        catch (ResourceException ex) {
            _logger.log(Level.SEVERE, "jdbc.ex_stmt_wrapper", ex);
            throw new SQLException(ex);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            return (Boolean)this.executor.invokeMethod(this.jdbcStatement, "isCloseOnCompletion", null, new Object[0]);
        }
        catch (ResourceException ex) {
            _logger.log(Level.SEVERE, "jdbc.ex_stmt_wrapper", ex);
            throw new SQLException(ex);
        }
    }

    public boolean getCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    public void incrementResultSetCount() {
        this.resultSetCount.incrementAndGet();
    }

    public void decrementResultSetCount() {
        this.resultSetCount.decrementAndGet();
    }

    public int getResultSetCount() {
        return this.resultSetCount.get();
    }
}

