/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.server.logging.ExcludeFieldsSupport;
import com.sun.enterprise.server.logging.FormatterDelegate;
import com.sun.enterprise.server.logging.GFLogRecord;
import com.sun.enterprise.server.logging.LogEvent;
import com.sun.enterprise.server.logging.LogEventBroadcaster;
import com.sun.enterprise.server.logging.LogEventImpl;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={ODLLogFormatter.class, Formatter.class})
@PerLookup
public class ODLLogFormatter
extends Formatter
implements LogEventBroadcaster {
    private Map<String, ResourceBundle> loggerResourceBundleTable;
    private LogManager logManager;
    private static boolean LOG_SOURCE_IN_KEY_VALUE;
    private static boolean RECORD_NUMBER_IN_KEY_VALUE;
    private static String userID;
    private static String ecID;
    private FormatterDelegate _delegate = null;
    private UniformLogFormatter uniformLogFormatter = new UniformLogFormatter();
    private static final String LINE_SEPARATOR;
    private long recordNumber = 0L;
    private String recordFieldSeparator;
    private String recordDateFormat;
    private LogEventBroadcaster logEventBroadcasterDelegate;
    private boolean multiLineMode;
    private ExcludeFieldsSupport excludeFieldsSupport = new ExcludeFieldsSupport();
    private static final String FIELD_BEGIN_MARKER = "[";
    private static final String FIELD_END_MARKER = "]";
    private static final char FIELD_SEPARATOR = ' ';
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String INDENT = "  ";

    public ODLLogFormatter() {
        this.loggerResourceBundleTable = new HashMap<String, ResourceBundle>();
        this.logManager = LogManager.getLogManager();
    }

    public ODLLogFormatter(FormatterDelegate delegate) {
        this();
        this._delegate = delegate;
    }

    public void setDelegate(FormatterDelegate delegate) {
        this._delegate = delegate;
    }

    @Override
    public String format(LogRecord record) {
        return this.odlLogFormat(record);
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.odlLogFormat(record);
    }

    protected String getProductId() {
        String version = Version.getAbbreviatedVersion() + Version.getVersionPrefix() + Version.getMajorVersion() + "." + Version.getMinorVersion();
        return version;
    }

    private String odlLogFormat(LogRecord record) {
        try {
            LogEventImpl logEvent = new LogEventImpl();
            String message = this.getLogMessage(record);
            if (message == null || message.isEmpty()) {
                return "";
            }
            boolean multiLine = this.multiLineMode || this.isMultiLine(message);
            StringBuilder recordBuffer = new StringBuilder();
            Date date = new Date();
            SimpleDateFormat dateFormatter = new SimpleDateFormat(this.getRecordDateFormat() != null ? this.getRecordDateFormat() : RFC_3339_DATE_FORMAT);
            date.setTime(record.getMillis());
            recordBuffer.append(FIELD_BEGIN_MARKER);
            String timestamp = dateFormatter.format(date);
            logEvent.setTimestamp(timestamp);
            recordBuffer.append(timestamp);
            recordBuffer.append(FIELD_END_MARKER);
            recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            recordBuffer.append(FIELD_BEGIN_MARKER);
            logEvent.setComponentId(this.uniformLogFormatter.getProductId());
            recordBuffer.append(this.uniformLogFormatter.getProductId());
            recordBuffer.append(FIELD_END_MARKER);
            recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            Level logLevel = record.getLevel();
            recordBuffer.append(FIELD_BEGIN_MARKER);
            String odlLevel = logLevel.getName();
            logEvent.setLevel(odlLevel);
            recordBuffer.append(odlLevel);
            recordBuffer.append(FIELD_END_MARKER);
            recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            recordBuffer.append(FIELD_BEGIN_MARKER);
            String msgId = UniformLogFormatter.getMessageId(record);
            recordBuffer.append(msgId == null ? "" : msgId);
            logEvent.setMessageId(msgId);
            recordBuffer.append(FIELD_END_MARKER);
            recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            recordBuffer.append(FIELD_BEGIN_MARKER);
            String loggerName = record.getLoggerName();
            loggerName = loggerName == null ? "" : loggerName;
            recordBuffer.append(loggerName);
            logEvent.setLogger(loggerName);
            recordBuffer.append(FIELD_END_MARKER);
            recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.TID)) {
                recordBuffer.append(FIELD_BEGIN_MARKER);
                recordBuffer.append("tid: _ThreadID=");
                recordBuffer.append(record.getThreadID());
                logEvent.setThreadId(record.getThreadID());
                String threadName = record instanceof GFLogRecord ? ((GFLogRecord)record).getThreadName() : Thread.currentThread().getName();
                recordBuffer.append(" _ThreadName=");
                logEvent.setThreadName(threadName);
                recordBuffer.append(threadName);
                recordBuffer.append(FIELD_END_MARKER);
                recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            }
            if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.USERID) && userID != null && !"".equals(userID.trim())) {
                recordBuffer.append(FIELD_BEGIN_MARKER);
                recordBuffer.append("userId: ");
                logEvent.setUser(userID);
                recordBuffer.append(userID);
                recordBuffer.append(FIELD_END_MARKER);
                recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            }
            if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.ECID) && ecID != null && !"".equals(ecID.trim())) {
                recordBuffer.append(FIELD_BEGIN_MARKER);
                recordBuffer.append("ecid: ");
                logEvent.setECId(ecID);
                recordBuffer.append(ecID);
                recordBuffer.append(FIELD_END_MARKER);
                recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            }
            if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.TIME_MILLIS)) {
                recordBuffer.append(FIELD_BEGIN_MARKER);
                recordBuffer.append("timeMillis: ");
                logEvent.setTimeMillis(record.getMillis());
                recordBuffer.append(record.getMillis());
                recordBuffer.append(FIELD_END_MARKER);
                recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            }
            if (!this.excludeFieldsSupport.isSet(ExcludeFieldsSupport.SupplementalAttribute.LEVEL_VALUE)) {
                recordBuffer.append(FIELD_BEGIN_MARKER);
                recordBuffer.append("levelValue: ");
                logEvent.setLevelValue(logLevel.intValue());
                recordBuffer.append(logLevel.intValue());
                recordBuffer.append(FIELD_END_MARKER);
                recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            }
            if (RECORD_NUMBER_IN_KEY_VALUE) {
                recordBuffer.append(FIELD_BEGIN_MARKER);
                ++this.recordNumber;
                recordBuffer.append("RECORDNUMBER: ");
                logEvent.getSupplementalAttributes().put("RECORDNUMBER", this.recordNumber);
                recordBuffer.append(this.recordNumber);
                recordBuffer.append(FIELD_END_MARKER);
                recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
            }
            Level level = record.getLevel();
            if (LOG_SOURCE_IN_KEY_VALUE || level.intValue() <= Level.FINE.intValue()) {
                String sourceMethodName;
                String sourceClassName = record.getSourceClassName();
                if (sourceClassName != null && !sourceClassName.isEmpty()) {
                    recordBuffer.append(FIELD_BEGIN_MARKER);
                    recordBuffer.append("CLASSNAME: ");
                    logEvent.getSupplementalAttributes().put("CLASSNAME", sourceClassName);
                    recordBuffer.append(sourceClassName);
                    recordBuffer.append(FIELD_END_MARKER);
                    recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
                }
                if ((sourceMethodName = record.getSourceMethodName()) != null && !sourceMethodName.isEmpty()) {
                    recordBuffer.append(FIELD_BEGIN_MARKER);
                    recordBuffer.append("METHODNAME: ");
                    logEvent.getSupplementalAttributes().put("METHODNAME", sourceMethodName);
                    recordBuffer.append(sourceMethodName);
                    recordBuffer.append(FIELD_END_MARKER);
                    recordBuffer.append(this.getRecordFieldSeparator() != null ? this.getRecordFieldSeparator() : Character.valueOf(' '));
                }
            }
            if (this._delegate != null) {
                this._delegate.format(recordBuffer, level);
            }
            if (multiLine) {
                recordBuffer.append(FIELD_BEGIN_MARKER).append(FIELD_BEGIN_MARKER);
                recordBuffer.append(LINE_SEPARATOR);
                recordBuffer.append(INDENT);
            }
            recordBuffer.append(message);
            logEvent.setMessage(message);
            if (multiLine) {
                recordBuffer.append(FIELD_END_MARKER).append(FIELD_END_MARKER);
            }
            recordBuffer.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
            this.informLogEventListeners(logEvent);
            return recordBuffer.toString();
        }
        catch (Exception ex) {
            new ErrorManager().error("Error in formatting Logrecord", ex, 5);
            return "";
        }
    }

    private boolean isMultiLine(String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        String[] lines = message.split(LINE_SEPARATOR);
        return lines.length > 1;
    }

    private String getLogMessage(LogRecord record) throws IOException {
        String logMessage = record.getMessage();
        if (logMessage == null) {
            logMessage = "";
        }
        if (logMessage.indexOf("{0") >= 0 && logMessage.contains("}") && record.getParameters() != null) {
            logMessage = MessageFormat.format(logMessage, record.getParameters());
        } else {
            ResourceBundle rb = this.getResourceBundle(record.getLoggerName());
            if (rb != null && rb.containsKey(logMessage)) {
                try {
                    logMessage = MessageFormat.format(rb.getString(logMessage), record.getParameters());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        Throwable throwable = UniformLogFormatter.getThrowable(record);
        if (throwable != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(logMessage);
            buffer.append(LINE_SEPARATOR);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            pw.close();
            buffer.append(sw.toString());
            logMessage = buffer.toString();
            sw.close();
        }
        return logMessage;
    }

    private synchronized ResourceBundle getResourceBundle(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        ResourceBundle rb = this.loggerResourceBundleTable.get(loggerName);
        if (rb == null && this.logManager.getLogger(loggerName) != null) {
            rb = this.logManager.getLogger(loggerName).getResourceBundle();
            this.loggerResourceBundleTable.put(loggerName, rb);
        }
        return rb;
    }

    public String getRecordFieldSeparator() {
        return this.recordFieldSeparator;
    }

    public void setRecordFieldSeparator(String recordFieldSeparator) {
        this.recordFieldSeparator = recordFieldSeparator;
    }

    public String getRecordDateFormat() {
        return this.recordDateFormat;
    }

    public void setRecordDateFormat(String recordDateFormat) {
        this.recordDateFormat = recordDateFormat;
    }

    public String getMessageWithoutMessageID(String message) {
        String messageID = "";
        if (message.contains(": ")) {
            StringTokenizer st = new StringTokenizer(message, ":");
            messageID = st.nextToken();
            if (messageID.contains(" ")) {
                return message;
            }
            message = st.nextToken();
            return message.substring(1, message.length());
        }
        return message;
    }

    void setLogEventBroadcaster(LogEventBroadcaster logEventBroadcaster) {
        this.logEventBroadcasterDelegate = logEventBroadcaster;
    }

    @Override
    public void informLogEventListeners(LogEvent logEvent) {
        if (this.logEventBroadcasterDelegate != null) {
            this.logEventBroadcasterDelegate.informLogEventListeners(logEvent);
        }
    }

    void setMultiLineMode(boolean value) {
        this.multiLineMode = value;
    }

    void setExcludeFields(String excludeFields) {
        this.excludeFieldsSupport.setExcludeFields(excludeFields);
    }

    static {
        String recordCount;
        LOG_SOURCE_IN_KEY_VALUE = false;
        RECORD_NUMBER_IN_KEY_VALUE = false;
        userID = "";
        ecID = "";
        LINE_SEPARATOR = System.getProperty("line.separator");
        String logSource = System.getProperty("com.sun.aas.logging.keyvalue.logsource");
        if (logSource != null && logSource.equals("true")) {
            LOG_SOURCE_IN_KEY_VALUE = true;
        }
        if ((recordCount = System.getProperty("com.sun.aas.logging.keyvalue.recordnumber")) != null && recordCount.equals("true")) {
            RECORD_NUMBER_IN_KEY_VALUE = true;
        }
        userID = System.getProperty("com.sun.aas.logging.userID");
        ecID = System.getProperty("com.sun.aas.logging.ecID");
    }
}

