/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.impl;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.annotation.impl.ModuleScanner;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.MultiReadableArchive;
import jakarta.ejb.MessageDriven;
import jakarta.ejb.Singleton;
import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.internal.deployment.AnnotationTypesProvider;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="car")
@PerLookup
public class AppClientScanner
extends ModuleScanner<ApplicationClientDescriptor> {
    @Inject
    @Named(value="EJB")
    @Optional
    protected AnnotationTypesProvider ejbProvider;

    @Override
    public void process(ReadableArchive archive, ApplicationClientDescriptor bundleDesc, ClassLoader classLoader, Parser parser) throws IOException {
        this.setParser(parser);
        this.doProcess(archive, bundleDesc, classLoader);
        this.completeProcess(bundleDesc, archive);
        this.calculateResults(bundleDesc);
    }

    public void process(File archiveFile, ApplicationClientDescriptor bundleDesc, ClassLoader classLoader) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    private void doProcess(ReadableArchive archive, ApplicationClientDescriptor desc, ClassLoader classLoader) throws IOException {
        if (AnnotationUtils.getLogger().isLoggable(Level.FINE)) {
            AnnotationUtils.getLogger().fine("archiveFile is " + archive.getURI().toASCIIString());
            AnnotationUtils.getLogger().fine("classLoader is " + classLoader);
        }
        String mainClassName = desc.getMainClassName();
        this.addScanClassName(mainClassName);
        String callbackHandler = desc.getCallbackHandler();
        if (callbackHandler != null && !callbackHandler.trim().equals("")) {
            this.addScanClassName(desc.getCallbackHandler());
        }
        if (archive instanceof FileArchive) {
            this.addScanDirectory(new File(archive.getURI()));
        } else if (archive instanceof InputJarArchive) {
            URI uriToAdd = archive.getURI();
            this.addScanJar(this.scanJar(uriToAdd));
        } else if (archive instanceof MultiReadableArchive) {
            this.addScanURI(this.scanURI(((MultiReadableArchive)archive).getURI(1)));
        }
        this.classLoader = classLoader;
        this.archiveFile = null;
    }

    private File scanJar(URI uriToAdd) {
        return new File(uriToAdd);
    }

    private URI scanURI(URI uriToAdd) throws IOException {
        if (uriToAdd.getScheme().equals("jar")) {
            try {
                uriToAdd = new URI("file", uriToAdd.getSchemeSpecificPart(), null);
            }
            catch (URISyntaxException ex) {
                throw new IOException(ex);
            }
        }
        return uriToAdd;
    }

    @Override
    protected void calculateResults(ApplicationClientDescriptor bundleDesc) {
        super.calculateResults(bundleDesc);
        Class[] ejbAnnotations = this.ejbProvider != null ? this.ejbProvider.getAnnotationTypes() : new Class[]{Stateful.class, Stateless.class, MessageDriven.class, Singleton.class};
        HashSet<String> toBeRemoved = new HashSet<String>();
        ParsingContext context = this.classParser.getContext();
        for (Class ejbAnnotation : ejbAnnotations) {
            Type type = context.getTypes().getBy(ejbAnnotation.getName());
            if (type == null || !(type instanceof AnnotationType)) continue;
            AnnotationType at = (AnnotationType)type;
            for (AnnotatedElement ae : at.allAnnotatedTypes()) {
                Object t = ae instanceof Member ? ((Member)ae).getDeclaringType() : (Type)ae;
                if (!t.wasDefinedIn((Collection)this.scannedURI)) continue;
                toBeRemoved.add(t.getName());
            }
        }
        for (String element : toBeRemoved) {
            this.entries.remove(element);
        }
    }
}

