/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.enterprise.loader.ASURLClassLoader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClassGenerator {
    private static final Logger LOG = Logger.getLogger(ClassGenerator.class.getName());
    private static Method defineClassMethod;
    private static Method defineClassMethodSM;

    private ClassGenerator() {
    }

    public static Class<?> defineClass(ClassLoader loader, Class<?> anchorClass, String targetPackageName, String className, byte[] classData) {
        if (ClassGenerator.useMethodHandles(loader, anchorClass, targetPackageName)) {
            return ClassGenerator.defineClass(anchorClass, className, classData);
        }
        if (System.getSecurityManager() == null) {
            return ClassGenerator.defineClass(loader, className, classData, anchorClass.getProtectionDomain());
        }
        return ClassGenerator.defineClass(loader, className, classData);
    }

    public static Class<?> defineClass(Class<?> anchorClass, String className, byte[] classData) {
        LOG.log(Level.CONFIG, "Defining class: {0} with anchorClass: {1}", new Object[]{className, anchorClass});
        PrivilegedAction<Class> action = () -> {
            try {
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(anchorClass, MethodHandles.lookup());
                return lookup.defineClass(classData);
            }
            catch (IllegalAccessException e) {
                throw new ClassDefinitionException(className, anchorClass, (Throwable)e);
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] classData) throws ClassDefinitionException {
        return ClassGenerator.defineClass(loader, className, classData, 0, classData.length);
    }

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] classData, int offset, int length) throws ClassDefinitionException {
        LOG.log(Level.CONFIG, "Defining class: {0} by loader: {1}", new Object[]{className, loader});
        PrivilegedAction<Class> action = () -> {
            try {
                return (Class)defineClassMethod.invoke((Object)loader, className, classData, 0, length);
            }
            catch (ClassFormatError | Exception | NoClassDefFoundError e) {
                throw new ClassDefinitionException(className, loader, e);
            }
        };
        return AccessController.doPrivileged(action);
    }

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] classData, ProtectionDomain protectionDomain) throws ClassDefinitionException {
        return ClassGenerator.defineClass(loader, className, classData, 0, classData.length, protectionDomain);
    }

    public static Class<?> defineClass(ClassLoader loader, String className, byte[] classData, int offset, int length, ProtectionDomain protectionDomain) throws ClassDefinitionException {
        LOG.log(Level.CONFIG, "Defining class: {0} by loader: {1}", new Object[]{className, loader});
        PrivilegedAction<Class> action = () -> {
            try {
                return (Class)defineClassMethodSM.invoke((Object)loader, className, classData, 0, length, protectionDomain);
            }
            catch (ClassFormatError | Exception | NoClassDefFoundError e) {
                throw new ClassDefinitionException(className, loader, e);
            }
        };
        return AccessController.doPrivileged(action);
    }

    private static boolean useMethodHandles(ClassLoader loader, Class<?> anchorClass, String targetPackageName) {
        if (loader == null) {
            return true;
        }
        if (anchorClass == null || loader.getParent() == null || loader.getClass() == ASURLClassLoader.class) {
            return false;
        }
        return Objects.equals(targetPackageName, anchorClass.getPackageName());
    }

    static {
        try {
            PrivilegedExceptionAction<Void> action = () -> {
                Class<?> cl = Class.forName("java.lang.ClassLoader");
                String name = "defineClass";
                defineClassMethod = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                defineClassMethod.setAccessible(true);
                defineClassMethodSM = cl.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                defineClassMethodSM.setAccessible(true);
                return null;
            };
            AccessController.doPrivileged(action);
            LOG.config("ClassLoader methods capable of generating classes were successfully detected.");
        }
        catch (Exception e) {
            throw new Error("Could not initialize access to ClassLoader.defineClass method.", e);
        }
    }

    public static class ClassDefinitionException
    extends RuntimeException {
        private static final long serialVersionUID = -8955780830818904365L;

        ClassDefinitionException(String className, ClassLoader loader, Throwable cause) {
            super("Could not define class '" + className + "' by the class loader: " + loader, cause);
        }

        ClassDefinitionException(String className, Class<?> anchorClass, Throwable cause) {
            super("Could not define class '" + className + "' using the anchor " + anchorClass, cause);
        }
    }
}

