/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.common;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.util.DOLUtils;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.ResourceInfo;

public class PersistenceHelper {
    private static final System.Logger LOGGER = System.getLogger(PersistenceHelper.class.getName());

    public static DataSource lookupNonTxResource(ConnectorRuntime connectorRuntime, DeploymentContext ctx, SimpleJndiName dataSourceName) throws NamingException {
        return (DataSource)connectorRuntime.lookupNonTxResource(PersistenceHelper.getResourceInfo(ctx, dataSourceName), true);
    }

    public static DataSource lookupPMResource(ConnectorRuntime connectorRuntime, DeploymentContext ctx, SimpleJndiName dataSourceName) throws NamingException {
        return (DataSource)DataSource.class.cast(connectorRuntime.lookupPMResource(PersistenceHelper.getResourceInfo(ctx, dataSourceName), true));
    }

    private static ResourceInfo getResourceInfo(DeploymentContext ctx, SimpleJndiName dataSourceName) {
        if (ctx != null) {
            dataSourceName = PersistenceHelper.translateResourceReference(ctx, dataSourceName);
        }
        if (dataSourceName.isJavaApp()) {
            String applicationName = ctx.getCommandParameters(OpsParams.class).name();
            return new ResourceInfo(dataSourceName, applicationName);
        }
        return new ResourceInfo(dataSourceName);
    }

    private static SimpleJndiName translateResourceReference(DeploymentContext ctx, SimpleJndiName dataSourceName) {
        BundleDescriptor currentBundle = DOLUtils.getCurrentBundleForContext(ctx);
        if (currentBundle instanceof ResourceReferenceContainer) {
            ResourceReferenceContainer referenceContainer = (ResourceReferenceContainer)((Object)currentBundle);
            try {
                return referenceContainer.getResourceReferenceByName(dataSourceName.toString()).getJndiName();
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(System.Logger.Level.DEBUG, () -> "Datasource name " + String.valueOf(dataSourceName) + " is not a reference, will use it as a JNDI name. Error: " + e.getMessage(), (Throwable)e);
                return dataSourceName;
            }
        }
        return dataSourceName;
    }
}

