/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.ClientRequestInfoImpl;
import com.sun.corba.ee.impl.interceptors.IORInfoImpl;
import com.sun.corba.ee.impl.interceptors.InterceptorList;
import com.sun.corba.ee.impl.interceptors.PICurrent;
import com.sun.corba.ee.impl.interceptors.ServerRequestInfoImpl;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.logging.InterceptorsSystemException;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.TraceInterceptor;
import java.util.Arrays;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.IORInterceptor_3_0;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@TraceInterceptor
public class InterceptorInvoker {
    private ORB orb;
    private static final InterceptorsSystemException wrapper = InterceptorsSystemException.self;
    private InterceptorList interceptorList;
    private boolean enabled = false;
    private PICurrent current;

    InterceptorInvoker(ORB orb, InterceptorList interceptorList, PICurrent piCurrent) {
        this.orb = orb;
        this.interceptorList = interceptorList;
        this.enabled = false;
        this.current = piCurrent;
    }

    synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    synchronized boolean getEnabled() {
        return this.enabled;
    }

    @TraceInterceptor
    void objectAdapterCreated(ObjectAdapter oa) {
        if (this.getEnabled()) {
            IORInterceptor interceptor;
            int i;
            IORInfoImpl info = new IORInfoImpl(oa);
            IORInterceptor[] iorInterceptors = (IORInterceptor[])this.interceptorList.getInterceptors(2);
            int size = iorInterceptors.length;
            for (i = size - 1; i >= 0; --i) {
                interceptor = iorInterceptors[i];
                try {
                    interceptor.establish_components((IORInfo)info);
                    continue;
                }
                catch (Exception e) {
                    wrapper.ignoredExceptionInEstablishComponents(e, oa);
                }
            }
            info.makeStateEstablished();
            for (i = size - 1; i >= 0; --i) {
                interceptor = iorInterceptors[i];
                if (!(interceptor instanceof IORInterceptor_3_0)) continue;
                IORInterceptor_3_0 interceptor30 = (IORInterceptor_3_0)interceptor;
                try {
                    interceptor30.components_established((IORInfo)info);
                    continue;
                }
                catch (Exception exc) {
                    wrapper.exceptionInComponentsEstablished(exc, oa);
                }
            }
            info.makeStateDone();
        }
    }

    @TraceInterceptor
    void adapterManagerStateChanged(int managerId, short newState) {
        if (this.getEnabled()) {
            IORInterceptor[] interceptors = (IORInterceptor[])this.interceptorList.getInterceptors(2);
            int size = interceptors.length;
            for (int i = size - 1; i >= 0; --i) {
                try {
                    IORInterceptor interceptor = interceptors[i];
                    if (!(interceptor instanceof IORInterceptor_3_0)) continue;
                    IORInterceptor_3_0 interceptor30 = (IORInterceptor_3_0)interceptor;
                    interceptor30.adapter_manager_state_changed(managerId, newState);
                    continue;
                }
                catch (Exception exc) {
                    wrapper.ignoredExceptionInAdapterManagerStateChanged(exc, managerId, newState);
                }
            }
        }
    }

    @TraceInterceptor
    void adapterStateChanged(ObjectReferenceTemplate[] templates, short newState) {
        if (this.getEnabled()) {
            IORInterceptor[] interceptors = (IORInterceptor[])this.interceptorList.getInterceptors(2);
            int size = interceptors.length;
            for (int i = size - 1; i >= 0; --i) {
                try {
                    IORInterceptor interceptor = interceptors[i];
                    if (!(interceptor instanceof IORInterceptor_3_0)) continue;
                    IORInterceptor_3_0 interceptor30 = (IORInterceptor_3_0)interceptor;
                    interceptor30.adapter_state_changed(templates, newState);
                    continue;
                }
                catch (Exception exc) {
                    wrapper.ignoredExceptionInAdapterStateChanged(exc, Arrays.asList(templates), newState);
                }
            }
        }
    }

    @InfoMethod
    private void invokeClientStartingCall(String name) {
    }

    @InfoMethod
    private void invokeClientStartingForwardRequest(String name) {
    }

    @InfoMethod
    private void invokeClientStartingSystemException(String name, SystemException exc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TraceInterceptor
    void invokeClientInterceptorStartingPoint(ClientRequestInfoImpl info) {
        info.interceptorsEnabledForThisRequest = this.getEnabled();
        if (info.interceptorsEnabledForThisRequest) {
            try {
                int size;
                this.current.pushSlotTable();
                info.setPICurrentPushed(true);
                info.setCurrentExecutionPoint(0);
                ClientRequestInterceptor[] clientInterceptors = (ClientRequestInterceptor[])this.interceptorList.getInterceptors(0);
                int flowStackIndex = size = clientInterceptors.length;
                boolean continueProcessing = true;
                for (int i = 0; continueProcessing && i < size; ++i) {
                    ClientRequestInterceptor cri = clientInterceptors[i];
                    try {
                        this.invokeClientStartingCall(cri.name());
                        cri.send_request((ClientRequestInfo)info);
                        continue;
                    }
                    catch (ForwardRequest e) {
                        this.invokeClientStartingForwardRequest(cri.name());
                        flowStackIndex = i;
                        info.setForwardRequest(e);
                        info.setEndingPointCall(2);
                        info.setReplyStatus((short)3);
                        this.updateClientRequestDispatcherForward(info);
                        continueProcessing = false;
                        continue;
                    }
                    catch (SystemException e) {
                        this.invokeClientStartingSystemException(cri.name(), e);
                        flowStackIndex = i;
                        info.setEndingPointCall(1);
                        info.setReplyStatus((short)1);
                        info.setException((Exception)((java.lang.Object)e));
                        continueProcessing = false;
                    }
                }
                info.setFlowStackIndex(flowStackIndex);
            }
            finally {
                this.current.resetSlotTable();
            }
        }
    }

    private String getClientEndMethodName(int endingPointCall) {
        switch (endingPointCall) {
            case 0: {
                return "receive_reply";
            }
            case 1: {
                return "receive_exception";
            }
            case 2: {
                return "receive_other";
            }
        }
        return "";
    }

    @InfoMethod
    private void invokeClientEndingCall(String name, String call) {
    }

    @InfoMethod
    private void invokeClientEndingForwardRequest(String name) {
    }

    @InfoMethod
    private void invokeClientEndingSystemException(String name, SystemException exc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TraceInterceptor
    void invokeClientInterceptorEndingPoint(ClientRequestInfoImpl info) {
        if (info.interceptorsEnabledForThisRequest) {
            try {
                info.setCurrentExecutionPoint(2);
                ClientRequestInterceptor[] clientInterceptors = (ClientRequestInterceptor[])this.interceptorList.getInterceptors(0);
                int flowStackIndex = info.getFlowStackIndex();
                int endingPointCall = info.getEndingPointCall();
                if (endingPointCall == 0 && info.getIsOneWay()) {
                    endingPointCall = 2;
                    info.setEndingPointCall(endingPointCall);
                }
                for (int i = flowStackIndex - 1; i >= 0; --i) {
                    ClientRequestInterceptor cri = clientInterceptors[i];
                    try {
                        this.invokeClientEndingCall(cri.name(), this.getClientEndMethodName(endingPointCall));
                        switch (endingPointCall) {
                            case 0: {
                                cri.receive_reply((ClientRequestInfo)info);
                                break;
                            }
                            case 1: {
                                cri.receive_exception((ClientRequestInfo)info);
                                break;
                            }
                            case 2: {
                                cri.receive_other((ClientRequestInfo)info);
                            }
                        }
                        continue;
                    }
                    catch (ForwardRequest e) {
                        this.invokeClientEndingForwardRequest(cri.name());
                        endingPointCall = 2;
                        info.setEndingPointCall(endingPointCall);
                        info.setReplyStatus((short)3);
                        info.setForwardRequest(e);
                        this.updateClientRequestDispatcherForward(info);
                        continue;
                    }
                    catch (SystemException e) {
                        this.invokeClientEndingSystemException(cri.name(), e);
                        endingPointCall = 1;
                        info.setEndingPointCall(endingPointCall);
                        info.setReplyStatus((short)1);
                        info.setException((Exception)((java.lang.Object)e));
                    }
                }
            }
            finally {
                if (info.isPICurrentPushed()) {
                    this.current.popSlotTable();
                }
            }
        }
    }

    @InfoMethod
    private void invokeServerStartingCall(String name) {
    }

    @InfoMethod
    private void invokeServerStartingForwardRequest(String name) {
    }

    @InfoMethod
    private void invokeServerStartingSystemException(String name, SystemException exc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TraceInterceptor
    void invokeServerInterceptorStartingPoint(ServerRequestInfoImpl info) {
        info.interceptorsEnabledForThisRequest = this.getEnabled();
        if (info.interceptorsEnabledForThisRequest) {
            try {
                int size;
                this.current.pushSlotTable();
                info.setSlotTable(this.current.getSlotTable());
                this.current.pushSlotTable();
                info.setCurrentExecutionPoint(0);
                ServerRequestInterceptor[] serverInterceptors = (ServerRequestInterceptor[])this.interceptorList.getInterceptors(1);
                int flowStackIndex = size = serverInterceptors.length;
                boolean continueProcessing = true;
                for (int i = 0; continueProcessing && i < size; ++i) {
                    ServerRequestInterceptor sri = serverInterceptors[i];
                    try {
                        this.invokeServerStartingCall(sri.name());
                        sri.receive_request_service_contexts((ServerRequestInfo)info);
                        continue;
                    }
                    catch (ForwardRequest e) {
                        this.invokeServerStartingForwardRequest(sri.name());
                        flowStackIndex = i;
                        info.setForwardRequest(e);
                        info.setIntermediatePointCall(1);
                        info.setEndingPointCall(2);
                        info.setReplyStatus((short)3);
                        continueProcessing = false;
                        continue;
                    }
                    catch (SystemException e) {
                        this.invokeServerStartingSystemException(sri.name(), e);
                        flowStackIndex = i;
                        info.setException((Exception)((java.lang.Object)e));
                        info.setIntermediatePointCall(1);
                        info.setEndingPointCall(1);
                        info.setReplyStatus((short)1);
                        continueProcessing = false;
                    }
                }
                info.setFlowStackIndex(flowStackIndex);
            }
            finally {
                this.current.popSlotTable();
            }
        }
    }

    @InfoMethod
    private void invokeServerIntermediateCall(String name) {
    }

    @InfoMethod
    private void invokeServerIntermediateForwardRequest(String name) {
    }

    @InfoMethod
    private void invokeServerIntermediateSystemException(String name, SystemException exc) {
    }

    @TraceInterceptor
    void invokeServerInterceptorIntermediatePoint(ServerRequestInfoImpl info) {
        int intermediatePointCall = info.getIntermediatePointCall();
        if (info.interceptorsEnabledForThisRequest && intermediatePointCall != 1) {
            info.setCurrentExecutionPoint(1);
            for (ServerRequestInterceptor sri : (ServerRequestInterceptor[])this.interceptorList.getInterceptors(1)) {
                try {
                    this.invokeServerIntermediateCall(sri.name());
                    sri.receive_request((ServerRequestInfo)info);
                }
                catch (ForwardRequest e) {
                    this.invokeServerIntermediateForwardRequest(sri.name());
                    info.setForwardRequest(e);
                    info.setEndingPointCall(2);
                    info.setReplyStatus((short)3);
                    break;
                }
                catch (SystemException e) {
                    this.invokeServerIntermediateSystemException(sri.name(), e);
                    info.setException((Exception)((java.lang.Object)e));
                    info.setEndingPointCall(1);
                    info.setReplyStatus((short)1);
                    break;
                }
            }
        }
    }

    private String getServerEndMethodName(int endingPointCall) {
        switch (endingPointCall) {
            case 0: {
                return "send_reply";
            }
            case 1: {
                return "send_exception";
            }
            case 2: {
                return "send_other";
            }
        }
        return "";
    }

    @InfoMethod
    private void serverInvokeEndingPoint(String name, String call) {
    }

    @InfoMethod
    private void caughtForwardRequest(String name) {
    }

    @InfoMethod
    private void caughtSystemException(String name, SystemException ex) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TraceInterceptor
    void invokeServerInterceptorEndingPoint(ServerRequestInfoImpl info) {
        if (info.interceptorsEnabledForThisRequest) {
            try {
                ServerRequestInterceptor[] serverInterceptors = (ServerRequestInterceptor[])this.interceptorList.getInterceptors(1);
                int flowStackIndex = info.getFlowStackIndex();
                int endingPointCall = info.getEndingPointCall();
                for (int i = flowStackIndex - 1; i >= 0; --i) {
                    ServerRequestInterceptor sri = serverInterceptors[i];
                    try {
                        this.serverInvokeEndingPoint(sri.name(), this.getServerEndMethodName(endingPointCall));
                        switch (endingPointCall) {
                            case 0: {
                                sri.send_reply((ServerRequestInfo)info);
                                break;
                            }
                            case 1: {
                                sri.send_exception((ServerRequestInfo)info);
                                break;
                            }
                            case 2: {
                                sri.send_other((ServerRequestInfo)info);
                            }
                        }
                        continue;
                    }
                    catch (ForwardRequest e) {
                        this.caughtForwardRequest(sri.name());
                        endingPointCall = 2;
                        info.setEndingPointCall(endingPointCall);
                        info.setForwardRequest(e);
                        info.setReplyStatus((short)3);
                        info.setForwardRequestRaisedInEnding();
                        continue;
                    }
                    catch (SystemException e) {
                        this.caughtSystemException(sri.name(), e);
                        endingPointCall = 1;
                        info.setEndingPointCall(endingPointCall);
                        info.setException((Exception)((java.lang.Object)e));
                        info.setReplyStatus((short)1);
                    }
                }
                info.setAlreadyExecuted(true);
            }
            finally {
                this.current.popSlotTable();
            }
        }
    }

    @TraceInterceptor
    private void updateClientRequestDispatcherForward(ClientRequestInfoImpl info) {
        ForwardRequest forwardRequest = info.getForwardRequestException();
        if (forwardRequest != null) {
            Object object = forwardRequest.forward;
            IOR ior = this.orb.getIOR(object, false);
            info.setLocatedIOR(ior);
        }
    }
}

