/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.spi.TransactionSupport;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.ResourcePrincipalDescriptor;
import com.sun.enterprise.deployment.runtime.connector.ResourceAdapter;
import com.sun.enterprise.deployment.runtime.connector.SunConnector;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.TransactionSupport;
import jakarta.resource.spi.security.PasswordCredential;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.jvnet.hk2.config.types.Property;

public final class ConnectionPoolObjectsUtils {
    public static final String ELEMENT_PROPERTY = "ElementProperty";
    private static final Logger LOG = LogDomains.getLogger(ConnectionPoolObjectsUtils.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static final String VALIDATE_ATMOST_EVERY_IDLE_SECS = "com.sun.enterprise.connectors.ValidateAtmostEveryIdleSecs";
    private static final String validateAtmostEveryIdleSecsProperty = System.getProperty("com.sun.enterprise.connectors.ValidateAtmostEveryIdleSecs");
    private static final StringManager localStrings = StringManager.getManager(ConnectionPoolObjectsUtils.class);

    private ConnectionPoolObjectsUtils() {
    }

    public static ConnectorConnectionPool createDefaultConnectorPoolObject(PoolInfo poolInfo, String rarName) {
        ConnectorConnectionPool connectorPoolObj = new ConnectorConnectionPool(poolInfo);
        connectorPoolObj.setMaxPoolSize("20");
        connectorPoolObj.setSteadyPoolSize("10");
        connectorPoolObj.setMaxWaitTimeInMillis("7889");
        connectorPoolObj.setIdleTimeoutInSeconds("789");
        connectorPoolObj.setPoolResizeQuantity("2");
        connectorPoolObj.setFailAllConnections(false);
        connectorPoolObj.setMatchConnections(true);
        ConnectionPoolObjectsUtils.setDefaultAdvancedPoolAttributes(connectorPoolObj);
        try {
            connectorPoolObj.setTransactionSupport(ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(rarName));
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "error in setting txSupport", e);
        }
        return connectorPoolObj;
    }

    private static void setDefaultAdvancedPoolAttributes(ConnectorConnectionPool connectorPoolObj) {
        connectorPoolObj.setMaxConnectionUsage("0");
        connectorPoolObj.setConnectionLeakTracingTimeout("0");
        connectorPoolObj.setConCreationRetryAttempts("0");
        connectorPoolObj.setConCreationRetryInterval("10");
        connectorPoolObj.setValidateAtmostOncePeriod("0");
    }

    public static ConnectorConnectionPool createSunRaConnectorPoolObject(PoolInfo poolInfo, ConnectorDescriptor desc, String rarName) {
        boolean validateAtmostEveryIdleSecs;
        ConnectorConnectionPool connectorPoolObj = new ConnectorConnectionPool(poolInfo);
        SunConnector sundesc = desc.getSunDescriptor();
        ResourceAdapter sunRAXML = sundesc.getResourceAdapter();
        connectorPoolObj.setMaxPoolSize((String)sunRAXML.getValue("MaxPoolSize"));
        connectorPoolObj.setSteadyPoolSize((String)sunRAXML.getValue("SteadyPoolSize"));
        connectorPoolObj.setMaxWaitTimeInMillis((String)sunRAXML.getValue("MaxWaitTimeInMillis"));
        connectorPoolObj.setIdleTimeoutInSeconds((String)sunRAXML.getValue("IdleTimeoutInSeconds"));
        connectorPoolObj.setPoolResizeQuantity("2");
        connectorPoolObj.setFailAllConnections(false);
        connectorPoolObj.setMatchConnections(true);
        ConnectionPoolObjectsUtils.setDefaultAdvancedPoolAttributes(connectorPoolObj);
        try {
            connectorPoolObj.setTransactionSupport(ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(rarName));
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "error in setting txSupport");
        }
        if (validateAtmostEveryIdleSecsProperty != null && validateAtmostEveryIdleSecsProperty.equalsIgnoreCase("TRUE")) {
            validateAtmostEveryIdleSecs = true;
            LOG.log(Level.FINE, "CCP.ValidateAtmostEveryIdleSecs.Set. PoolInfo {0}", poolInfo);
        } else {
            validateAtmostEveryIdleSecs = false;
        }
        connectorPoolObj.setValidateAtmostEveryIdleSecs(validateAtmostEveryIdleSecs);
        return connectorPoolObj;
    }

    public static int convertSpecTxSupportToContainerTxSupport(TransactionSupport.TransactionSupportLevel mcfTS) {
        int containerEquivalentValue;
        switch (mcfTS) {
            case LocalTransaction: {
                containerEquivalentValue = 1;
                break;
            }
            case NoTransaction: {
                containerEquivalentValue = 0;
                break;
            }
            case XATransaction: {
                containerEquivalentValue = 2;
                break;
            }
            default: {
                containerEquivalentValue = -1;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("convertSpecTxSupportToContainerTxSupport: passed in mcfTransactionSupport =>" + String.valueOf(mcfTS) + ", converted container equivalent value: " + containerEquivalentValue);
        }
        return containerEquivalentValue;
    }

    public static int parseTransactionSupportString(String txSupport) {
        int txSupportIntVal = -1;
        if (txSupport == null) {
            LOG.fine("txSupport is null");
            return txSupportIntVal;
        }
        LOG.log(Level.FINE, "parseTransactionSupportString: passed in txSupport => {0}", txSupport);
        if ("NoTransaction".equals(txSupport)) {
            return 0;
        }
        if ("LocalTransaction".equals(txSupport)) {
            return 1;
        }
        if ("XATransaction".equals(txSupport)) {
            return 2;
        }
        return txSupportIntVal;
    }

    public static boolean isTxSupportConfigurationSane(int txSupport, String raName) {
        int raXmlTxSupport = -1;
        try {
            raXmlTxSupport = ConnectionPoolObjectsUtils.getTransactionSupportFromRaXml(raName);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "getTransactionSupportFromRaXml", e);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "isTxSupportConfigSane:: txSupport => " + txSupport + "  raXmlTxSupport => " + raXmlTxSupport);
        }
        return txSupport <= raXmlTxSupport;
    }

    public static TransactionSupport getTransactionSupport(int ts) {
        switch (ts) {
            case 0: {
                return TransactionSupport.NO_TRANSACTION;
            }
            case 1: {
                return TransactionSupport.LOCAL_TRANSACTION;
            }
            case 2: {
                return TransactionSupport.XA_TRANSACTION;
            }
        }
        return null;
    }

    public static String getValueFromMCF(String prop, PoolInfo poolInfo, ManagedConnectionFactory mcf) {
        String result = null;
        try {
            Method m = mcf.getClass().getMethod("get" + prop, null);
            result = (String)m.invoke((Object)mcf, (Object[])null);
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, t.getMessage(), t);
        }
        return result == null ? "" : result;
    }

    public static Subject createSubject(ManagedConnectionFactory mcf, ResourcePrincipalDescriptor principalDescriptor) {
        Subject tempSubject = new Subject();
        if (principalDescriptor == null) {
            return tempSubject;
        }
        PasswordCredential pc = principalDescriptor.toPasswordCredential();
        if (pc != null) {
            pc.setManagedConnectionFactory(mcf);
            PrivilegedAction<Void> action = () -> {
                tempSubject.getPrincipals().add((Principal)principalDescriptor.toPrincipalNameAndPassword());
                tempSubject.getPrivateCredentials().add(pc);
                return null;
            };
            AccessController.doPrivileged(action);
        }
        return tempSubject;
    }

    public static boolean isPoolSystemPool(org.glassfish.connectors.config.ConnectorConnectionPool domainCcp) {
        String poolName = domainCcp.getName();
        return ConnectionPoolObjectsUtils.isPoolSystemPool(poolName);
    }

    public static boolean isPoolSystemPool(String poolName) {
        Pattern pattern = Pattern.compile("#");
        Matcher matcher = pattern.matcher(poolName);
        if (!matcher.find()) {
            return false;
        }
        matcher.reset();
        String moduleNameFromPoolName = null;
        int matchCount = 0;
        while (matcher.find()) {
            ++matchCount;
            int patternStart = matcher.start();
            moduleNameFromPoolName = poolName.substring(0, patternStart);
        }
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        switch (matchCount) {
            case 1: {
                if (!resUtil.belongToStandAloneRar(moduleNameFromPoolName)) break;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setLazyEnlistAndLazyAssocProperties(String lazyAssocString, List<Property> properties, ConnectorConnectionPool conConnPool) {
        if (properties == null) {
            return;
        }
        Property lazyEnlistElement = null;
        for (Property property : properties) {
            if (!property.getName().equalsIgnoreCase("LAZYCONNECTIONENLISTMENT")) continue;
            lazyEnlistElement = property;
        }
        boolean lazyAssoc = ConnectionPoolObjectsUtils.toBoolean(lazyAssocString, false);
        if (lazyEnlistElement == null) {
            if (lazyAssoc) {
                conConnPool.setLazyConnectionAssoc(true);
                conConnPool.setLazyConnectionEnlist(true);
                return;
            }
            conConnPool.setLazyConnectionAssoc(false);
            return;
        }
        boolean lazyEnlist = ConnectionPoolObjectsUtils.toBoolean(lazyEnlistElement.getValue(), false);
        if (!lazyAssoc) {
            conConnPool.setLazyConnectionAssoc(false);
            return;
        }
        if (lazyEnlist) {
            conConnPool.setLazyConnectionAssoc(true);
            conConnPool.setLazyConnectionEnlist(true);
            return;
        }
        LOG.log(Level.SEVERE, "conn_pool_obj_utils.lazy_enlist-lazy_assoc-invalid-combination", conConnPool.getName());
        String i18nMsg = localStrings.getString("cpou.lazy_enlist-lazy_assoc-invalid-combination");
        throw new RuntimeException(i18nMsg + String.valueOf(conConnPool.getName()));
    }

    private static boolean toBoolean(Object prop, boolean defaultVal) {
        if (prop == null) {
            return defaultVal;
        }
        return Boolean.valueOf(((String)prop).toLowerCase(Locale.getDefault()));
    }

    public static int getTransactionSupportFromRaXml(String rarName) throws ConnectorRuntimeException {
        ConnectorDescriptor descriptor = ConnectorRuntime.getRuntime().getConnectorDescriptor(rarName);
        String txSupport = descriptor.getOutboundResourceAdapter().getTransSupport();
        return ConnectionPoolObjectsUtils.parseTransactionSupportString(txSupport);
    }
}

