/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.signing;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.signing.ExternalProcessRunner;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

class ExternalGpg {
    private static String gpg;

    ExternalGpg() {
    }

    static synchronized String getGpg() {
        if (gpg == null) {
            gpg = ExternalGpg.findGpg();
        }
        return gpg.isEmpty() ? null : gpg;
    }

    private static String findGpg() {
        String bash;
        SystemReader system = SystemReader.getInstance();
        String path = system.getenv("PATH");
        String exe = null;
        if (system.isMacOS() && (bash = ExternalGpg.searchPath(path, "bash")) != null) {
            ProcessBuilder process = new ProcessBuilder(new String[0]);
            process.command(bash, "--login", "-c", "which gpg");
            process.directory(FS.DETECTED.userHome());
            String[] result = new String[1];
            try {
                ExternalProcessRunner.run(process, null, b -> {
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try (BufferedReader r = new BufferedReader(new InputStreamReader(b.openInputStream(), SystemReader.getInstance().getDefaultCharset()));){
                        stringArray[0] = r.readLine();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }, null);
            }
            catch (IOException | CanceledException e) {
                Activator.logWarning(CoreText.ExternalGpgSigner_cannotSearch, e);
            }
            exe = result[0];
        }
        if (exe == null) {
            exe = ExternalGpg.searchPath(path, system.isWindows() ? "gpg.exe" : "gpg");
        }
        return exe == null ? "" : exe;
    }

    private static String searchPath(String path, String name) {
        if (StringUtils.isEmptyOrNull((String)path)) {
            return null;
        }
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            File exe = new File(p, name);
            try {
                if (exe.isFile() && exe.canExecute()) {
                    return exe.getAbsolutePath();
                }
            }
            catch (SecurityException e) {
                Activator.logWarning(MessageFormat.format(CoreText.ExternalGpgSigner_skipNotAccessiblePath, exe.getPath()), e);
            }
            ++n2;
        }
        return null;
    }
}

