/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.TransformingGraphics;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicVertexLabelRenderer<V, E>
implements Renderer.VertexLabel<V, E> {
    protected Renderer.VertexLabel.Position position = Renderer.VertexLabel.Position.SE;
    private Renderer.VertexLabel.Positioner positioner = new OutsidePositioner();

    public BasicVertexLabelRenderer() {
    }

    public BasicVertexLabelRenderer(Renderer.VertexLabel.Position position) {
        this.position = position;
    }

    @Override
    public Renderer.VertexLabel.Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Renderer.VertexLabel.Position position) {
        this.position = position;
    }

    public Component prepareRenderer(RenderContext<V, E> rc, VertexLabelRenderer graphLabelRenderer, Object value, boolean isSelected, V vertex) {
        return rc.getVertexLabelRenderer().getVertexLabelRendererComponent(rc.getScreenDevice(), value, (Font)rc.getVertexFontTransformer().transform(vertex), isSelected, vertex);
    }

    @Override
    public void labelVertex(RenderContext<V, E> rc, Layout<V, E> layout, V v, String label) {
        BidirectionalTransformer transformer;
        Graph graph = layout.getGraph();
        if (!rc.getVertexIncludePredicate().evaluate(Context.getInstance(graph, v))) {
            return;
        }
        Point2D pt = (Point2D)layout.transform(v);
        pt = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, pt);
        float x = (float)pt.getX();
        float y = (float)pt.getY();
        Component component = this.prepareRenderer(rc, rc.getVertexLabelRenderer(), label, rc.getPickedVertexState().isPicked(v), v);
        GraphicsDecorator g = rc.getGraphicsContext();
        Dimension d = component.getPreferredSize();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        Shape shape = (Shape)rc.getVertexShapeTransformer().transform(v);
        shape = xform.createTransformedShape(shape);
        if (rc.getGraphicsContext() instanceof TransformingGraphics && (transformer = ((TransformingGraphics)rc.getGraphicsContext()).getTransformer()) instanceof ShapeTransformer) {
            ShapeTransformer shapeTransformer = (ShapeTransformer)transformer;
            shape = shapeTransformer.transform(shape);
        }
        Rectangle2D bounds = shape.getBounds2D();
        Point p = null;
        if (this.position == Renderer.VertexLabel.Position.AUTO) {
            Dimension vvd = rc.getScreenDevice().getSize();
            if (vvd.width == 0 || vvd.height == 0) {
                vvd = rc.getScreenDevice().getPreferredSize();
            }
            p = this.getAnchorPoint(bounds, d, this.positioner.getPosition(x, y, vvd));
        } else {
            p = this.getAnchorPoint(bounds, d, this.position);
        }
        g.draw(component, rc.getRendererPane(), p.x, p.y, d.width, d.height, true);
    }

    protected Point getAnchorPoint(Rectangle2D vertexBounds, Dimension labelSize, Renderer.VertexLabel.Position position) {
        int offset = 5;
        switch (position) {
            case N: {
                double x = vertexBounds.getCenterX() - (double)(labelSize.width / 2);
                double y = vertexBounds.getMinY() - (double)offset - (double)labelSize.height;
                return new Point((int)x, (int)y);
            }
            case NE: {
                double x = vertexBounds.getMaxX() + (double)offset;
                double y = vertexBounds.getMinY() - (double)offset - (double)labelSize.height;
                return new Point((int)x, (int)y);
            }
            case E: {
                double x = vertexBounds.getMaxX() + (double)offset;
                double y = vertexBounds.getCenterY() - (double)(labelSize.height / 2);
                return new Point((int)x, (int)y);
            }
            case SE: {
                double x = vertexBounds.getMaxX() + (double)offset;
                double y = vertexBounds.getMaxY() + (double)offset;
                return new Point((int)x, (int)y);
            }
            case S: {
                double x = vertexBounds.getCenterX() - (double)(labelSize.width / 2);
                double y = vertexBounds.getMaxY() + (double)offset;
                return new Point((int)x, (int)y);
            }
            case SW: {
                double x = vertexBounds.getMinX() - (double)offset - (double)labelSize.width;
                double y = vertexBounds.getMaxY() + (double)offset;
                return new Point((int)x, (int)y);
            }
            case W: {
                double x = vertexBounds.getMinX() - (double)offset - (double)labelSize.width;
                double y = vertexBounds.getCenterY() - (double)(labelSize.height / 2);
                return new Point((int)x, (int)y);
            }
            case NW: {
                double x = vertexBounds.getMinX() - (double)offset - (double)labelSize.width;
                double y = vertexBounds.getMinY() - (double)offset - (double)labelSize.height;
                return new Point((int)x, (int)y);
            }
            case CNTR: {
                double x = vertexBounds.getCenterX() - (double)(labelSize.width / 2);
                double y = vertexBounds.getCenterY() - (double)(labelSize.height / 2);
                return new Point((int)x, (int)y);
            }
        }
        return new Point();
    }

    @Override
    public Renderer.VertexLabel.Positioner getPositioner() {
        return this.positioner;
    }

    @Override
    public void setPositioner(Renderer.VertexLabel.Positioner positioner) {
        this.positioner = positioner;
    }

    public static class OutsidePositioner
    implements Renderer.VertexLabel.Positioner {
        public Renderer.VertexLabel.Position getPosition(float x, float y, Dimension d) {
            int cx = d.width / 2;
            int cy = d.height / 2;
            if (x > (float)cx && y > (float)cy) {
                return Renderer.VertexLabel.Position.SE;
            }
            if (x > (float)cx && y < (float)cy) {
                return Renderer.VertexLabel.Position.NE;
            }
            if (x < (float)cx && y > (float)cy) {
                return Renderer.VertexLabel.Position.SW;
            }
            return Renderer.VertexLabel.Position.NW;
        }
    }

    public static class InsidePositioner
    implements Renderer.VertexLabel.Positioner {
        public Renderer.VertexLabel.Position getPosition(float x, float y, Dimension d) {
            int cx = d.width / 2;
            int cy = d.height / 2;
            if (x > (float)cx && y > (float)cy) {
                return Renderer.VertexLabel.Position.NW;
            }
            if (x > (float)cx && y < (float)cy) {
                return Renderer.VertexLabel.Position.SW;
            }
            if (x < (float)cx && y > (float)cy) {
                return Renderer.VertexLabel.Position.NE;
            }
            return Renderer.VertexLabel.Position.SE;
        }
    }
}

