/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaInclude;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaObjectReference;
import org.eclipse.pde.internal.core.ischema.ISchemaRootElement;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.Schema;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaCompositor;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.core.schema.SchemaRootElement;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.actions.CollapseAction;
import org.eclipse.pde.internal.ui.editor.schema.ElementSectionDragAdapter;
import org.eclipse.pde.internal.ui.editor.schema.ElementSectionDropAdapter;
import org.eclipse.pde.internal.ui.editor.schema.NewAttributeAction;
import org.eclipse.pde.internal.ui.editor.schema.NewCompositorAction;
import org.eclipse.pde.internal.ui.editor.schema.NewElementAction;
import org.eclipse.pde.internal.ui.editor.schema.NewReferenceAction;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaRearranger;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ElementSection
extends TreeSection {
    private TreeViewer fTreeViewer;
    private Schema fSchema;
    private NewElementAction fNewElementAction = new NewElementAction();
    private NewAttributeAction fNewAttributeAction = new NewAttributeAction();
    private Clipboard fClipboard;
    private SchemaRearranger fRearranger;
    private CollapseAction fCollapseAction;

    public ElementSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.SchemaEditor_ElementSection_newElement, PDEUIMessages.SchemaEditor_ElementSection_newAttribute, PDEUIMessages.SchemaEditor_ElementSection_newChoice, PDEUIMessages.SchemaEditor_ElementSection_newSequence, PDEUIMessages.SchemaEditor_ElementSection_remove});
        this.getSection().setText(PDEUIMessages.SchemaEditor_ElementSection_title);
        this.getSection().setDescription(PDEUIMessages.SchemaEditor_ElementSection_desc);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createTree(container, toolkit);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fCollapseAction = new CollapseAction((AbstractTreeViewer)this.fTreeViewer, PDEUIMessages.ExtensionsPage_collapseAll);
        toolBarManager.add((IAction)this.fCollapseAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void createTree(Composite container, FormToolkit toolkit) {
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fTreeViewer = treePart.getTreeViewer();
        this.fTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.initDragAndDrop();
    }

    protected void initDragAndDrop() {
        this.fClipboard = new Clipboard(this.fTreeViewer.getControl().getDisplay());
        int ops = 7;
        Transfer[] transfers = new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
        ElementSectionDragAdapter dragAdapter = new ElementSectionDragAdapter((ISelectionProvider)this.fTreeViewer);
        this.fTreeViewer.addDragSupport(ops, transfers, (DragSourceListener)dragAdapter);
        this.fTreeViewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)new ElementSectionDropAdapter(dragAdapter, this));
    }

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public void refresh() {
        this.fTreeViewer.refresh();
        super.refresh();
        if (this.fTreeViewer.getSelection().isEmpty() && this.fSchema.getElementCount() > 0) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.fSchema.getElements()[0]));
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNewElement();
                break;
            }
            case 1: {
                this.handleNewAttribute();
                break;
            }
            case 2: {
                this.addCompositor(1);
                break;
            }
            case 3: {
                this.addCompositor(2);
                break;
            }
            case 4: {
                ISelection selection = this.fTreeViewer.getSelection();
                this.handleDelete((IStructuredSelection)selection);
            }
        }
    }

    private void addCompositor(int kind) {
        Object selection = ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
        ISchemaElement sourceElement = null;
        Object current = selection;
        while (current instanceof ISchemaCompositor) {
            current = ((ISchemaCompositor)current).getParent();
        }
        if (current instanceof ISchemaElement) {
            sourceElement = (ISchemaElement)current;
        }
        if (sourceElement != null) {
            new NewCompositorAction(sourceElement, selection, kind).run();
        }
    }

    public void dispose() {
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        boolean cut = actionId.equals(ActionFactory.CUT.getId());
        if (cut || actionId.equals(ActionFactory.DELETE.getId())) {
            IStructuredSelection sel = (IStructuredSelection)this.fTreeViewer.getSelection();
            Object selectedObject = sel.getFirstElement();
            if (selectedObject == null) {
                return true;
            }
            this.handleDelete(sel);
            return !cut;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public boolean setFormInput(Object object) {
        if (object instanceof ISchemaElement || object instanceof ISchemaAttribute || object instanceof ISchemaCompositor) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object), true);
            ISelection selection = this.fTreeViewer.getSelection();
            if (selection != null && !selection.isEmpty()) {
                return true;
            }
            if (object instanceof ISchemaElement) {
                ISchemaElement found = this.fSchema.findElement(((ISchemaElement)object).getName());
                if (found != null) {
                    this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)found), true);
                }
                return found != null;
            }
        }
        return false;
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        final ISelection selection = this.fTreeViewer.getSelection();
        Object object = ((IStructuredSelection)selection).getFirstElement();
        MenuManager submenu = new MenuManager(PDEUIMessages.Menus_new_label);
        if (object == null) {
            this.fNewElementAction.setSchema(this.fSchema);
            this.fNewElementAction.setEnabled(this.fSchema.isEditable());
            submenu.add((IAction)this.fNewElementAction);
        }
        if (object != null) {
            SchemaElement element = null;
            if (object instanceof SchemaElement) {
                element = (SchemaElement)object;
            } else if (object instanceof SchemaAttribute) {
                element = (SchemaElement)((SchemaAttribute)object).getParent();
            }
            if (element != null && !(element instanceof ISchemaRootElement) && !(element instanceof ISchemaObjectReference)) {
                this.fNewAttributeAction.setElement(element);
                this.fNewAttributeAction.setEnabled(this.fSchema.isEditable());
                submenu.add((IAction)this.fNewAttributeAction);
            }
        }
        if (object instanceof SchemaElement || object instanceof SchemaCompositor) {
            ISchemaElement sourceElement = null;
            ISchemaObject schemaObject = (ISchemaObject)object;
            while (schemaObject != null) {
                if (schemaObject instanceof ISchemaElement) {
                    sourceElement = (ISchemaElement)schemaObject;
                    break;
                }
                schemaObject = schemaObject.getParent();
            }
            if (sourceElement != null) {
                if (object instanceof SchemaCompositor || sourceElement.getType() instanceof ISchemaSimpleType || ((ISchemaComplexType)sourceElement.getType()).getCompositor() == null) {
                    if (submenu.getItems().length > 0) {
                        submenu.add((IContributionItem)new Separator());
                    }
                    submenu.add((IAction)new NewCompositorAction(sourceElement, object, 1));
                    submenu.add((IAction)new NewCompositorAction(sourceElement, object, 2));
                }
                if (object instanceof SchemaCompositor) {
                    boolean seperatorAdded = false;
                    Object[] elements = sourceElement.getSchema().getResolvedElements();
                    Arrays.sort(elements);
                    int i = 0;
                    while (i < elements.length) {
                        if (!(elements[i] instanceof SchemaRootElement)) {
                            if (!seperatorAdded) {
                                submenu.add((IContributionItem)new Separator());
                                seperatorAdded = true;
                            }
                            submenu.add((IAction)new NewReferenceAction(sourceElement, object, (ISchemaElement)elements[i]));
                        }
                        ++i;
                    }
                }
            }
        }
        manager.add((IContributionItem)submenu);
        if (object != null && !(object instanceof ISchemaRootElement)) {
            if (manager.getItems().length > 0) {
                manager.add((IContributionItem)new Separator());
            }
            if (!(object instanceof ISchemaAttribute) || !(((ISchemaAttribute)object).getParent() instanceof ISchemaRootElement)) {
                Action deleteAction = new Action(){

                    public void run() {
                        ElementSection.this.handleDelete((IStructuredSelection)selection);
                    }
                };
                deleteAction.setText(PDEUIMessages.Actions_delete_label);
                deleteAction.setEnabled(this.fSchema.isEditable());
                manager.add((IAction)deleteAction);
            }
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
    }

    private void handleDelete(IStructuredSelection selection) {
        IStructuredSelection nextSelection = null;
        Object selectionSource = null;
        for (Object thisObject : selection) {
            IStructuredSelection result = this.handleDelete(thisObject, nextSelection == null || this.schemaObjectHigherThan(thisObject, selectionSource) || nextSelection.getFirstElement().equals(thisObject));
            if (result == null) continue;
            nextSelection = result;
            selectionSource = thisObject;
        }
        if (nextSelection != null) {
            this.getTreeViewer().setSelection(nextSelection);
        }
    }

    private IStructuredSelection handleDelete(Object object, boolean generateSelection) {
        IStructuredSelection newSelection = null;
        if (!this.isEditable()) {
            Display.getCurrent().beep();
        } else if (object instanceof ISchemaRootElement) {
            Display.getCurrent().beep();
        } else if (object instanceof SchemaElementReference) {
            newSelection = this.handleReferenceDelete((SchemaElementReference)object, generateSelection);
        } else if (object instanceof ISchemaElement) {
            newSelection = this.handleElementDelete((ISchemaElement)object, generateSelection);
        } else if (object instanceof ISchemaAttribute) {
            ISchemaAttribute att = (ISchemaAttribute)object;
            if (!(att.getParent() instanceof ISchemaRootElement)) {
                newSelection = this.handleAttributeDelete(att, generateSelection);
            } else {
                Display.getCurrent().beep();
            }
        } else if (object instanceof ISchemaCompositor) {
            newSelection = this.handleCompositorDelete((ISchemaCompositor)object, generateSelection);
        }
        return newSelection;
    }

    private IStructuredSelection handleReferenceDelete(SchemaElementReference ref, boolean generateSelection) {
        StructuredSelection newSelection = null;
        if (generateSelection) {
            SchemaCompositor parent = (SchemaCompositor)ref.getParent();
            Object[] children = parent.getChildren();
            int index = this.getNewSelectionIndex(this.getArrayIndex(children, ref), children.length);
            newSelection = index == -1 ? new StructuredSelection((Object)parent) : new StructuredSelection(children[index]);
        }
        this.fRearranger.deleteReference(ref);
        return newSelection;
    }

    private IStructuredSelection handleElementDelete(ISchemaElement element, boolean generateSelection) {
        ISchema parent;
        Object[] children;
        int index;
        StructuredSelection newSelection = null;
        if (generateSelection && (index = this.getNewSelectionIndex(this.getArrayIndex(children = (parent = element.getSchema()).getElements(), element), children.length)) != -1) {
            newSelection = new StructuredSelection(children[index]);
        }
        this.fRearranger.deleteElement(element);
        return newSelection;
    }

    private IStructuredSelection handleAttributeDelete(ISchemaAttribute att, boolean generateSelection) {
        StructuredSelection newSelection = null;
        if (generateSelection) {
            ISchemaElement parent = (ISchemaElement)att.getParent();
            Object[] children = parent.getAttributes();
            int index = this.getNewSelectionIndex(this.getArrayIndex(children, att), children.length);
            if (index == -1) {
                ISchemaType type = parent.getType();
                if (type instanceof ISchemaComplexType) {
                    ISchemaCompositor comp = ((ISchemaComplexType)type).getCompositor();
                    newSelection = comp != null ? new StructuredSelection((Object)comp) : new StructuredSelection((Object)parent);
                }
            } else {
                newSelection = new StructuredSelection(children[index]);
            }
        }
        this.fRearranger.deleteAttribute(att);
        return newSelection;
    }

    private IStructuredSelection handleCompositorDelete(ISchemaCompositor comp, boolean generateSelection) {
        StructuredSelection newSelection = null;
        if (generateSelection) {
            ISchemaCompositor parentComp;
            Object[] children;
            int index;
            ISchemaElement element;
            ISchemaAttribute[] attributes;
            ISchemaObject parent = comp.getParent();
            newSelection = parent instanceof ISchemaElement ? ((attributes = (element = (ISchemaElement)parent).getAttributes()).length > 0 ? new StructuredSelection((Object)attributes[0]) : new StructuredSelection((Object)element)) : ((index = this.getNewSelectionIndex(this.getArrayIndex(children = (parentComp = (ISchemaCompositor)parent).getChildren(), comp), children.length)) == -1 ? new StructuredSelection((Object)parent) : new StructuredSelection(children[index]));
        }
        this.fRearranger.deleteCompositor(comp);
        return newSelection;
    }

    private boolean schemaObjectHigherThan(Object a, Object b) {
        if (!(b instanceof ISchemaObject)) {
            return true;
        }
        if (!(a instanceof ISchemaObject)) {
            return false;
        }
        return this.computeNestLevel((ISchemaObject)a) < this.computeNestLevel((ISchemaObject)b);
    }

    private int computeNestLevel(ISchemaObject o) {
        int result = 0;
        while (o instanceof SchemaElementReference || !(o instanceof ISchemaElement)) {
            o = o.getParent();
            ++result;
        }
        return result;
    }

    private void handleNewAttribute() {
        Object object = ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
        if (object != null) {
            SchemaElement element = null;
            if (object instanceof SchemaElement) {
                element = (SchemaElement)object;
            } else if (object instanceof SchemaAttribute) {
                element = (SchemaElement)((SchemaAttribute)object).getParent();
            }
            if (element != null && !(element instanceof ISchemaRootElement)) {
                this.fNewAttributeAction.setElement(element);
                this.fNewAttributeAction.run();
            }
        }
    }

    private void handleNewElement() {
        this.fNewElementAction.setSchema(this.fSchema);
        this.fNewElementAction.run();
    }

    public void initialize() {
        this.fSchema = (Schema)this.getPage().getModel();
        this.fRearranger = new SchemaRearranger(this.fSchema);
        this.fTreeViewer.setInput((Object)this.fSchema);
        boolean isEditable = this.fSchema.isEditable();
        this.getTreePart().setButtonEnabled(0, isEditable);
        this.getTreePart().setButtonEnabled(1, false);
        this.getTreePart().setButtonEnabled(2, isEditable);
        this.getTreePart().setButtonEnabled(3, isEditable);
        this.getTreePart().setButtonEnabled(4, isEditable);
    }

    public void handleModelChanged(IModelChangedEvent e) {
        if (e.getChangedProperty() != null && e.getChangedProperty().equals("description")) {
            return;
        }
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
            return;
        }
        Object[] objects = e.getChangedObjects();
        int i = 0;
        while (i < objects.length) {
            ISchemaObject parent;
            ISchemaObject sobj;
            Object obj = objects[0];
            if (obj instanceof SchemaElementReference) {
                this.fTreeViewer.refresh((Object)((SchemaElementReference)obj).getCompositor());
                if (e.getChangeType() == 1) {
                    this.fTreeViewer.setSelection((ISelection)new StructuredSelection(obj), true);
                }
            } else if (obj instanceof ISchemaElement || obj instanceof ISchemaAttribute) {
                if (e.getChangeType() == 3) {
                    Object typeCheck;
                    String changeProp = e.getChangedProperty();
                    if (changeProp != null && (changeProp.equals("name") || changeProp.equals("kindProperty"))) {
                        this.fTreeViewer.update(obj, null);
                    }
                    if ((typeCheck = e.getNewValue()) instanceof ISchemaComplexType && changeProp.equals("type") && obj instanceof ISchemaElement) {
                        this.fTreeViewer.refresh(typeCheck);
                        this.fTreeViewer.setSelection((ISelection)new StructuredSelection(typeCheck), true);
                    } else {
                        this.fTreeViewer.refresh(obj);
                    }
                } else if (e.getChangeType() == 1) {
                    sobj = (ISchemaObject)obj;
                    parent = sobj.getParent();
                    this.fTreeViewer.refresh((Object)parent);
                    this.fTreeViewer.setSelection((ISelection)new StructuredSelection(obj), true);
                } else if (e.getChangeType() == 2) {
                    this.fTreeViewer.remove(obj);
                }
            } else if (obj instanceof ISchemaCompositor || obj instanceof ISchemaObjectReference) {
                sobj = (ISchemaObject)obj;
                parent = sobj.getParent();
                if (e.getChangeType() == 3) {
                    this.fTreeViewer.refresh((Object)sobj);
                } else if (e.getChangeType() == 1) {
                    this.fTreeViewer.add((Object)parent, (Object)sobj);
                    this.fTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ElementSection.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)sobj), true);
                        }
                    });
                } else if (e.getChangeType() == 2) {
                    this.fTreeViewer.remove((Object)sobj);
                }
            } else if (obj instanceof ISchemaComplexType) {
                ISchemaComplexType type;
                ISchemaCompositor compositor;
                ISchemaCompositor comp = ((ISchemaComplexType)obj).getCompositor();
                this.fTreeViewer.refresh((Object)comp);
                if (comp != null) {
                    this.fTreeViewer.refresh((Object)comp.getParent());
                }
                if ((e.getChangeType() == 1 || e.getChangeType() == 3) && (compositor = (type = (ISchemaComplexType)obj).getCompositor()) != null) {
                    this.fTreeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ElementSection.this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)compositor), true);
                        }
                    });
                }
            } else if (obj instanceof ISchema && !"name".equals(e.getChangedProperty())) {
                this.fTreeViewer.refresh();
            }
            ++i;
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.initialize();
        ISchemaElement root = this.fSchema.getSchema().findElement("extension");
        if (root == null) {
            return;
        }
        this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)root), true);
        this.fTreeViewer.expandToLevel(1);
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons();
    }

    @Override
    public void setFocus() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.getTree().setFocus();
            this.getPage().getPDEEditor().setSelection(this.fTreeViewer.getSelection());
        }
    }

    private void updateButtons() {
        ISchemaElement element;
        if (!this.fSchema.isEditable()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        ISchemaObject sobject2 = (ISchemaObject)selection.getFirstElement();
        boolean canAddAttribute = false;
        if (sobject2 instanceof ISchemaElement) {
            if (!(sobject2 instanceof ISchemaRootElement) && !(sobject2 instanceof ISchemaObjectReference)) {
                canAddAttribute = true;
            }
        } else if (sobject2 instanceof ISchemaAttribute && !((element = (ISchemaElement)sobject2.getParent()) instanceof ISchemaRootElement)) {
            canAddAttribute = true;
        }
        this.getTreePart().setButtonEnabled(1, canAddAttribute);
        boolean canAddCompositor = false;
        if (sobject2 instanceof ISchemaCompositor || sobject2 instanceof ISchemaElement && !(sobject2 instanceof SchemaElementReference) && (((ISchemaElement)sobject2).getType() instanceof ISchemaSimpleType || ((ISchemaComplexType)((ISchemaElement)sobject2).getType()).getCompositor() == null)) {
            canAddCompositor = true;
        }
        this.getTreePart().setButtonEnabled(2, canAddCompositor);
        this.getTreePart().setButtonEnabled(3, canAddCompositor);
        boolean canRemove = false;
        for (ISchemaObject sobject2 : selection) {
            if (sobject2 == null || sobject2 instanceof ISchemaRootElement || sobject2 instanceof ISchemaAttribute && sobject2.getParent() instanceof ISchemaRootElement) continue;
            canRemove = true;
            break;
        }
        this.getTreePart().setButtonEnabled(4, canRemove);
    }

    private ISchemaObject getSibling(Object target, Object object) {
        if (target instanceof ISchemaElement && object instanceof ISchemaElement) {
            return (ISchemaElement)target;
        }
        if (target instanceof ISchemaAttribute && object instanceof ISchemaAttribute) {
            return (ISchemaAttribute)target;
        }
        if (target instanceof SchemaElementReference && object instanceof ISchemaElement) {
            return (SchemaElementReference)target;
        }
        return null;
    }

    private ISchemaObject getRealTarget(Object target, Object object) {
        if (object instanceof ISchemaElement || object instanceof ISchemaObjectReference) {
            if (target instanceof SchemaElementReference) {
                return ((SchemaElementReference)target).getCompositor();
            }
            if (target instanceof ISchemaCompositor) {
                return (ISchemaCompositor)target;
            }
            if (object instanceof ISchemaElement) {
                return this.fSchema;
            }
        }
        if (object instanceof ISchemaAttribute) {
            if (target instanceof ISchemaAttribute) {
                return ((ISchemaAttribute)target).getParent();
            }
            if (target instanceof ISchemaElement) {
                return (ISchemaElement)target;
            }
        }
        if (object instanceof ISchemaCompositor) {
            if (target instanceof SchemaElementReference) {
                return ((SchemaElementReference)target).getCompositor();
            }
            if (target instanceof ISchemaElement) {
                return (ISchemaElement)target;
            }
            if (target instanceof ISchemaCompositor) {
                return (ISchemaCompositor)target;
            }
        }
        return null;
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            Object obj = objects[i];
            if (!(obj instanceof ISchemaAttribute && target instanceof ISchemaAttribute || obj instanceof ISchemaObjectReference && target instanceof ISchemaCompositor || target instanceof ISchemaElement && !(target instanceof ISchemaObjectReference) && !(obj instanceof ISchemaRootElement))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        super.handleDoubleClick(selection);
        Object object = selection.getFirstElement();
        if (object instanceof SchemaElementReference) {
            ISchemaElement element = ((SchemaElementReference)object).getReferencedElement();
            if (element == null) {
                String name = ((SchemaElementReference)object).getName();
                MessageDialog.openWarning((Shell)this.getPage().getSite().getShell(), (String)PDEUIMessages.ElementSection_missingRefElement, (String)NLS.bind((String)PDEUIMessages.SchemaIncludesSection_missingWarningMessage, (Object)name));
                return;
            }
            ISchema schema = element.getSchema();
            if (schema.equals(this.fSchema)) {
                this.fireSelection((ISelection)new StructuredSelection((Object)element));
            } else {
                ISchemaInclude[] includes = this.fSchema.getIncludes();
                int i = 0;
                while (i < includes.length) {
                    ISchema includedSchema = includes[i].getIncludedSchema();
                    if (includedSchema != null && includedSchema.equals(schema)) {
                        String location = includes[i].getLocation();
                        SchemaEditor.openToElement((IPath)new Path(location), element);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    protected void fireSelection(ISelection selection) {
        if (selection == null) {
            selection = this.fTreeViewer.getSelection();
        }
        this.fTreeViewer.setSelection(selection);
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        this.handleOp(target, objects, 1);
    }

    public void handleOp(Object currentTarget, Object[] objects, int currentOperation) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ISchemaObject) {
                ISchemaObject object = (ISchemaObject)objects[i];
                ISchemaObject realTarget = this.getRealTarget(currentTarget, object);
                ISchemaObject sibling = this.getSibling(currentTarget, object);
                if (realTarget != null) {
                    switch (currentOperation) {
                        case 1: {
                            this.doPaste(realTarget, sibling, object);
                            break;
                        }
                        case 2: {
                            this.doMove(realTarget, sibling, object);
                            break;
                        }
                        case 4: {
                            this.doLink(realTarget, sibling, object);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void doLink(ISchemaObject realTarget, ISchemaObject sibling, ISchemaObject object) {
        if (realTarget instanceof ISchemaCompositor && object instanceof ISchemaElement) {
            this.fRearranger.linkReference((ISchemaCompositor)realTarget, (ISchemaElement)object, sibling);
        }
    }

    private void doMove(ISchemaObject realTarget, ISchemaObject sibling, ISchemaObject object) {
        if (object instanceof ISchemaCompositor) {
            this.fRearranger.moveCompositor(realTarget, (ISchemaCompositor)object);
        } else if (object instanceof SchemaElementReference) {
            this.fRearranger.moveReference((SchemaElementReference)object, (ISchemaCompositor)realTarget, sibling);
        } else if (object instanceof ISchemaElement) {
            this.fRearranger.moveElement(realTarget, (ISchemaElement)object, sibling);
        } else if (object instanceof ISchemaAttribute) {
            this.fRearranger.moveAttribute((ISchemaElement)realTarget, (ISchemaAttribute)object, sibling != null ? (ISchemaAttribute)sibling : null);
        }
    }

    private void doPaste(ISchemaObject realTarget, ISchemaObject sibling, ISchemaObject object) {
        if (object instanceof ISchemaCompositor) {
            this.fRearranger.pasteCompositor(realTarget, (ISchemaCompositor)object, sibling);
        } else if (object instanceof SchemaElementReference) {
            this.fRearranger.pasteReference(realTarget, (ISchemaObjectReference)((SchemaElementReference)object), sibling);
        } else if (object instanceof ISchemaElement) {
            this.fRearranger.pasteElement((ISchemaElement)object, sibling);
        } else if (object instanceof ISchemaAttribute) {
            this.fRearranger.pasteAttribute((ISchemaElement)realTarget, (ISchemaAttribute)object, sibling);
        }
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof Schema) {
                Schema schema = (Schema)object;
                return schema.getElements();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parent) {
            Object[] children = new Object[]{};
            if (parent instanceof ISchemaElement) {
                ISchemaCompositor compositor;
                Object[] types = new Object[]{};
                ISchemaAttribute[] attributes = ((ISchemaElement)parent).getAttributes();
                ISchemaType type = ((ISchemaElement)parent).getType();
                if (type instanceof ISchemaComplexType && (compositor = ((ISchemaComplexType)type).getCompositor()) != null) {
                    types = new Object[]{compositor};
                }
                children = new Object[types.length + attributes.length];
                System.arraycopy(types, 0, children, 0, types.length);
                System.arraycopy(attributes, 0, children, types.length, attributes.length);
            } else if (parent instanceof ISchemaCompositor) {
                children = ((ISchemaCompositor)parent).getChildren();
            }
            return children;
        }

        public Object getParent(Object child) {
            if (child instanceof ISchemaObject) {
                return ((ISchemaObject)child).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof ISchemaAttribute || parent instanceof ISchemaObjectReference) {
                return false;
            }
            return this.getChildren(parent).length > 0;
        }
    }
}

