/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class OctetString_Type
extends ASN1Type {
    private static final String OCTETSTRINGVALUEEXPECTED1 = "(reference to) OCTET STRING value was expected";
    private static final String OCTETSTRINGVALUEEXPECTED2 = "OCTET STRING value was expected";
    private static final String OCTETSTRINGVALUEEXPECTED3 = "octetstring value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `octetstring''";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_OCTETSTRING;
    }

    @Override
    public IASN1Type newInstance() {
        return new OctetString_Type();
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_OCTETSTRING.equals((Object)temp.getTypetype()) || !this.isAsn() && IType.Type_type.TYPE_ANY.equals((Object)temp.getTypetype());
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return "octetstring";
    }

    @Override
    public String getOutlineIcon() {
        return "octetstring.gif";
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_OCTETSTRING;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.parseAttributes(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        this.checkSubtypeRestrictions(timestamp);
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        IValue last;
        block18: {
            block17: {
                IType lastType;
                super.checkThisValue(timestamp, value, valueCheckingOptions);
                last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
                if (last == null || last.getIsErroneous(timestamp)) {
                    return;
                }
                switch (value.getValuetype()) {
                    case OMIT_VALUE: 
                    case REFERENCED_VALUE: {
                        return;
                    }
                    case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                        if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                        return;
                    }
                }
                if (!last.isAsn()) break block17;
                if (IValue.Value_type.REFERENCED_VALUE.equals((Object)value.getValuetype()) && !(lastType = last.getMyGovernor().getTypeRefdLast(timestamp)).getIsErroneous(timestamp) && !IType.Type_type.TYPE_OCTETSTRING.equals((Object)lastType.getTypetype())) {
                    value.getLocation().reportSemanticError(OCTETSTRINGVALUEEXPECTED1);
                    value.setIsErroneous(true);
                    return;
                }
                switch (last.getValuetype()) {
                    case OCTETSTRING_VALUE: {
                        break;
                    }
                    case BITSTRING_VALUE: 
                    case HEXSTRING_VALUE: {
                        if (last == value) {
                            last = last.setValuetype(timestamp, IValue.Value_type.OCTETSTRING_VALUE);
                            break;
                        }
                        break block18;
                    }
                    case EXPRESSION_VALUE: 
                    case MACRO_VALUE: {
                        break;
                    }
                    default: {
                        value.getLocation().reportSemanticError(OCTETSTRINGVALUEEXPECTED2);
                        value.setIsErroneous(true);
                        break;
                    }
                }
                break block18;
            }
            switch (last.getValuetype()) {
                case OCTETSTRING_VALUE: {
                    break;
                }
                case EXPRESSION_VALUE: 
                case MACRO_VALUE: {
                    break;
                }
                default: {
                    value.getLocation().reportSemanticError(OCTETSTRINGVALUEEXPECTED3);
                    value.setIsErroneous(true);
                }
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        switch (template.getTemplatetype()) {
            case OSTR_PATTERN: {
                break;
            }
            default: {
                template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
            }
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                if (subreferences.size() > actualSubReference + 1) {
                    subreference.getLocation().reportSemanticError("A string element cannot be indexed");
                    return null;
                }
                if (subreferences.size() == actualSubReference + 1) {
                    reference.setStringElementReferencing();
                }
                return this;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("octetstring");
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.arraySubReference.equals((Object)subreference.getReferenceType()) && subreferences.size() == i + 1) {
            declarationCollector.addDeclaration("octetstring", this.location, this);
        }
    }
}

