/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionUtilities;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class MatchExpression
extends Expression_Value {
    private final Value value;
    private final TemplateInstance templateInstance;

    public MatchExpression(Value value, TemplateInstance templateInstance) {
        this.value = value;
        this.templateInstance = templateInstance;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (templateInstance != null) {
            templateInstance.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.MATCH_OPERATION;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("match(");
        builder.append(this.value.createStringRepresentation());
        builder.append(", ");
        builder.append(this.templateInstance.createStringRepresentation());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.templateInstance != null) {
            this.templateInstance.setMyScope(scope);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand1>");
        }
        if (this.templateInstance == child) {
            return builder.append(".<operand2>");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.value == null || this.templateInstance == null) {
            this.setIsErroneous(true);
            return;
        }
        if (this.value.getIsErroneous(timestamp) || this.templateInstance.getTemplateBody().getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
            return;
        }
        Expected_Value_type internalExpectation = Expected_Value_type.EXPECTED_DYNAMIC_VALUE.equals((Object)expectedValue) ? Expected_Value_type.EXPECTED_TEMPLATE : expectedValue;
        IType localGovernor = this.templateInstance.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (localGovernor == null) {
            ITTCN3Template template = this.templateInstance.getTemplateBody().setLoweridToReference(timestamp);
            localGovernor = template.getExpressionGovernor(timestamp, internalExpectation);
        }
        if (localGovernor == null) {
            this.setIsErroneous(true);
            return;
        }
        this.templateInstance.getTemplateBody().checkThisTemplateGeneric(timestamp, localGovernor, false, false, false, true, false);
        try {
            ExpressionUtilities.checkExpressionOperatorCompatibility(timestamp, (Expression_Value)this, referenceChain, Expected_Value_type.EXPECTED_TEMPLATE, this.value, this.templateInstance);
        }
        catch (StackOverflowError e) {
            ErrorReporter.logExceptionStackTrace((String)("Stack overflow was detected while analysing `" + this.getFullName() + "'"), (Throwable)e.getCause());
            this.getLocation().reportSemanticError("Titan was unable to analyse this statement");
            this.setIsErroneous(true);
        }
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        this.value.getValueRefdLast(timestamp, expectedValue, referenceChain);
        this.templateInstance.getTemplateBody().getTemplateReferencedLast(timestamp, referenceChain);
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.templateInstance == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        return this.lastValue;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            if (this.value != null) {
                referenceChain.markState();
                this.value.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
            if (this.templateInstance != null) {
                referenceChain.markState();
                this.templateInstance.checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.templateInstance != null) {
            this.templateInstance.updateSyntax(reparser, false);
            reparser.updateLocation(this.templateInstance.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.templateInstance != null) {
            this.templateInstance.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.templateInstance == null || this.templateInstance.accept(v);
    }
}

