/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.consoles;

import java.io.IOException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.preferences.SubscribedBoolean;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public final class TITANDebugConsole {
    private static final String TITLE = "TITAN Debug console";
    private static MessageConsole console = null;
    private static SubscribedBoolean displayTimestamp = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.debug.console.timestamp", false);
    private static SubscribedBoolean logToSysOut = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.debug.console.logtosysout", false);
    private static boolean inHeadLessMode = !PlatformUI.isWorkbenchRunning();

    private TITANDebugConsole() {
    }

    public static synchronized MessageConsole getConsole() {
        if (console == null) {
            console = new MessageConsole(TITLE, null);
            console.activate();
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        }
        return console;
    }

    public static void clearConsole() {
        if (inHeadLessMode) {
            return;
        }
        TITANDebugConsole.getConsole().clearConsole();
    }

    public static void println(String message, MessageConsoleStream stream) {
        if (inHeadLessMode) {
            return;
        }
        stream.println(message);
        try {
            stream.flush();
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
    }

    public static void println(String ... message) {
        if (inHeadLessMode) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < message.length; ++i) {
            msg.append(message[i]);
            if (i >= message.length - 1) continue;
            msg.append(": ");
        }
        TITANDebugConsole.println(msg.toString(), TITANDebugConsole.getConsole().newMessageStream());
    }

    public static void print(String message, MessageConsoleStream stream) {
        if (inHeadLessMode) {
            return;
        }
        stream.print(message);
    }

    public static void print(String message) {
        if (inHeadLessMode) {
            return;
        }
        TITANDebugConsole.print(message, TITANDebugConsole.getConsole().newMessageStream());
    }
}

