/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.actions;

import org.eclipse.titan.designer.Activator;

public final class IndentationSupport {
    private static String indentationString = null;

    private IndentationSupport() {
    }

    public static void clearIndentString() {
        indentationString = null;
    }

    public static String getIndentString() {
        if (indentationString != null) {
            return indentationString;
        }
        String tabPolicy = Activator.getDefault().getPreferenceStore().getString("org.eclipse.titan.designer.indentation.indentationTabPolicy");
        String indentSizeString = Activator.getDefault().getPreferenceStore().getString("org.eclipse.titan.designer.indentation.indentationSize");
        int indentSize = indentSizeString.isEmpty() ? 2 : Integer.parseInt(indentSizeString);
        if ("Tab".equals(tabPolicy)) {
            indentationString = "\t";
        } else if ("Spaces".equals(tabPolicy)) {
            StringBuilder sb = new StringBuilder(8);
            for (int i = 0; i < indentSize; ++i) {
                sb.append(" ");
            }
            indentationString = sb.toString();
        } else {
            indentationString = "  ";
        }
        return indentationString;
    }
}

