/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc;

import java.util.Arrays;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.ComponentSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.ComponentItemTransfer;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.ComponentSectionDragSourceListener;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.ComponentSectionDropTargetListener;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.ComponentsDataContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.compgroupmc.ComponentsDataLabelProvider;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class ComponentsSubPage {
    private Label totalComponentsLabel;
    private Table componentsTable;
    private TableViewer componentsTableViewer;
    private Button add;
    private Button remove;
    private static final String[] COLUMN_NAMES = new String[]{"componentName", "hostName"};
    private ConfigEditor editor;
    private ComponentSectionHandler componentsSectionHandler;

    public ComponentsSubPage(ConfigEditor editor) {
        this.editor = editor;
    }

    void createComponentsSection(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        this.componentsTable = toolkit.createTable(client, 66306);
        this.componentsTable.setEnabled(this.componentsSectionHandler != null);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 200;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.componentsTable.setLayoutData((Object)gd);
        this.componentsTable.setLinesVisible(true);
        this.componentsTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.componentsTable, 16384, 0);
        column.setText("Component name");
        column.setWidth(130);
        column.setMoveable(false);
        column = new TableColumn(this.componentsTable, 16384, 1);
        column.setText("Host name");
        column.setWidth(100);
        column.setMoveable(false);
        this.componentsTableViewer = new TableViewer(this.componentsTable);
        this.componentsTableViewer.setContentProvider((IContentProvider)new ComponentsDataContentProvider());
        this.componentsTableViewer.setLabelProvider((IBaseLabelProvider)new ComponentsDataLabelProvider());
        this.componentsTableViewer.setInput((Object)this.componentsSectionHandler);
        this.componentsTableViewer.setColumnProperties(COLUMN_NAMES);
        TextCellEditor[] cellEditors = new TextCellEditor[]{new TextCellEditor((Composite)this.componentsTable), new TextCellEditor((Composite)this.componentsTable)};
        this.componentsTableViewer.setCellEditors((CellEditor[])cellEditors);
        this.componentsTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public String getValue(Object element, String property) {
                int columnIndex = Arrays.asList(COLUMN_NAMES).indexOf(property);
                ComponentsDataLabelProvider labelProvider = (ComponentsDataLabelProvider)ComponentsSubPage.this.componentsTableViewer.getLabelProvider();
                return labelProvider.getColumnText(element, columnIndex);
            }

            public void modify(Object element, String property, Object value) {
                int columnIndex = Arrays.asList(COLUMN_NAMES).indexOf(property);
                if (element != null && element instanceof TableItem && value instanceof String) {
                    ComponentSectionHandler.Component component = (ComponentSectionHandler.Component)((TableItem)element).getData();
                    switch (columnIndex) {
                        case 0: {
                            ConfigTreeNodeUtilities.setText((ParseTree)component.getComponentName(), (String)((String)value).trim());
                            break;
                        }
                        case 1: {
                            ConfigTreeNodeUtilities.setText((ParseTree)component.getHostName(), (String)((String)value).trim());
                            break;
                        }
                    }
                    ComponentsSubPage.this.componentsTableViewer.refresh((Object)component);
                    ComponentsSubPage.this.editor.setDirty();
                }
            }
        });
        Composite buttons = toolkit.createComposite(client);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1026));
        this.add = toolkit.createButton(buttons, "Add...", 8);
        gd = new GridData(258);
        this.add.setLayoutData((Object)gd);
        this.add.setEnabled(this.componentsSectionHandler != null);
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ComponentSectionHandler.Component newComponent;
                if (ComponentsSubPage.this.componentsSectionHandler == null) {
                    return;
                }
                if (ComponentsSubPage.this.componentsSectionHandler.getLastSectionRoot() == null) {
                    ComponentsSubPage.this.createNewComponentsSection();
                }
                if ((newComponent = ComponentsSubPage.this.createNewComponent()) == null) {
                    return;
                }
                ConfigTreeNodeUtilities.addChild((ParseTree)ComponentsSubPage.this.componentsSectionHandler.getLastSectionRoot(), (ParseTree)newComponent.getRoot());
                ComponentsSubPage.this.componentsSectionHandler.getComponents().add(newComponent);
                ComponentsSubPage.this.internalRefresh();
                ComponentsSubPage.this.componentsTable.select(ComponentsSubPage.this.componentsSectionHandler.getComponents().size() - 1);
                ComponentsSubPage.this.componentsTable.showSelection();
                ComponentsSubPage.this.editor.setDirty();
            }
        });
        this.remove = toolkit.createButton(buttons, "Remove", 8);
        gd = new GridData(258);
        this.remove.setLayoutData((Object)gd);
        this.remove.setEnabled(this.componentsSectionHandler != null);
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ComponentsSubPage.this.componentsTableViewer == null || ComponentsSubPage.this.componentsSectionHandler == null) {
                    return;
                }
                ComponentsSubPage.this.removeSelectedComponents();
                if (ComponentsSubPage.this.componentsSectionHandler.getComponents().isEmpty()) {
                    ComponentsSubPage.this.removeComponentsSection();
                }
                ComponentsSubPage.this.internalRefresh();
                ComponentsSubPage.this.editor.setDirty();
            }
        });
        this.totalComponentsLabel = toolkit.createLabel(buttons, "Total: 0");
        gd = new GridData(258);
        this.totalComponentsLabel.setLayoutData((Object)gd);
        section.setText("Components");
        section.setDescription("Specify the list of remote components for this configuration.");
        section.setClient((Control)client);
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        gd = new GridData(4, 4, true, true);
        section.setLayoutData((Object)gd);
        ComponentItemTransfer instance = ComponentItemTransfer.getInstance();
        this.componentsTableViewer.addDragSupport(3, new Transfer[]{instance}, (DragSourceListener)new ComponentSectionDragSourceListener(this, this.componentsTableViewer));
        this.componentsTableViewer.addDropSupport(19, new Transfer[]{instance}, (DropTargetListener)new ComponentSectionDropTargetListener(this.componentsTableViewer, this.editor));
        this.internalRefresh();
    }

    private void internalRefresh() {
        this.add.setEnabled(this.componentsSectionHandler != null);
        this.remove.setEnabled(this.componentsSectionHandler != null);
        this.componentsTable.setEnabled(this.componentsSectionHandler != null);
        this.componentsTableViewer.setInput((Object)this.componentsSectionHandler);
        if (this.componentsSectionHandler != null) {
            this.totalComponentsLabel.setText("Total: " + this.componentsSectionHandler.getComponents().size());
        }
    }

    public void refreshData(ComponentSectionHandler componentsSectionHandler) {
        this.componentsSectionHandler = componentsSectionHandler;
        if (this.componentsTableViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ComponentsSubPage.this.internalRefresh();
                }
            });
        }
    }

    private void createNewComponentsSection() {
        if (this.componentsSectionHandler == null) {
            return;
        }
        ParserRuleContext sectionRoot = new ParserRuleContext();
        this.componentsSectionHandler.setLastSectionRoot(sectionRoot);
        AddedParseTree header = new AddedParseTree("\n[COMPONENTS]");
        ConfigTreeNodeUtilities.addChild((ParseTree)sectionRoot, (ParseTree)header);
        ParserRuleContext root = this.editor.getParseTreeRoot();
        if (root != null) {
            root.addChild((RuleContext)sectionRoot);
        }
    }

    private ComponentSectionHandler.Component createNewComponent() {
        if (this.componentsSectionHandler == null) {
            return null;
        }
        ComponentSectionHandler.Component newcomponent = new ComponentSectionHandler.Component();
        ParserRuleContext root = new ParserRuleContext();
        newcomponent.setRoot((ParseTree)root);
        AddedParseTree componentName = new AddedParseTree("component_name");
        AddedParseTree hostName = new AddedParseTree("host_name");
        newcomponent.setComponentName((ParseTree)componentName);
        newcomponent.setHostName((ParseTree)hostName);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)"\n"));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)componentName);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree(" := "));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)hostName);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)"\n"));
        return newcomponent;
    }

    private void removeComponentsSection() {
        if (this.componentsSectionHandler == null || this.componentsSectionHandler.getLastSectionRoot() == null) {
            return;
        }
        ConfigTreeNodeUtilities.removeChild((ParseTree)this.editor.getParseTreeRoot(), (ParseTree)this.componentsSectionHandler.getLastSectionRoot());
        this.componentsSectionHandler.setLastSectionRoot(null);
    }

    public void removeSelectedComponents() {
        if (this.componentsTableViewer == null || this.componentsSectionHandler == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.componentsTableViewer.getSelection();
        for (ComponentSectionHandler.Component component : selection) {
            if (component == null) continue;
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.componentsSectionHandler.getLastSectionRoot(), (ParseTree)component.getRoot());
            this.componentsSectionHandler.getComponents().remove(component);
        }
    }
}

