/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.referenceSearch;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchQuery;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.IEditorPart;

public class ReferenceSearchResult
extends AbstractTextSearchResult
implements IFileMatchAdapter,
IEditorMatchAdapter {
    private static final String ICON_SEARCH = "search.gif";
    private ReferenceSearchQuery query;

    public ReferenceSearchResult(ReferenceSearchQuery query) {
        this.query = query;
    }

    public String getLabel() {
        if (this.query != null) {
            return this.query.getSearchPattern() + " - " + super.getMatchCount() + " Matches";
        }
        return "Search result";
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageCache.getImageDescriptor(ICON_SEARCH);
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        return match.getElement().equals(file);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        return this.computeContainedMatches(result, file);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return result.getMatches((Object)file);
    }

    public String getTooltip() {
        return "Search result";
    }

    public IFile getFile(Object element) {
        if (element instanceof Match) {
            return (IFile)((Match)element).getElement();
        }
        return null;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] getMatches(Object element) {
        if (element instanceof Match) {
            Match[] result = new Match[]{(Match)element};
            return result;
        }
        return super.getMatches(element);
    }

    public int getMatchCount(Object element) {
        if (element instanceof Match) {
            return 1;
        }
        return super.getMatchCount(element);
    }
}

