/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TITANFlagsOptionsData {
    public static final String DISABLE_BER_PROPERTY = "disableBER";
    public static final String DISABLE_RAW_PROPERTY = "disableRAW";
    public static final String DISABLE_TEXT_PROPERTY = "disableTEXT";
    public static final String DISABLE_XER_PROPERTY = "disableXER";
    public static final String DISABLE_JSON_PROPERTY = "disableJSON";
    public static final String FORCE_XER_IN_ASN1_PROPERTY = "forceXERinASN.1";
    public static final String DEFAULT_AS_OMIT_PROPERTY = "defaultasOmit";
    public static final String FORCE_OLD_FUNC_OUT_PAR_PROPERTY = "forceOldFuncOutParHandling";
    public static final String GCC_MESSAGE_FORMAT_PROPERTY = "gccMessageFormat";
    public static final String LINE_NUMBERS_ONLY_IN_MESSAGES_PROPERTY = "lineNumbersOnlyInMessages";
    public static final String INCLUDE_SOURCEINFO_PROPERTY = "includeSourceInfo";
    public static final String ADD_SOURCELINEINFO_PROPERTY = "addSourceLineInfo";
    public static final String SUPPRESS_WARNINGS_PROPERTY = "suppressWarnings";
    public static final String QUIETLY_PROPERTY = "quietly";
    public static final String DISABLE_SUBTYPE_CHECKING_PROPERTY = "disableSubtypeChecking";
    public static final String ALLOW_OMIT_IN_VALUELIST_TEMPLATE_PROPERTY = "omitInValueList";
    public static final String WARNINGS_FOR_BAD_VARIANTS_PROPERTY = "warningsForBadVariants";
    public static final String[] PROPERTIES = new String[]{"disableBER", "disableRAW", "disableTEXT", "disableXER", "disableJSON", "forceXERinASN.1", "defaultasOmit", "forceOldFuncOutParHandling", "gccMessageFormat", "lineNumbersOnlyInMessages", "includeSourceInfo", "addSourceLineInfo", "suppressWarnings", "omitInValueList", "warningsForBadVariants", "quietly", "disableSubtypeChecking"};
    public static final String[] TAGS = PROPERTIES;
    public static final String[] DEFAULT_VALUES = new String[]{"false", "false", "false", "false", "false", "false", "false", "false", "false", "false", "true", "true", "false", "false", "false", "false", "false"};

    private TITANFlagsOptionsData() {
    }

    public static String getTITANFlags(IProject project, boolean useRuntime2) {
        StringBuilder builder = new StringBuilder(30);
        if (useRuntime2) {
            builder.append('R');
        }
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", DISABLE_BER_PROPERTY));
            builder.append("true".equals(temp) ? "b" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", DISABLE_RAW_PROPERTY));
            builder.append("true".equals(temp) ? "r" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", DISABLE_TEXT_PROPERTY));
            builder.append("true".equals(temp) ? "x" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", DISABLE_XER_PROPERTY));
            builder.append("true".equals(temp) ? "X" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", DISABLE_JSON_PROPERTY));
            builder.append("true".equals(temp) ? "j" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", FORCE_XER_IN_ASN1_PROPERTY));
            builder.append("true".equals(temp) ? "a" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", DEFAULT_AS_OMIT_PROPERTY));
            builder.append("true".equals(temp) ? "d" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", FORCE_OLD_FUNC_OUT_PAR_PROPERTY));
            builder.append("true".equals(temp) ? "Y" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", GCC_MESSAGE_FORMAT_PROPERTY));
            builder.append("true".equals(temp) ? "g" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", LINE_NUMBERS_ONLY_IN_MESSAGES_PROPERTY));
            builder.append("true".equals(temp) ? "i" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", INCLUDE_SOURCEINFO_PROPERTY));
            builder.append("true".equals(temp) ? "l" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", ADD_SOURCELINEINFO_PROPERTY));
            builder.append("true".equals(temp) ? "L" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", SUPPRESS_WARNINGS_PROPERTY));
            builder.append("true".equals(temp) ? "w" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", QUIETLY_PROPERTY));
            builder.append("true".equals(temp) ? "q" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", DISABLE_SUBTYPE_CHECKING_PROPERTY));
            builder.append("true".equals(temp) ? "y" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", ALLOW_OMIT_IN_VALUELIST_TEMPLATE_PROPERTY));
            builder.append("true".equals(temp) ? "M" : "");
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", WARNINGS_FOR_BAD_VARIANTS_PROPERTY));
            builder.append("true".equals(temp) ? "E" : "");
            if (builder.length() > 0) {
                builder.insert(0, '-');
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "codeSplitting"))) != null && !"".equals(temp) && !"none".equals(temp)) {
                builder.append(" -U ").append(temp);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting Titan flags of `" + project.getName() + "'"), (Throwable)e);
        }
        return builder.toString();
    }

    public static void removeTITANAttributes(IProject project) {
        for (int i = 0; i < PROPERTIES.length; ++i) {
            try {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]), null);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While removing attributes of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void loadMakefileSettings(Node root, IProject project) {
        int i;
        NodeList resourceList = root.getChildNodes();
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            String name = resourceList.item(i).getNodeName();
            for (int j = 0; j < TAGS.length; ++j) {
                if (!TAGS[j].equals(name)) continue;
                newValues[j] = resourceList.item(i).getTextContent();
            }
        }
        for (i = 0; i < TAGS.length; ++i) {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]);
            try {
                String oldValue = project.getPersistentProperty(qualifiedName);
                if (newValues[i] == null || newValues[i].equals(oldValue)) continue;
                project.setPersistentProperty(qualifiedName, newValues[i]);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading tag `" + TAGS[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void saveMakefileSettings(Element makefileSettings, Document document, IProject project) {
        for (int i = 0; i < TAGS.length; ++i) {
            try {
                String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]));
                if (temp == null || DEFAULT_VALUES[i].equals(temp)) continue;
                Element element = document.createElement(TAGS[i]);
                makefileSettings.appendChild(element);
                element.appendChild(document.createTextNode(temp));
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While saving tag `" + TAGS[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void copyMakefileSettings(Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        if (source != null) {
            NodeList resourceList = source.getChildNodes();
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                String name = resourceList.item(i).getNodeName();
                for (int j = 0; j < TAGS.length; ++j) {
                    if (!TAGS[j].equals(name)) continue;
                    newValues[j] = resourceList.item(i).getTextContent();
                }
            }
        }
        for (int i = 0; i < TAGS.length; ++i) {
            String temp = newValues[i];
            if (temp == null || !saveDefaultValues && DEFAULT_VALUES[i].equals(temp)) continue;
            Element node = document.createElement(TAGS[i]);
            node.appendChild(document.createTextNode(temp));
            makefileSettings.appendChild(node);
        }
    }
}

