/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class DelayedEventsProcessor
implements Listener {
    private ArrayList<String> filesToOpen = new ArrayList(1);

    public DelayedEventsProcessor(Display display) {
        display.addListener(46, (Listener)this);
    }

    public void handleEvent(Event event) {
        String path = event.text;
        if (path == null) {
            return;
        }
        this.filesToOpen.add(path);
    }

    public void catchUp(Display display) {
        if (this.filesToOpen.isEmpty()) {
            return;
        }
        String[] filePaths = new String[this.filesToOpen.size()];
        this.filesToOpen.toArray(filePaths);
        this.filesToOpen.clear();
        int i = 0;
        while (i < filePaths.length) {
            DelayedEventsProcessor.openFile(display, filePaths[i]);
            ++i;
        }
    }

    public static void openFile(Display display, final String initialPath) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                FileLocationDetails details = FileLocationDetails.resolve(initialPath);
                if (details == null || details.fileInfo.isDirectory() || !details.fileInfo.exists()) {
                    String msg = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedFileAction_message_fileNotFound, (Object)initialPath);
                    MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedFileAction_title, (String)msg, (int)0x10000000);
                } else {
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null) {
                        String msg = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedFileAction_message_noWindow, (Object)details.path);
                        MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedFileAction_title, (String)msg, (int)0x10000000);
                    }
                    try {
                        IEditorPart openEditor = IDE.openInternalEditorOnFileStore((IWorkbenchPage)page, (IFileStore)details.fileStore);
                        Shell shell = window.getShell();
                        if (shell != null) {
                            if (shell.getMinimized()) {
                                shell.setMinimized(false);
                            }
                            shell.forceActive();
                        }
                        if (details.line >= 1) {
                            try {
                                int lineLength;
                                Object documentProvider = this.invoke(openEditor, "getDocumentProvider");
                                Object editorInput = this.invoke(openEditor, "getEditorInput");
                                Object document = this.invoke(documentProvider, "getDocument", new Class[]{Object.class}, new Object[]{editorInput});
                                int numberOfLines = (Integer)this.invoke(document, "getNumberOfLines");
                                if (details.line > numberOfLines) {
                                    details.line = numberOfLines;
                                }
                                if (details.column > (lineLength = ((Integer)this.invoke(document, "getLineLength", new Class[]{Integer.TYPE}, new Object[]{details.line - 1})).intValue())) {
                                    details.column = lineLength;
                                }
                                if (details.column < 1) {
                                    details.column = 1;
                                }
                                int offset = (Integer)this.invoke(document, "getLineOffset", new Class[]{Integer.TYPE}, new Object[]{details.line - 1});
                                this.invoke(openEditor, "selectAndReveal", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{offset += details.column - 1, 0});
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (PartInitException e) {
                        String msg = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedFileAction_message_errorOnOpen, (Object)details.fileStore.getName());
                        PartInitException eLog = new PartInitException(e.getMessage());
                        IDEWorkbenchPlugin.log((String)msg, (IStatus)new Status(4, "org.eclipse.ui.ide.application", msg, (Throwable)eLog));
                        MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedFileAction_title, (String)msg, (int)0x10000000);
                    }
                }
            }

            private Object invoke(Object object, String methodName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Method method = object.getClass().getMethod(methodName, new Class[0]);
                return method.invoke(object, new Object[0]);
            }

            private Object invoke(Object object, String methodName, Class<?>[] classes, Object[] params) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Method method = object.getClass().getMethod(methodName, classes);
                return method.invoke(object, params);
            }
        });
    }

    private static class FileLocationDetails {
        Path path;
        IFileStore fileStore;
        IFileInfo fileInfo;
        int line = -1;
        int column = -1;

        private FileLocationDetails() {
        }

        private static FileLocationDetails resolve(String path) {
            FileLocationDetails details = FileLocationDetails.checkLocation(path, -1, -1);
            if (details != null) {
                return details;
            }
            Pattern lPattern = Pattern.compile("^(?<path>.*?)[+:](?<line>\\d+)$");
            Pattern lcPattern = Pattern.compile("^(?<path>.*?)[+:](?<line>\\d+):(?<column>\\d+)$");
            Matcher m = lPattern.matcher(path);
            if (m.matches()) {
                try {
                    details = FileLocationDetails.checkLocation(m.group("path"), Integer.parseInt(m.group("line")), -1);
                    if (details != null) {
                        return details;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if ((m = lcPattern.matcher(path)).matches()) {
                try {
                    details = FileLocationDetails.checkLocation(m.group("path"), Integer.parseInt(m.group("line")), m.group("column") != null ? Integer.parseInt(m.group("column")) : -1);
                    if (details != null) {
                        return details;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return null;
        }

        private static FileLocationDetails checkLocation(String path, int line, int column) {
            FileLocationDetails spec = new FileLocationDetails();
            spec.path = new Path(path);
            spec.fileStore = EFS.getLocalFileSystem().getStore((IPath)spec.path);
            spec.fileInfo = spec.fileStore.fetchInfo();
            spec.line = line;
            spec.column = column;
            return spec.fileInfo.exists() ? spec : null;
        }
    }
}

