/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx;

import java.util.HashMap;
import java.util.Map;
import javafx.application.Application;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.fx.core.databinding.JFXRealm;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.osgi.util.AbstractJFXApplication;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.services.startup.StartupProgressTrackerService;
import org.eclipse.fx.ui.services.sync.UISynchronize;
import org.eclipse.fx.ui.services.theme.Theme;
import org.eclipse.fx.ui.services.theme.ThemeManager;
import org.eclipse.fx.ui.workbench.base.AbstractE4Application;
import org.eclipse.fx.ui.workbench.fx.DefaultJFXApp;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.fx.internal.GraphicsLoaderImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.prefs.BackingStoreException;

public class E4Application
extends AbstractE4Application {
    static Logger LOGGER = LoggerCreator.createLogger(E4Application.class);
    E4Workbench workbench;
    Location instanceLocation;
    IEclipseContext workbenchContext;
    private static final String PRIMARY_STAGE_KEY = "primaryStage";
    private static final String CREATE_WORKBENCH_ON_NON_UI_THREAD_ARG = "createWorkbenchOnNonUIThread";
    static E4Application SELF;
    IApplicationContext applicationContext;
    Object returnValue;
    protected EventAdmin eventAdmin;

    public static @NonNull E4Application getE4Application() {
        E4Application self = SELF;
        if (self == null) {
            throw new IllegalStateException("Application not yet initialized");
        }
        return self;
    }

    public Object start(IApplicationContext context) throws Exception {
        ServiceReference serviceReference;
        SELF = this;
        this.applicationContext = context;
        Bundle b = FrameworkUtil.getBundle(AbstractJFXApplication.class);
        BundleContext bundleContext = b.getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(EventAdmin.class);
        if (ref != null) {
            this.eventAdmin = (EventAdmin)bundleContext.getService(ref);
        }
        if ((serviceReference = bundleContext.getServiceReference(StartupProgressTrackerService.class)) != null) {
            ((StartupProgressTrackerService)bundleContext.getService(serviceReference)).osgiApplicationLaunched(this.applicationContext);
        } else {
            this.applicationContext.applicationRunning();
        }
        this.launchE4JavaFxApplication();
        try {
            Object object = this.returnValue == null ? IApplication.EXIT_OK : this.returnValue;
            return object;
        }
        finally {
            this.returnValue = null;
        }
    }

    public void jfxStart(final IApplicationContext context, final Application jfxApplication, final Stage primaryStage) {
        Bundle b = FrameworkUtil.getBundle(AbstractJFXApplication.class);
        BundleContext bundleContext = b.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(StartupProgressTrackerService.class);
        StartupProgressTrackerService service = null;
        if (serviceReference != null) {
            service = (StartupProgressTrackerService)bundleContext.getService(serviceReference);
            service.stateReached((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.JAVAFX_INITIALIZED);
        }
        final StartupProgressTrackerService fservice = service;
        Runnable startRunnable = new Runnable(){

            @Override
            public void run() {
                if (E4Application.this.workbench == null && !E4Application.this.initE4Workbench(context, jfxApplication, primaryStage)) {
                    E4Application.this.calculateReturnValue();
                    return;
                }
                E4Workbench workbench = E4Application.this.workbench;
                if (workbench == null) {
                    throw new IllegalStateException("Not workbench instance yet available");
                }
                IEclipseContext wbContext = workbench.getContext();
                if (wbContext == null) {
                    throw new IllegalStateException("The workbench has no context assigned");
                }
                UISynchronize uiSync = (UISynchronize)workbench.getContext().get(UISynchronize.class);
                uiSync.syncExec(() -> {
                    E4Application.this.instanceLocation = (Location)wbContext.get("instanceLocation");
                    try {
                        if (!E4Application.this.checkInstanceLocation(E4Application.this.instanceLocation, wbContext)) {
                            if (fservice != null) {
                                fservice.stateReached((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.LOCATION_CHECK_FAILED);
                            }
                            return;
                        }
                        workbench.createAndRunUI((MApplicationElement)E4Application.this.workbench.getApplication());
                    }
                    finally {
                        E4Application.this.postJfxStarted(context);
                    }
                });
            }
        };
        if (E4Application.getArgValue((String)CREATE_WORKBENCH_ON_NON_UI_THREAD_ARG, (IApplicationContext)context, (boolean)true) != null) {
            Thread t = new Thread(startRunnable);
            t.start();
        } else {
            startRunnable.run();
        }
    }

    protected void preLifecycle(IEclipseContext appContext) {
        super.preLifecycle(appContext);
        appContext.set(GraphicsLoader.class, (Object)((GraphicsLoader)ContextInjectionFactory.make(GraphicsLoaderImpl.class, (IEclipseContext)appContext)));
    }

    public void jfxStop() {
        block8: {
            this.calculateReturnValue();
            try {
                ThemeManager manager;
                Theme theme;
                if (this.workbenchContext == null || this.workbench == null) break block8;
                if (this.getLifecycleManager() != null) {
                    ContextInjectionFactory.invoke((Object)this.getLifecycleManager(), PreSave.class, (IEclipseContext)this.workbenchContext, null);
                }
                if ((theme = (manager = (ThemeManager)this.workbenchContext.get(ThemeManager.class)).getCurrentTheme()) != null) {
                    IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.fx.ui.workbench.fx");
                    node.put("cssTheme", theme.getId());
                    try {
                        node.flush();
                    }
                    catch (BackingStoreException e) {
                        LOGGER.error("Failed to remember the theme id", (Throwable)e);
                    }
                }
                this.workbench.close();
                this.saveModel();
            }
            finally {
                if (this.instanceLocation != null) {
                    this.instanceLocation.release();
                }
            }
        }
    }

    void calculateReturnValue() {
        Object result = null;
        if (this.workbenchContext != null && (result = this.workbenchContext.get("e4.osgi.exit.code")) == null && this.workbench != null && this.workbench.isRestart()) {
            result = IApplication.EXIT_RESTART;
        }
        if (result != null) {
            this.returnValue = result;
        }
    }

    public void stop() {
    }

    public boolean initE4Workbench(IApplicationContext context, Application jfxApplication, Stage primaryStage) {
        this.workbenchContext = this.createApplicationContext();
        this.workbenchContext.set(Application.class, (Object)jfxApplication);
        this.workbenchContext.set(IApplicationContext.class, (Object)context);
        this.workbenchContext.set(PRIMARY_STAGE_KEY, (Object)primaryStage);
        this.workbench = this.createE4Workbench(context, this.workbenchContext);
        return this.workbench != null;
    }

    public IApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected void launchE4JavaFxApplication() throws Exception {
        Application.launch(this.getJfxApplicationClass(), (String[])new String[0]);
    }

    protected Class<? extends Application> getJfxApplicationClass() {
        return DefaultJFXApp.class;
    }

    protected void postJfxStarted(IApplicationContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.sendEvent("org/eclipse/fx/E4Application/Launched", map);
        Bundle b = FrameworkUtil.getBundle(AbstractJFXApplication.class);
        BundleContext bundleContext = b.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(StartupProgressTrackerService.class);
        if (serviceReference != null) {
            ((StartupProgressTrackerService)bundleContext.getService(serviceReference)).stateReached((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.WORKBENCH_GUI_SHOWING);
        }
    }

    protected Realm createRealm(IEclipseContext appContext) {
        return JFXRealm.createDefault();
    }

    protected IResourceUtilities<Image> createResourceUtility(final IEclipseContext appContext) {
        return new IResourceUtilities<Image>(){

            public Image imageDescriptorFromURI(URI iconPath) {
                if (iconPath == null) {
                    return null;
                }
                GraphicsLoader l = (GraphicsLoader)appContext.get(GraphicsLoader.class);
                return l.getImage((org.eclipse.fx.core.URI)new EMFUri(iconPath));
            }
        };
    }

    protected String getDefaultPresentationEngineURI(IEclipseContext appContext) {
        return "bundleclass://org.eclipse.fx.ui.workbench.fx/org.eclipse.fx.ui.workbench.fx.PartRenderingEngine";
    }

    protected void sendEvent(String topic, Map<String, Object> map) {
        if (this.eventAdmin != null) {
            this.eventAdmin.sendEvent(new Event(topic, map));
        } else {
            LOGGER.warningf("Could not send the %s event. EventAdmin is missing.", new Object[]{topic});
        }
    }
}

