/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr.ex.common;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.generator.parser.antlr.ex.common.KeywordHelper;
import org.eclipse.xtext.parser.antlr.AntlrTokenDefProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class MutableTokenDefProvider
extends AntlrTokenDefProvider {
    private final Charset encoding;
    private final KeywordHelper keywordHelper;

    public MutableTokenDefProvider(KeywordHelper keywordHelper, Charset encoding) {
        this.encoding = encoding;
        this.keywordHelper = keywordHelper;
    }

    @Deprecated
    public MutableTokenDefProvider() {
        this(null, Charset.defaultCharset());
    }

    protected BufferedReader createReader(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream, this.encoding));
    }

    public void writeTokenFile(PrintWriter out) throws IOException {
        ArrayList entries = Lists.newArrayList(this.getTokenDefMap().entrySet());
        ListExtensions.sortInplaceBy((List)entries, (Functions.Function1)new Functions.Function1<Map.Entry<Integer, String>, String>(){

            public String apply(Map.Entry<Integer, String> p) {
                return p.getValue();
            }
        });
        for (Map.Entry entry : entries) {
            out.print((String)entry.getValue());
            out.print('=');
            out.println(entry.getKey());
        }
        out.close();
    }

    protected boolean isKeywordToken(String antlrTokenDef) {
        if (this.keywordHelper != null) {
            return this.keywordHelper.isKeywordRule(antlrTokenDef);
        }
        return super.isKeywordToken(antlrTokenDef);
    }

    protected void setTokenDefMap(Map<Integer, String> tokenDefMap) {
        this.tokenDefMap = tokenDefMap;
    }
}

