/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.e4.addons;

import java.net.MalformedURLException;
import java.net.URI;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.SourceFileChange;
import org.eclipse.fx.code.editor.services.URIProvider;
import org.osgi.service.event.Event;

public class DirtyStateTrackingAddon {
    private EModelService modelService;
    private MApplication application;
    private final IEventBroker broker;

    @Inject
    public DirtyStateTrackingAddon(IEventBroker broker, EModelService modelService, MApplication application) {
        this.broker = broker;
        this.modelService = modelService;
        this.application = application;
    }

    @PostConstruct
    void init() {
        this.broker.subscribe("at/bestsolution/dart/editor/file-input/modified", this::handleDocumentModified);
        this.broker.subscribe("at/bestsolution/dart/editor/file-input/saved", this::handleDocumentSaved);
        this.broker.subscribe("org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*", this::handlePartDirty);
    }

    void handlePartDirty(Event event) {
        Object element = event.getProperty("ChangedElement");
        if (element instanceof MContext) {
            ((MContext)element).getContext().set("code-editor-dirty", event.getProperty("NewValue"));
            this.broker.send("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
        }
    }

    void handleDocumentSaved(Event event) {
        Input input = (Input)event.getProperty("org.eclipse.e4.data");
        String tmpUri = "";
        try {
            tmpUri = URI.create(((URIProvider)input).getURI().toString()).toURL().toExternalForm();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        String uri = tmpUri;
        this.modelService.findElements((MApplicationElement)this.application, MPart.class, 29, e -> {
            if (e instanceof MPart) {
                return ((MPart)e).getContext() != null && uri.equals(((MPart)e).getContext().getLocal("documentUrl"));
            }
            return false;
        }).forEach(e -> e.setDirty(false));
    }

    void handleDocumentModified(Event event) {
        SourceFileChange change = (SourceFileChange)event.getProperty("org.eclipse.e4.data");
        String tmpUri = "";
        try {
            tmpUri = URI.create(change.input.getURI().toString()).toURL().toExternalForm();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        String uri = tmpUri;
        this.modelService.findElements((MApplicationElement)this.application, MPart.class, 29, e -> {
            if (e instanceof MPart) {
                return ((MPart)e).getContext() != null && uri.equals(((MPart)e).getContext().getLocal("documentUrl"));
            }
            return false;
        }).forEach(e -> e.setDirty(true));
    }
}

