/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import org.eclipse.fx.ui.controls.styledtext.internal.ReuseCache;
import org.eclipse.jdt.annotation.NonNull;

public class TextNode
extends HBox {
    private static final @NonNull CssMetaData<TextNode, @NonNull Paint> FILL = new CssMetaData<TextNode, Paint>("-fx-fill", StyleConverter.getPaintConverter(), (Paint)Color.BLACK){

        public boolean isSettable(TextNode styleable) {
            return !styleable.fillProperty().isBound();
        }

        public StyleableProperty<@NonNull Paint> getStyleableProperty(TextNode styleable) {
            return (StyleableProperty)styleable.fill;
        }
    };
    final @NonNull ObjectProperty<@NonNull Paint> fill = new SimpleStyleableObjectProperty(FILL, (Object)this, "fill", (Object)Color.BLACK);
    private static String[] BASIC_STRING_CACHE = new String[256];
    private static final @NonNull CssMetaData<TextNode, @NonNull Number> TABCHARADANCE = new CssMetaData<TextNode, Number>("-efx-tab-char-advance", StyleConverter.getSizeConverter(), (Number)4){

        public boolean isSettable(TextNode styleable) {
            return !styleable.tabCharAdvanceProperty().isBound();
        }

        public StyleableProperty<@NonNull Number> getStyleableProperty(TextNode styleable) {
            return (StyleableProperty)styleable.tabCharAdvance;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    @NonNull IntegerProperty tabCharAdvance = new SimpleStyleableIntegerProperty(TABCHARADANCE, (Object)this, "tabCharAdvance", Integer.valueOf(4));
    private int startOffset;
    private List<Integer> tabPositions = new ArrayList<Integer>();
    private String originalText;
    private List<Text> activeLetters = new ArrayList<Text>();
    private ReuseCache<Text> cache;

    static {
        ArrayList<CssMetaData<TextNode, Paint>> styleables = new ArrayList<CssMetaData<TextNode, Paint>>(Region.getClassCssMetaData());
        styleables.add(FILL);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private static String toString(char c) {
        String rv = null;
        if (c < BASIC_STRING_CACHE.length && (rv = BASIC_STRING_CACHE[c]) == null) {
            TextNode.BASIC_STRING_CACHE[c] = String.valueOf(c);
        }
        if (rv == null) {
            rv = String.valueOf(c);
        }
        return rv;
    }

    public final @NonNull ObjectProperty<@NonNull Paint> fillProperty() {
        return this.fill;
    }

    public final @NonNull Paint getFill() {
        return (Paint)this.fillProperty().get();
    }

    public final void setFill(@NonNull Paint color) {
        this.fillProperty().set((Object)color);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TextNode.getClassCssMetaData();
    }

    public final IntegerProperty tabCharAdvanceProperty() {
        return this.tabCharAdvance;
    }

    public final int getTabCharAdvance() {
        return this.tabCharAdvanceProperty().get();
    }

    public final void setTabCharAdvance(int tabCharAdvance) {
        this.tabCharAdvanceProperty().set(tabCharAdvance);
    }

    public TextNode(String text) {
        this.setMinWidth(-1.0);
        this.cache = new ReuseCache<Text>(() -> {
            Text letter = new Text();
            letter.setBoundsType(TextBoundsType.LOGICAL_VERTICAL_CENTER);
            return letter;
        });
        this.cache.addOnActivate(node -> this.getChildren().add(node));
        this.cache.addOnRelease(node -> this.getChildren().remove(node));
        this.getStyleClass().add((Object)"styled-text-node");
        this.originalText = text;
        this.rebuildText(text);
        this.tabCharAdvance.addListener(o -> this.rebuildText(text));
        this.cache.addOnActivate(n -> n.fillProperty().bind(this.fillProperty()));
        this.cache.addOnRelease(n -> n.fillProperty().unbind());
    }

    public void updateText(String text) {
        this.rebuildText(text);
        this.originalText = text;
    }

    private void rebuildText(String text) {
        for (Text t : this.activeLetters) {
            this.cache.releaseElement(t);
        }
        this.activeLetters.clear();
        char[] cArray = this.processText(text).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Text textNode = this.cache.getElement();
            textNode.setText(TextNode.toString(c));
            this.activeLetters.add(textNode);
            ++n2;
        }
    }

    private String processText(String text) {
        String tmp = text;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.tabCharAdvance.get()) {
            b.append(" ");
            ++i;
        }
        int position = -1;
        this.tabPositions.clear();
        while ((position = tmp.indexOf(9)) != -1) {
            tmp = tmp.replaceFirst("\t", b.toString());
            this.tabPositions.add(position);
        }
        return tmp;
    }

    void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    @Deprecated
    public int getStartOffset() {
        return this.startOffset;
    }

    @Deprecated
    public int getEndOffset() {
        return this.startOffset + this.getText().length();
    }

    public boolean intersectOffset(int start, int end) {
        if (this.getStartOffset() > end) {
            return false;
        }
        return this.getEndOffset() >= start;
    }

    public String toString() {
        return "'" + this.originalText + "'";
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public String getText() {
        return this.originalText;
    }

    protected void layoutChildren() {
        super.layoutChildren();
    }

    public int getCaretIndexAtPoint(Point2D point) {
        Point2D local = this.sceneToLocal(this.localToScene(point));
        Optional<Node> charNode = this.getChildren().stream().filter(n -> n.getBoundsInParent().contains(local)).findFirst();
        if (charNode.isPresent()) {
            Node node = charNode.get();
            int idx = this.getChildren().indexOf((Object)node);
            Bounds bounds = node.getBoundsInParent();
            if (bounds.getMinX() + bounds.getWidth() / 2.0 < local.getX()) {
                ++idx;
            }
            int toRemove = 0;
            for (Integer i : this.tabPositions) {
                if (i <= idx && idx < i + this.tabCharAdvance.get()) {
                    toRemove += idx - i;
                    if ((idx - i) % this.tabCharAdvance.get() < this.tabCharAdvance.get() / 2) break;
                    ++idx;
                    break;
                }
                if (i >= idx) continue;
                toRemove += this.tabCharAdvance.get() - 1;
            }
            return idx -= toRemove;
        }
        return -1;
    }

    public double getCharLocation(int index) {
        int realIndex = index;
        for (Integer i : this.tabPositions) {
            if (i >= realIndex) continue;
            realIndex += this.tabCharAdvance.get() - 1;
        }
        if (realIndex >= 0 && realIndex < this.getChildren().size()) {
            return this.localToParent(((Node)this.getChildren().get(realIndex)).getBoundsInParent()).getMinX();
        }
        if (!this.getChildren().isEmpty()) {
            return this.localToParent(((Node)this.getChildren().get(this.getChildren().size() - 1)).getBoundsInParent()).getMaxX();
        }
        return 0.0;
    }

    public static interface DecorationStrategy {
        public void attach(TextNode var1, Node var2);

        public void unattach(TextNode var1, Node var2);

        public void layout(TextNode var1, Node var2);
    }
}

