/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.contentassist;

import com.sun.javafx.tk.Toolkit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.PopupWindow;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.text.hover.HtmlString;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.ContentAssistContextData;
import org.eclipse.fx.text.ui.contentassist.ContentAssistant;
import org.eclipse.fx.text.ui.contentassist.ICompletionProposal;
import org.eclipse.fx.text.ui.contentassist.IContentAssistListener;
import org.eclipse.fx.text.ui.internal.SimpleHtmlViewer;
import org.eclipse.fx.ui.controls.list.SimpleListCell;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;

public class ContentProposalPopup
implements IContentAssistListener {
    ITextViewer viewer;
    private PopupWindow stage;
    private ListView<ICompletionProposal> proposalList;
    private SimpleHtmlViewer htmlViewer;
    private String prefix;
    int offset;
    private Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer;
    private ContentAssistant fContentAssistant;
    private ChangeListener<Number> selectionChange;
    private ICompletionProposal chosenProposal = null;
    private final ThreadSynchronize threadSync;
    private final EventHandler<MouseEvent> mouseEvent;

    public ContentProposalPopup(ThreadSynchronize threadSync, ContentAssistant assistant, ITextViewer viewer, Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer) {
        this.threadSync = threadSync;
        this.viewer = viewer;
        this.proposalComputer = proposalComputer;
        this.fContentAssistant = assistant;
        this.selectionChange = this::onSelectionChange;
        this.mouseEvent = this::onMouseEvent;
    }

    public Optional<ICompletionProposal> displayProposals(List<ICompletionProposal> proposalList, int offset, Point2D position) {
        this.setup();
        if (this.stage.isShowing()) {
            return Optional.empty();
        }
        this.prefix = "";
        this.offset = offset;
        this.proposalList.setItems(FXCollections.observableArrayList(proposalList));
        this.proposalList.getSelectionModel().select(0);
        this.stage.setX(position.getX());
        this.stage.setY(position.getY());
        this.stage.setWidth(300.0);
        this.stage.setHeight(200.0);
        this.stage.requestFocus();
        this.stage.setOnShowing(this::subscribe);
        this.stage.setOnHidden(this::unsubscribe);
        this.stage.show(this.viewer.getTextWidget().getScene().getWindow());
        this.proposalList.requestFocus();
        this.chosenProposal = null;
        Toolkit.getToolkit().checkFxUserThread();
        Toolkit.getToolkit().enterNestedEventLoop((Object)this);
        return Optional.ofNullable(this.chosenProposal);
    }

    public void close() {
        this.stage.hide();
    }

    private void subscribe(Event e) {
        this.viewer.getTextWidget().caretOffsetProperty().addListener(this.selectionChange);
        this.viewer.getTextWidget().getScene().addEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseEvent);
    }

    private void unsubscribe(Event e) {
        this.viewer.getTextWidget().caretOffsetProperty().removeListener(this.selectionChange);
        this.viewer.getTextWidget().getScene().removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mouseEvent);
    }

    private void onMouseEvent(MouseEvent e) {
        this.close();
    }

    private void onSelectionChange(Observable x, Number oldSelection, Number newSelection) {
        this.offset = this.viewer.getTextWidget().getCaretOffset();
        this.updateProposals();
    }

    private void updateProposals() {
        List<ICompletionProposal> list = this.proposalComputer.apply(new ContentAssistContextData(this.offset, this.viewer.getDocument()));
        if (!list.isEmpty()) {
            this.proposalList.setItems(FXCollections.observableArrayList(list));
            this.proposalList.scrollTo(0);
            this.proposalList.getSelectionModel().select(0);
            this.proposalList.requestFocus();
        } else {
            this.stage.hide();
        }
    }

    private void cancelProposal() {
        this.chosenProposal = null;
        this.close();
    }

    private void applySelectedProposal() {
        ICompletionProposal selectedItem;
        this.chosenProposal = selectedItem = (ICompletionProposal)this.proposalList.getSelectionModel().getSelectedItem();
        this.close();
    }

    private void handleMouseClicked(MouseEvent event) {
        if (event.isStillSincePress() && event.getClickCount() == 2) {
            this.applySelectedProposal();
        }
    }

    private void handleKeyPressed(KeyEvent event) {
        switch (event.getCode()) {
            case ESCAPE: {
                event.consume();
                this.cancelProposal();
                break;
            }
            case ENTER: {
                event.consume();
                this.applySelectedProposal();
                break;
            }
            case LEFT: {
                event.consume();
                this.viewer.getTextWidget().setCaretOffset(Math.max(0, this.viewer.getTextWidget().getCaretOffset() - 1));
                break;
            }
            case RIGHT: {
                event.consume();
                this.viewer.getTextWidget().setCaretOffset(Math.min(this.viewer.getDocument().getLength() - 1, this.viewer.getTextWidget().getCaretOffset() + 1));
                break;
            }
        }
    }

    private static HtmlString getHtml(ICompletionProposal proposal) {
        if (proposal != null && proposal.getHoverInfo() != null) {
            if (proposal.getHoverInfo() instanceof HtmlString) {
                return (HtmlString)proposal.getHoverInfo();
            }
            if (proposal.getHoverInfo().toString().startsWith("<html>")) {
                return new HtmlString(proposal.getHoverInfo().toString());
            }
            return new HtmlString("<html><body><pre>" + proposal.getHoverInfo() + "</pre></body></html>");
        }
        return new HtmlString("<html></html>");
    }

    private void setup() {
        if (this.stage == null) {
            this.stage = new PopupWindow(){};
            this.stage.setAutoFix(false);
            this.stage.setWidth(300.0);
            this.stage.setHeight(200.0);
            BorderPane p = new BorderPane();
            p.getStyleClass().add((Object)"content-proposal-container");
            p.setPrefHeight(200.0);
            p.setPrefWidth(600.0);
            this.stage.getScene().addEventFilter(KeyEvent.KEY_PRESSED, this::handleKeyPressed);
            this.stage.getScene().focusOwnerProperty().addListener(o -> System.err.println(this.stage.getScene().focusOwnerProperty().get()));
            this.stage.getScene().getStylesheets().addAll((Collection)this.viewer.getTextWidget().getScene().getStylesheets());
            this.proposalList = new ListView();
            this.proposalList.setMinWidth(300.0);
            this.proposalList.getStyleClass().add((Object)"content-proposal-list");
            this.proposalList.setOnMouseClicked(this::handleMouseClicked);
            this.htmlViewer = new SimpleHtmlViewer();
            this.htmlViewer.setPrefWidth(300.0);
            this.proposalList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.htmlViewer.setContent(ContentProposalPopup.getHtml(newValue)));
            Function<ICompletionProposal, CharSequence> label = c -> c.getLabel();
            Function<ICompletionProposal, Node> graphic = c -> c.getGraphic();
            Function<ICompletionProposal, List> css = c -> Collections.emptyList();
            this.proposalList.setCellFactory(v -> new SimpleListCell(label, graphic, css));
            p.setCenter(this.proposalList);
            StackPane border = new StackPane();
            border.getStyleClass().add((Object)"content-proposal-doc");
            border.getChildren().add((Object)this.htmlViewer);
            p.setRight((Node)border);
            p.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITESMOKE, new CornerRadii(3.0), Insets.EMPTY)}));
            p.setPadding(new Insets(5.0));
            this.stage.getScene().setRoot((Parent)p);
            this.stage.focusedProperty().addListener(o -> {
                if (this.stage != null && !this.stage.isFocused()) {
                    Platform.runLater(() -> ((PopupWindow)this.stage).hide());
                }
            });
            this.stage.setOnHidden(o -> {
                this.stage = null;
            });
            this.stage.showingProperty().addListener((x, o, n) -> {
                if (!n.booleanValue()) {
                    Toolkit.getToolkit().exitNestedEventLoop((Object)this, null);
                }
            });
        }
    }

    @Override
    public boolean verifyKey(VerifyEvent event) {
        return true;
    }
}

