/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.text.Font;
import org.eclipse.fx.ui.controls.styledtext.internal.VerticalLineFlow;
import org.eclipse.fx.ui.controls.styledtext.model.Annotation;
import org.eclipse.fx.ui.controls.styledtext.model.LineRulerAnnotationPresenter;

public class LineRuler
extends VerticalLineFlow<Integer, Annotation> {
    private LineRulerAnnotationPresenter.LayoutHint h;
    private DoubleProperty fixedWidth = new SimpleDoubleProperty((Object)this, "fixedWidth");
    private DoubleProperty yOffset = new SimpleDoubleProperty((Object)this, "yOffset");
    private ObjectProperty<Font> font = new SimpleObjectProperty((Object)this, "font", (Object)Font.getDefault());

    public DoubleProperty yOffsetProperty() {
        return this.yOffset;
    }

    public LineRuler(LineRulerAnnotationPresenter.LayoutHint h, Function<Integer, Set<Annotation>> converter, Predicate<Set<Annotation>> needsPresentation, Supplier<Node> nodeFactory, BiConsumer<Node, Set<Annotation>> nodePopulator) {
        super(converter, needsPresentation, nodeFactory, nodePopulator);
        this.h = h;
        this.yOffset.addListener((x, o, n) -> this.requestLayout());
        this.fixedWidth.addListener((x, o, n) -> this.requestLayout());
    }

    protected double computeMinWidth(double height) {
        return this.fixedWidth.get();
    }

    protected double computeMaxWidth(double height) {
        return this.fixedWidth.get();
    }

    public DoubleProperty fixedWidthProperty() {
        return this.fixedWidth;
    }

    @Override
    protected void layoutChildren() {
        this.activeNodes.entrySet().forEach(e -> {
            double x = 0.0;
            double y = -this.yOffset.get() + (double)((Integer)e.getKey()).intValue() * this.lineHeightProperty().get();
            double width = this.getWidth();
            double height = this.getLineHeight();
            if (this.h == LineRulerAnnotationPresenter.LayoutHint.ALIGN_RIGHT) {
                ((Node)e.getValue()).autosize();
                w = ((Node)e.getValue()).getBoundsInLocal().getWidth();
                x = width - w;
                width = w;
            } else if (this.h == LineRulerAnnotationPresenter.LayoutHint.ALIGN_CENTER) {
                ((Node)e.getValue()).autosize();
                w = ((Node)e.getValue()).getBoundsInLocal().getWidth();
                x = width / 2.0 - w / 2.0;
                width = w;
            }
            double dy = 0.0;
            ((Node)e.getValue()).resizeRelocate(x, y + dy, width, height);
        });
    }

    public int findLineIndex(Point2D localPoint) {
        double y = localPoint.getY();
        double yOffset = this.yOffsetProperty().get();
        double lineHeight = this.lineHeightProperty().get();
        double yAbsolute = yOffset + y;
        return (int)Math.floor(yAbsolute / lineHeight);
    }
}

