/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.concurrent.future;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IListenableFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.SingleOperationFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleOperationListenableFuture<ResultType>
extends SingleOperationFuture<ResultType>
implements IListenableFuture<ResultType> {
    private IProgressRunnable<ResultType> progressRunnable;
    private IProgressMonitor progressMonitor;
    private IExecutor listenerExecutor;

    public SingleOperationListenableFuture() {
    }

    public SingleOperationListenableFuture(IProgressMonitor progressMonitor) {
        super(progressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IExecutor executor, IProgressRunnable<ResultType> progressRunnable, IProgressMonitor monitor) {
        Assert.isNotNull((Object)executor);
        Assert.isNotNull(progressRunnable);
        SingleOperationListenableFuture singleOperationListenableFuture = this;
        synchronized (singleOperationListenableFuture) {
            if (this.progressRunnable == null) {
                this.progressRunnable = progressRunnable;
                this.progressMonitor = monitor;
                this.listenerExecutor = executor;
                if (this.isDone()) {
                    this.execListenable();
                }
            }
        }
    }

    @Override
    public void runWithProgress(final IProgressRunnable<?> runnable) {
        Assert.isNotNull(runnable);
        if (!this.isCanceled()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleException(Throwable exception) {
                    SingleOperationListenableFuture singleOperationListenableFuture = SingleOperationListenableFuture.this;
                    synchronized (singleOperationListenableFuture) {
                        if (!SingleOperationListenableFuture.this.isCanceled()) {
                            SingleOperationListenableFuture.this.setException(exception);
                        }
                        SingleOperationListenableFuture.this.execListenable();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws Exception {
                    Object result = runnable.run(SingleOperationListenableFuture.this.getProgressMonitor());
                    SingleOperationListenableFuture singleOperationListenableFuture = SingleOperationListenableFuture.this;
                    synchronized (singleOperationListenableFuture) {
                        if (!SingleOperationListenableFuture.this.isCanceled()) {
                            SingleOperationListenableFuture.this.set(result);
                        }
                        SingleOperationListenableFuture.this.execListenable();
                    }
                }
            });
        }
    }

    private void execListenable() {
        if (this.progressRunnable == null || this.listenerExecutor == null) {
            return;
        }
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        this.listenerExecutor.execute(this.progressRunnable, this.progressMonitor);
    }
}

