/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.MapProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.identity.IdentityMap;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class SetPropertyDetailValuesMap<S, M, T>
extends MapProperty<S, M, T> {
    private final ISetProperty<S, M> masterProperty;
    private final IValueProperty<? super M, T> detailProperty;

    public SetPropertyDetailValuesMap(ISetProperty<S, M> masterProperty, IValueProperty<? super M, T> detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    @Override
    public Object getKeyType() {
        return this.masterProperty.getElementType();
    }

    @Override
    public Object getValueType() {
        return this.detailProperty.getValueType();
    }

    @Override
    protected Map<M, T> doGetMap(S source) {
        Set<M> set = this.masterProperty.getSet(source);
        IdentityMap map = new IdentityMap();
        for (M key : set) {
            map.put(key, this.detailProperty.getValue(key));
        }
        return map;
    }

    @Override
    protected void doUpdateMap(S source, MapDiff<M, T> diff) {
        if (!diff.getAddedKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.valueOf(this.toString()) + " does not support entry additions");
        }
        if (!diff.getRemovedKeys().isEmpty()) {
            throw new UnsupportedOperationException(String.valueOf(this.toString()) + " does not support entry removals");
        }
        for (Object key : diff.getChangedKeys()) {
            Object newValue = diff.getNewValue(key);
            this.detailProperty.setValue(key, newValue);
        }
    }

    @Override
    public IObservableMap<M, T> observe(Realm realm, S source) {
        IObservableSet<M> masterSet;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterSet = this.masterProperty.observe(realm, source);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableMap<M, T> detailMap = this.detailProperty.observeDetail(masterSet);
        PropertyObservableUtil.cascadeDispose(detailMap, masterSet);
        return detailMap;
    }

    @Override
    public <U extends S> IObservableMap<M, T> observeDetail(IObservableValue<U> master) {
        IObservableSet<M> masterSet;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterSet = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableMap<M, T> detailMap = this.detailProperty.observeDetail(masterSet);
        PropertyObservableUtil.cascadeDispose(detailMap, masterSet);
        return detailMap;
    }

    public String toString() {
        return this.masterProperty + " => " + this.detailProperty;
    }
}

