/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.skin;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.fx.ui.controls.styledtext.TextChangedEvent;
import org.eclipse.fx.ui.controls.styledtext.TextChangingEvent;
import org.eclipse.fx.ui.controls.styledtext.behavior.StyledTextBehavior;
import org.eclipse.fx.ui.controls.styledtext.internal.ContentView;
import org.eclipse.fx.ui.controls.styledtext.internal.FXBindUtil;
import org.eclipse.fx.ui.controls.styledtext.internal.LineHelper;
import org.eclipse.fx.ui.controls.styledtext.internal.LineRuler;
import org.eclipse.fx.ui.controls.styledtext.internal.ScrollbarPane;
import org.eclipse.fx.ui.controls.styledtext.internal.Scroller;
import org.eclipse.fx.ui.controls.styledtext.internal.TextNode;
import org.eclipse.fx.ui.controls.styledtext.model.Annotation;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationPresenter;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationProvider;
import org.eclipse.fx.ui.controls.styledtext.model.LineRulerAnnotationPresenter;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotationPresenter;

public class StyledTextSkin
extends SkinBase<StyledTextArea> {
    private ScrollbarPane<ContentView> contentArea;
    private ContentView content;
    Scroller scroller;
    private HBox lineRulerArea;
    private ObservableList<LineRuler> sortedLineRulerFlows;
    private HBox rootContainer;
    private final StyledTextBehavior behavior;
    private LineHelper lineHelper;
    private static final String CSS_CLASS_LINE_RULER = "line-ruler";
    private static final String CSS_CLASS_SPACER = "spacer";
    private static final String CSS_LIST_VIEW = "list-view";
    private SortedList<LineRulerAnnotationPresenter> sortedLineRulerPresenters;

    public StyledTextSkin(StyledTextArea styledText) {
        this(styledText, new StyledTextBehavior(styledText));
    }

    public StyledTextSkin(StyledTextArea styledText, StyledTextBehavior behavior) {
        super((Control)styledText);
        this.behavior = behavior;
        this.rootContainer = new HBox();
        this.rootContainer.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, e -> e.consume());
        this.rootContainer.setSpacing(0.0);
        this.lineRulerArea = new HBox();
        this.lineRulerArea.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.rootContainer.getChildren().add((Object)this.lineRulerArea);
        styledText.caretOffsetProperty().addListener((obs, ol, ne) -> {
            int lineIdx = styledText.getContent().getLineAtOffset(ne.intValue());
            int colIdx = ne.intValue() - styledText.getContent().getOffsetAtLine(lineIdx);
            String line = styledText.getContent().getLine(lineIdx).substring(0, colIdx);
            int tabCount = (int)line.chars().filter(c -> c == 9).count();
            this.scrollColumnIntoView(colIdx + tabCount * (styledText.tabAvanceProperty().get() - 1), 12);
            this.scrollLineIntoView(lineIdx);
        });
        Region spacer = new Region();
        spacer.getStyleClass().addAll((Object[])new String[]{CSS_CLASS_LINE_RULER, CSS_CLASS_SPACER});
        spacer.setMinWidth(2.0);
        spacer.setMaxWidth(2.0);
        this.rootContainer.getChildren().add((Object)spacer);
        this.lineHelper = new LineHelper((StyledTextArea)this.getSkinnable());
        this.content = new ContentView(this.lineHelper, styledText);
        this.content.lineHeightProperty().bind((ObservableValue)styledText.fixedLineHeightProperty());
        this.contentArea = new ScrollbarPane();
        this.contentArea.setCenter(this.content);
        HashMap<AnnotationProvider, Subscription> subscriptions = new HashMap<AnnotationProvider, Subscription>();
        Consumer<RangeSet<Integer>> onAnnotationChange = r -> {
            this.content.updateAnnotations((RangeSet<Integer>)r);
            this.sortedLineRulerFlows.forEach(f -> f.update((RangeSet<Integer>)r));
        };
        ((StyledTextArea)this.getSkinnable()).getAnnotationProvider().addListener(c -> {
            Subscription s;
            if (c.wasAdded()) {
                s = ((AnnotationProvider)c.getElementAdded()).registerChangeListener(onAnnotationChange);
                subscriptions.put((AnnotationProvider)c.getElementAdded(), s);
            }
            if (c.wasRemoved() && (s = (Subscription)subscriptions.remove(c.getElementRemoved())) != null) {
                s.dispose();
            }
        });
        for (AnnotationProvider p2 : ((StyledTextArea)this.getSkinnable()).getAnnotationProvider()) {
            if (subscriptions.containsKey(p2)) continue;
            Subscription s = p2.registerChangeListener(onAnnotationChange);
            subscriptions.put(p2, s);
        }
        this.content.getStyleClass().addAll((Object[])new String[]{CSS_LIST_VIEW});
        this.content.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, e -> ((StyledTextArea)this.getSkinnable()).getContextMenu().show((Node)this.content, e.getScreenX(), e.getScreenY()));
        this.content.focusedProperty().addListener((x, o, n) -> {
            if (n != null && n.booleanValue()) {
                ((StyledTextArea)this.getSkinnable()).requestFocus();
            }
        });
        this.getBehavior().installContentListeners((Region)this.content);
        this.content.contentProperty().bind(((StyledTextArea)this.getSkinnable()).contentProperty());
        this.content.setOnScroll(e -> this.scroller.scrollBy(Math.round(-e.getDeltaY())));
        HBox.setHgrow(this.contentArea, (Priority)Priority.ALWAYS);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.contentArea});
        this.getChildren().addAll((Object[])new Node[]{this.rootContainer});
        this.scroller = new Scroller();
        this.scroller.contentAreaHeightProperty().bind((ObservableValue)this.content.heightProperty());
        this.scroller.lineHeightProperty().bind((ObservableValue)this.content.lineHeightProperty());
        this.content.bindHorizontalScrollbar(this.contentArea.horizontal);
        ((IntegerProperty)((StyledTextArea)this.getSkinnable()).lineCountProperty()).bind((ObservableValue)this.content.numberOfLinesProperty());
        this.scroller.lineCountProperty().bind((ObservableValue)this.content.numberOfLinesProperty());
        this.scroller.bind(this.contentArea.vertical);
        this.content.textSelectionProperty().bind(((StyledTextArea)this.getSkinnable()).selectionProperty());
        this.content.caretOffsetProperty().bind((ObservableValue)((StyledTextArea)this.getSkinnable()).caretOffsetProperty());
        this.content.visibleLinesProperty().bind(this.scroller.visibleLinesProperty());
        this.content.offsetYProperty().bind((ObservableValue)this.scroller.offsetProperty());
        ((StyledTextArea)this.getSkinnable()).getContent().addTextChangeListener(new StyledTextContent.TextChangeListener(){

            @Override
            public void textSet(TextChangedEvent event) {
                StyledTextSkin.this.scroller.refresh();
            }

            @Override
            public void textChanging(TextChangingEvent event) {
            }

            @Override
            public void textChanged(TextChangedEvent event) {
            }
        });
        ObservableList lineRulerPresenters = FXCollections.observableArrayList();
        this.sortedLineRulerPresenters = new SortedList(lineRulerPresenters, (a, b) -> a.getOrder() - b.getOrder());
        Function<LineRulerAnnotationPresenter, LineRuler> map = ap -> {
            Function<Integer, Set<Annotation>> converter = index -> this.lineHelper.getAnnotations((int)index).stream().filter(ap::isApplicable).collect(Collectors.toSet());
            Predicate<Set<Annotation>> needsPresentation = ap::isVisible;
            Supplier<Node> nodeFactory = ap::createNode;
            BiConsumer<Node, Set<Annotation>> populator = ap::updateNode;
            final LineRuler flow = new LineRuler(ap.getLayoutHint(), converter, needsPresentation, nodeFactory, populator);
            flow.visibleLinesProperty().bind(this.scroller.visibleLinesProperty());
            flow.numberOfLinesProperty().bind((ObservableValue)this.content.numberOfLinesProperty());
            flow.lineHeightProperty().bind((ObservableValue)this.content.lineHeightProperty());
            flow.yOffsetProperty().bind((ObservableValue)this.scroller.offsetProperty());
            flow.fixedWidthProperty().bind((ObservableValue)ap.getWidth());
            LineRulerAnnotationPresenter.LineRuler lr = new LineRulerAnnotationPresenter.LineRuler(){

                @Override
                public Subscription subscribeMouseReleased(BiConsumer<Integer, MouseEvent> callback) {
                    EventHandler handler = e -> callback.accept(flow.findLineIndex(new Point2D(e.getX(), e.getY())), (MouseEvent)e);
                    flow.addEventHandler(MouseEvent.MOUSE_RELEASED, handler);
                    return () -> flow.removeEventHandler(MouseEvent.MOUSE_RELEASED, handler);
                }

                @Override
                public Subscription subscribeMousePressed(BiConsumer<Integer, MouseEvent> callback) {
                    EventHandler handler = e -> callback.accept(flow.findLineIndex(new Point2D(e.getX(), e.getY())), (MouseEvent)e);
                    flow.addEventHandler(MouseEvent.MOUSE_PRESSED, handler);
                    return () -> flow.removeEventHandler(MouseEvent.MOUSE_PRESSED, handler);
                }

                @Override
                public Subscription subscribeMouseClicked(BiConsumer<Integer, MouseEvent> callback) {
                    EventHandler handler = e -> callback.accept(flow.findLineIndex(new Point2D(e.getX(), e.getY())), (MouseEvent)e);
                    flow.addEventHandler(MouseEvent.MOUSE_CLICKED, handler);
                    return () -> flow.removeEventHandler(MouseEvent.MOUSE_CLICKED, handler);
                }
            };
            ap.initialize(lr);
            return flow;
        };
        this.sortedLineRulerFlows = FXCollections.observableArrayList();
        this.sortedLineRulerFlows.addListener(c -> {
            for (LineRuler flow : this.sortedLineRulerFlows) {
                flow.getStyleClass().setAll((Object[])new String[]{CSS_CLASS_LINE_RULER});
            }
        });
        FXBindUtil.uniMapBindList(this.sortedLineRulerPresenters, this.sortedLineRulerFlows, map);
        FXBindUtil.uniMapBindList(this.sortedLineRulerFlows, this.lineRulerArea.getChildren(), flow -> flow);
        this.sortedLineRulerFlows.addListener(c -> {
            while (c.next()) {
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(f -> {
                    f.visibleLinesProperty().unbind();
                    f.numberOfLinesProperty().unbind();
                    f.yOffsetProperty().unbind();
                    f.fixedWidthProperty().unbind();
                });
            }
        });
        Consumer<AnnotationPresenter> installPresenter = p -> {
            if (p instanceof LineRulerAnnotationPresenter) {
                LineRulerAnnotationPresenter lrp = (LineRulerAnnotationPresenter)p;
                lineRulerPresenters.add((Object)lrp);
            } else if (p instanceof TextAnnotationPresenter) {
                TextAnnotationPresenter tp = (TextAnnotationPresenter)p;
                this.content.textAnnotationPresenterProperty().add((Object)tp);
            }
        };
        Consumer<AnnotationPresenter> uninstallPresenter = p -> {
            if (p instanceof LineRulerAnnotationPresenter) {
                LineRulerAnnotationPresenter lrp = (LineRulerAnnotationPresenter)p;
                lineRulerPresenters.remove((Object)lrp);
            } else if (p instanceof TextAnnotationPresenter) {
                TextAnnotationPresenter tp = (TextAnnotationPresenter)p;
                this.content.textAnnotationPresenterProperty().remove((Object)tp);
            }
        };
        ((StyledTextArea)this.getSkinnable()).getAnnotationPresenter().addListener(c -> {
            if (c.wasAdded()) {
                installPresenter.accept((AnnotationPresenter)c.getElementAdded());
            }
            if (c.wasRemoved()) {
                uninstallPresenter.accept((AnnotationPresenter)c.getElementRemoved());
            }
            RangeSet r = TreeRangeSet.create().complement();
            this.content.updateAnnotations((RangeSet<Integer>)r);
            this.sortedLineRulerFlows.forEach(f -> f.update((RangeSet<Integer>)r));
            this.rootContainer.requestLayout();
        });
        ((StyledTextArea)this.getSkinnable()).getAnnotationPresenter().forEach(installPresenter);
        Platform.runLater(() -> this.scrollOffsetIntoView(((StyledTextArea)this.getSkinnable()).getCaretOffset(), 10, 12));
    }

    public Optional<TextNode> findTextNode(Point2D screenLocation) {
        Point2D contentLocalLocation = this.content.screenToLocal(screenLocation);
        return this.content.findTextNode(contentLocalLocation);
    }

    private void scrollColumnIntoView(int colIndex, int jumpAhead) {
        double targetOffset;
        double jumpOffset;
        double charWidth = this.content.getCharWidth();
        double colOffset = charWidth * (double)colIndex;
        double contentWidth = this.content.getWidth();
        double curOffset = this.contentArea.horizontal.getValue();
        if (colOffset < curOffset) {
            jumpOffset = curOffset - (double)jumpAhead * charWidth;
            if (colOffset < jumpOffset) {
                jumpOffset = colOffset;
            }
            targetOffset = Math.max(this.contentArea.horizontal.getMin(), jumpOffset);
            this.contentArea.horizontal.setValue(targetOffset);
        }
        if (colOffset > curOffset + contentWidth) {
            jumpOffset = curOffset + (double)jumpAhead * charWidth;
            if (colOffset > jumpOffset + contentWidth) {
                jumpOffset = colOffset + contentWidth;
            }
            targetOffset = Math.min(this.contentArea.horizontal.getMax(), jumpOffset);
            this.contentArea.horizontal.setValue(targetOffset);
        }
    }

    public <T> Optional<T> fastQuery(String label, String fieldText, Function<String, T> converter) {
        TextInputDialog diag = new TextInputDialog();
        diag.setTitle(label);
        diag.setHeaderText(label);
        diag.setContentText(fieldText);
        return diag.showAndWait().map(converter);
    }

    public void scrollLineIntoView(int lineIndex) {
        this.scroller.scrollIntoView(lineIndex);
    }

    public void scrollOffsetIntoView(int offset, int verticalOffset, int horizontalOffset) {
        if (offset >= 0) {
            int lineIdx = ((StyledTextArea)this.getSkinnable()).getContent().getLineAtOffset(offset);
            Range<Integer> visibleLines = this.content.getVisibleLines();
            if (!visibleLines.contains((Comparable)Integer.valueOf(lineIdx))) {
                int linesVisible = (Integer)visibleLines.upperEndpoint();
                int delta = linesVisible - verticalOffset;
                int scrollLine = Math.min(lineIdx + delta, ((StyledTextArea)this.getSkinnable()).getContent().getLineCount() - 1);
                this.scrollLineIntoView(scrollLine);
            }
            int colIdx = offset - ((StyledTextArea)this.getSkinnable()).getContent().getOffsetAtLine(lineIdx);
            String line = ((StyledTextArea)this.getSkinnable()).getContent().getLine(lineIdx).substring(0, colIdx);
            int tabCount = (int)line.chars().filter(c -> c == 9).count();
            this.scrollColumnIntoView(colIdx + tabCount * (((StyledTextArea)this.getSkinnable()).tabAvanceProperty().get() - 1), horizontalOffset);
        } else {
            this.scrollLineIntoView(0);
            this.scrollColumnIntoView(0, 0);
        }
    }

    public StyledTextBehavior getBehavior() {
        return this.behavior;
    }

    public double getLineHeight(int caretPosition) {
        if (((StyledTextArea)this.getSkinnable()).getFixedLineHeight() >= 0.0) {
            return ((StyledTextArea)this.getSkinnable()).getFixedLineHeight();
        }
        return -1.0;
    }

    public Point2D getCaretLocation(int caretPosition, StyledTextArea.LineLocation locationHint) {
        if (caretPosition < 0) {
            return null;
        }
        Optional<Point2D> location = this.content.getLocationInScene(caretPosition, locationHint);
        return location.map(l -> this.rootContainer.sceneToLocal(l)).map(l -> new Point2D(l.getX(), l.getY() + this.content.getLineHeight())).orElse(null);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 100.0;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 60.0;
    }

    public void scrollLineUp() {
        this.scroller.scrollBy(-1);
    }

    public void scrollLineDown() {
        this.scroller.scrollBy(1);
    }

    static String removeLineending(String s) {
        return s.replace("\n", "").replace("\r", "");
    }

    public int getOffsetAtPosition(double x, double y) {
        if (this.content.getBoundsInLocal().getMinY() <= y && this.content.getBoundsInLocal().getMaxY() >= y) {
            return this.content.getLineIndex(new Point2D(x, y)).orElse(((StyledTextArea)this.getSkinnable()).getContent().getCharCount());
        }
        return -1;
    }

    public void refreshStyles(int start, int length) {
        int startLine = ((StyledTextArea)this.getSkinnable()).getContent().getLineAtOffset(start);
        int endLine = ((StyledTextArea)this.getSkinnable()).getContent().getLineAtOffset(start + length);
        TreeRangeSet set = TreeRangeSet.create();
        set.add(Range.closed((Comparable)Integer.valueOf(startLine), (Comparable)Integer.valueOf(endLine)));
        this.content.updatelines((RangeSet<Integer>)set);
    }

    public void updateInsertionMarkerIndex(int offset) {
        this.content.updateInsertionMarkerIndex(offset);
    }

    public int getVisibleLineCount() {
        return this.scroller.visibleLineCountProperty().get();
    }

    public Bounds getContentBounds() {
        return this.content.getLayoutBounds();
    }
}

