/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.compiler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.fx.ide.fxml.compiler.BitOperations;
import org.eclipse.fx.ide.fxml.compiler.ReflectionFX;
import org.eclipse.fx.ide.fxml.compiler.ValueType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ReflectionHelper {
    private static Class<?> EVENT_HANDLER_CLASS = new Functions.Function0<Class<?>>(){

        public Class<?> apply() {
            try {
                Class<?> _forName = Class.forName("javafx.event.EventHandler", false, ReflectionHelper.class.getClassLoader());
                return _forName;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();
    private static Class<?> OBSERVABLELIST_CLASS = new Functions.Function0<Class<?>>(){

        public Class<?> apply() {
            try {
                Class<?> _forName = Class.forName("javafx.collections.ObservableList", false, ReflectionHelper.class.getClassLoader());
                return _forName;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();

    public static boolean isAssignable(JvmTypeReference target, JvmTypeReference source) {
        try {
            Class<?> targetClass = Class.forName(target.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            Class<?> sourceClass = Class.forName(source.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            return targetClass.isAssignableFrom(sourceClass);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean hasNoArgConstructor(JvmTypeReference type) {
        try {
            Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            return !c.isInterface() && !Modifier.isAbstract(c.getModifiers()) && !Objects.equals(c.getConstructor(new Class[0]), null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getEnumType(JvmTypeReference type, String attributeName, boolean layoutConstraint) {
        try {
            Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            String _firstUpper = StringExtensions.toFirstUpper((String)attributeName);
            String methodName = "set" + _firstUpper;
            Functions.Function1 _function = it -> Objects.equals(it.getName(), methodName) && (it.getParameterTypes().length == 1 || layoutConstraint && it.getParameterTypes().length == 2);
            Method m = (Method)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)c.getMethods())), (Functions.Function1)_function);
            Class<?>[] _parameterTypes = null;
            if (m != null) {
                _parameterTypes = m.getParameterTypes();
            }
            Class<?> _get = null;
            if (_parameterTypes != null) {
                int _xifexpression = 0;
                _xifexpression = layoutConstraint ? 1 : 0;
                _get = _parameterTypes[_xifexpression];
            }
            Class<?> t = _get;
            String _xifexpression_1 = null;
            if (!Objects.equals(t, null) && t.isEnum()) {
                String _name = null;
                if (t != null) {
                    _name = t.getName();
                }
                _xifexpression_1 = _name;
            } else {
                _xifexpression_1 = null;
            }
            return _xifexpression_1;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean hasMethod(JvmTypeReference type, String name, Class<?> ... parameters) {
        Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
        try {
            c.getDeclaredMethod(name, parameters);
            return true;
        }
        catch (Throwable _t) {
            block6: {
                try {
                    if (!(_t instanceof NoSuchMethodException)) break block6;
                    return false;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static Field findField(Class<?> c, String name) {
        try {
            NoSuchFieldException initialException = null;
            Class<?> l = c;
            while (!Objects.equals(l, null) && !Objects.equals(l, Object.class)) {
                try {
                    return l.getDeclaredField(name);
                }
                catch (Throwable _t) {
                    if (_t instanceof NoSuchFieldException) {
                        NoSuchFieldException e = (NoSuchFieldException)_t;
                        boolean _equals = Objects.equals(initialException, null);
                        if (_equals) {
                            initialException = e;
                        }
                    } else {
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    l = l.getSuperclass();
                }
            }
            throw initialException;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean hasField(JvmTypeReference type, String refPackage, String name) {
        Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
        try {
            ReflectionHelper.findField(c, name);
            return true;
        }
        catch (Throwable _t) {
            block6: {
                try {
                    if (!(_t instanceof NoSuchFieldException)) break block6;
                    return false;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static boolean hasAccessibleField(JvmTypeReference type, String refPackage, String name) {
        Class<?> c;
        block5: {
            Field field;
            block4: {
                try {
                    c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
                    field = ReflectionHelper.findField(c, name);
                    boolean _bitSet = BitOperations.bitSet(field.getModifiers(), 1);
                    if (!_bitSet) break block4;
                    return true;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            boolean _bitSet_1 = BitOperations.bitSet(field.getModifiers(), 2);
            if (!_bitSet_1) break block5;
            return false;
        }
        String _name = c.getPackage().getName();
        boolean _equals = Objects.equals(_name, refPackage);
        return _equals;
    }

    public static String getFieldOwner(JvmTypeReference type, String name) {
        try {
            Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            return ReflectionHelper.findField(c, name).getDeclaringClass().getName();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean needsBuilder(JvmTypeReference type) {
        try {
            Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            Functions.Function1 _function = it -> {
                int _length = it.getParameterTypes().length;
                return _length == 0;
            };
            Constructor _findFirst = (Constructor)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray(c.getConstructors())), (Functions.Function1)_function);
            return Objects.equals(_findFirst, null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String defaultAttribute(JvmTypeReference type) {
        try {
            return ReflectionFX.defaultAttribute(type);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String eventType(JvmTypeReference type, String name) {
        try {
            Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            String _firstUpper = StringExtensions.toFirstUpper((String)name);
            String _plus = "get" + _firstUpper;
            Method m = c.getMethod(_plus, new Class[0]);
            boolean _equals = m.getReturnType().equals(EVENT_HANDLER_CLASS);
            if (_equals) {
                Type _genericReturnType = m.getGenericReturnType();
                ParameterizedType gt = (ParameterizedType)_genericReturnType;
                Type t = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)gt.getActualTypeArguments())));
                if (t instanceof WildcardType) {
                    WildcardType wt = (WildcardType)t;
                    return ((Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)wt.getLowerBounds())))).getTypeName();
                }
                return t.getTypeName();
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String listType(JvmTypeReference type, String name) {
        try {
            Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            String _firstUpper = StringExtensions.toFirstUpper((String)name);
            String _plus = "get" + _firstUpper;
            Method m = c.getMethod(_plus, new Class[0]);
            boolean _equals = m.getReturnType().equals(OBSERVABLELIST_CLASS);
            if (_equals) {
                Type _genericReturnType = m.getGenericReturnType();
                ParameterizedType gt = (ParameterizedType)_genericReturnType;
                Type t = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)gt.getActualTypeArguments())));
                if (t instanceof WildcardType) {
                    WildcardType wt = (WildcardType)t;
                    return ((Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)wt.getLowerBounds())))).getTypeName();
                }
                return t.getTypeName();
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getFqnType(String simpleName, Map<String, String> imports, List<String> globalImports) {
        boolean _contains = simpleName.contains(".");
        if (_contains) {
            return simpleName;
        }
        String rv = imports.get(simpleName);
        boolean _equals = Objects.equals(rv, null);
        if (_equals) {
            for (String ns : globalImports) {
                try {
                    Class<?> c = Class.forName(ns + "." + simpleName, false, ReflectionHelper.class.getClassLoader());
                    imports.put(c.getSimpleName(), c.getName());
                    return c.getName();
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) continue;
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        return rv;
    }

    public static String getType(JvmType type, String attribute) {
        try {
            Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            Method m = null;
            try {
                String _firstUpper = StringExtensions.toFirstUpper((String)attribute);
                String _plus = "get" + _firstUpper;
                m = c.getMethod(_plus, new Class[0]);
            }
            catch (Throwable _t) {
                if (_t instanceof NoSuchMethodException) {
                    NoSuchMethodException e = (NoSuchMethodException)_t;
                    try {
                        String _firstUpper_1 = StringExtensions.toFirstUpper((String)attribute);
                        String _plus_1 = "is" + _firstUpper_1;
                        m = c.getMethod(_plus_1, new Class[0]);
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof NoSuchMethodException) {
                            throw e;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return m.getReturnType().getName();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static ValueType getValueType(JvmType type, String attribute) {
        try {
            Class<?> c = Class.forName(type.getQualifiedName(), false, ReflectionHelper.class.getClassLoader());
            Method m = null;
            try {
                String _firstUpper = StringExtensions.toFirstUpper((String)attribute);
                String _plus = "get" + _firstUpper;
                m = c.getMethod(_plus, new Class[0]);
            }
            catch (Throwable _t) {
                if (_t instanceof NoSuchMethodException) {
                    NoSuchMethodException e = (NoSuchMethodException)_t;
                    try {
                        String _firstUpper_1 = StringExtensions.toFirstUpper((String)attribute);
                        String _plus_1 = "is" + _firstUpper_1;
                        m = c.getMethod(_plus_1, new Class[0]);
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof NoSuchMethodException) {
                            throw e;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            boolean _isBoolean = ReflectionHelper.isBoolean(m.getReturnType());
            if (_isBoolean) {
                return ValueType.BOOLEAN;
            }
            boolean _isNumeric = ReflectionHelper.isNumeric(m.getReturnType());
            if (_isNumeric) {
                return ValueType.NUMBER;
            }
            Class<?> _returnType = m.getReturnType();
            boolean _equals = Objects.equals(_returnType, String.class);
            if (_equals) {
                return ValueType.STRING;
            }
            boolean _isAssignableFrom = List.class.isAssignableFrom(m.getReturnType());
            if (_isAssignableFrom) {
                return ValueType.LIST;
            }
            boolean _isAssignableFrom_1 = EVENT_HANDLER_CLASS.isAssignableFrom(m.getReturnType());
            if (_isAssignableFrom_1) {
                return ValueType.EVENT_CLASS;
            }
            return ValueType.CLASS;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static ValueType getStaticValueType(JvmType type, String attribute) {
        try {
            Method m = ReflectionFX.getStaticMethod(type, attribute);
            boolean _isBoolean = ReflectionHelper.isBoolean(m.getReturnType());
            if (_isBoolean) {
                return ValueType.BOOLEAN;
            }
            boolean _isNumeric = ReflectionHelper.isNumeric(m.getReturnType());
            if (_isNumeric) {
                return ValueType.NUMBER;
            }
            Class<?> _returnType = m.getReturnType();
            boolean _equals = Objects.equals(_returnType, String.class);
            if (_equals) {
                return ValueType.STRING;
            }
            boolean _isAssignableFrom = List.class.isAssignableFrom(m.getReturnType());
            if (_isAssignableFrom) {
                return ValueType.LIST;
            }
            return ValueType.CLASS;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean isBoolean(Class<?> c) {
        return Objects.equals(c, Boolean.TYPE) || Objects.equals(c, Boolean.class);
    }

    public static boolean isNumeric(Class<?> c) {
        return Objects.equals(c, Double.TYPE) || Objects.equals(c, Integer.TYPE) || Objects.equals(c, Integer.class) || Objects.equals(c, Double.class);
    }
}

