/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.stage;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import org.eclipse.fx.ui.controls.stage.ResizeableWindowPane;
import org.eclipse.fx.ui.controls.stage.TrimmedWindow;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DefaultTrimmedWindowPane
extends ResizeableWindowPane
implements TrimmedWindow {
    private static final PseudoClass ACTIVE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"active");
    private ObjectProperty<@Nullable Node> contentProperty;
    private StringProperty titleProperty;
    private final @NonNull ObjectProperty<@Nullable Node> leftTrim = new SimpleObjectProperty((Object)this, "leftTrim");
    private final @NonNull ObjectProperty<@Nullable Node> rightTrim = new SimpleObjectProperty((Object)this, "rightTrim");
    private final @NonNull ObjectProperty<@Nullable Node> topTrim = new SimpleObjectProperty((Object)this, "topTrim");
    private final @NonNull ObjectProperty<@Nullable Node> bottomTrim = new SimpleObjectProperty((Object)this, "bottomTrim");
    private TitleAreaNode dialogAreaNode;
    private ObjectProperty<Node> menuBar = new SimpleObjectProperty((Object)this, "menuBar", null);
    private ObjectProperty<Node> clientArea = new SimpleObjectProperty((Object)this, "clientArea", null);
    private BorderPane trimPane;

    public DefaultTrimmedWindowPane() {
        this(null);
    }

    public DefaultTrimmedWindowPane(boolean lightweight) {
        this(lightweight, null);
    }

    public DefaultTrimmedWindowPane(@Nullable Pane clientArea) {
        this(false, clientArea);
    }

    public DefaultTrimmedWindowPane(boolean lightweight, @Nullable Pane clientArea) {
        super(lightweight);
        this.menuBarProperty().addListener(this::updateMenuBar);
        this.clientAreaProperty().addListener(this::updateClientArea);
        this.topTrimProperty().addListener(this::updateTopTrim);
        this.bottomTrimProperty().addListener(this::updateBottomTrim);
        this.rightTrimProperty().addListener(this::updateRightTrim);
        this.leftTrimProperty().addListener(this::updateLeftTrim);
        if (clientArea != null) {
            clientArea.setId("client-area");
            this.setContent((Node)clientArea);
        }
    }

    @Override
    protected Node createWindowArea() {
        BorderPane root = new BorderPane();
        this.getStyleClass().addAll((Object[])new String[]{"default-window", "decorated-root"});
        Object dialogTitleBar = this.createTitleBar();
        this.dialogAreaNode = (TitleAreaNode)dialogTitleBar;
        this.registerTitleBar((Node)dialogTitleBar);
        this.titleProperty = ((TitleAreaNode)dialogTitleBar).titleProperty();
        root.setTop(dialogTitleBar);
        dialogTitleBar.applyCss();
        this.sceneProperty().addListener(o -> {
            Scene s = this.getScene();
            if (s != null) {
                if (s.getWindow() != null) {
                    this.handleStageAttached();
                } else {
                    s.windowProperty().addListener(o2 -> {
                        if (s.getWindow() != null) {
                            this.handleStageAttached();
                        }
                    });
                }
            }
        });
        this.trimPane = new BorderPane();
        root.setCenter((Node)this.trimPane);
        this.contentProperty = this.trimPane.centerProperty();
        return root;
    }

    private void handleStageAttached() {
        this.handleFocus(this.getStage().focusedProperty());
        if (this.getStage().getModality() == Modality.WINDOW_MODAL) {
            this.dialogAreaNode.getMinButton().setVisible(false);
        }
    }

    @Override
    public void setBottomTrim(@Nullable Node node) {
        this.bottomTrimProperty().set((Object)node);
    }

    public @NonNull ObjectProperty<@Nullable Node> bottomTrimProperty() {
        return this.bottomTrim;
    }

    public @Nullable Node getBottomTrim() {
        return (Node)this.bottomTrimProperty().get();
    }

    @Override
    public void setLeftTrim(@Nullable Node node) {
        this.leftTrimProperty().set((Object)node);
    }

    public @NonNull ObjectProperty<@Nullable Node> leftTrimProperty() {
        return this.leftTrim;
    }

    public @Nullable Node getLeftTrim() {
        return (Node)this.leftTrimProperty().get();
    }

    @Override
    public void setRightTrim(@Nullable Node node) {
        this.rightTrimProperty().set((Object)node);
    }

    public @NonNull ObjectProperty<@Nullable Node> rightTrimProperty() {
        return this.rightTrim;
    }

    public @Nullable Node getRightTrim() {
        return (Node)this.rightTrimProperty().get();
    }

    @Override
    public void setTopTrim(@Nullable Node node) {
        this.topTrimProperty().set((Object)node);
    }

    public @NonNull ObjectProperty<@Nullable Node> topTrimProperty() {
        return this.topTrim;
    }

    public @Nullable Node getTopTrim() {
        return (Node)this.topTrimProperty().get();
    }

    private void updateTopTrim(ObservableValue<? extends Node> o, Node oldValue, Node newValue) {
        Pane pane;
        if (oldValue != null) {
            pane = (Pane)this.lookup("#top-trim-area");
            if (pane == null) {
                this.trimPane.setTop(null);
            } else {
                pane.getChildren().remove((Object)oldValue);
            }
        }
        if (newValue != null) {
            pane = (Pane)this.lookup("#top-trim-area");
            if (pane == null) {
                this.trimPane.setTop(newValue);
            } else {
                pane.getChildren().add((Object)newValue);
            }
        }
    }

    private void updateBottomTrim(ObservableValue<? extends Node> o, Node oldValue, Node newValue) {
        Pane pane;
        if (oldValue != null) {
            pane = (Pane)this.lookup("#bottom-trim-area");
            if (pane == null) {
                this.trimPane.setBottom(null);
            } else {
                pane.getChildren().remove((Object)newValue);
            }
        }
        if (newValue != null) {
            pane = (Pane)this.lookup("#bottom-trim-area");
            if (pane == null) {
                this.trimPane.setBottom(newValue);
            } else {
                pane.getChildren().add((Object)newValue);
            }
        }
    }

    private void updateLeftTrim(ObservableValue<? extends Node> o, Node oldValue, Node newValue) {
        Pane pane;
        if (oldValue != null) {
            pane = (Pane)this.lookup("#left-trim-area");
            if (pane == null) {
                this.trimPane.setLeft(null);
            } else {
                pane.getChildren().remove((Object)oldValue);
            }
        }
        if (newValue != null) {
            pane = (Pane)this.lookup("#left-trim-area");
            if (pane == null) {
                this.trimPane.setLeft(newValue);
            } else {
                pane.getChildren().add((Object)newValue);
            }
        }
    }

    private void updateRightTrim(ObservableValue<? extends Node> o, Node oldValue, Node newValue) {
        Pane pane;
        if (oldValue != null) {
            pane = (Pane)this.lookup("#right-trim-area");
            if (pane == null) {
                this.trimPane.setRight(null);
            } else {
                pane.getChildren().remove((Object)oldValue);
            }
        }
        if (newValue != null) {
            pane = (Pane)this.lookup("#right-trim-area");
            if (pane == null) {
                this.trimPane.setRight(newValue);
            } else {
                pane.getChildren().add((Object)newValue);
            }
        }
    }

    protected <N extends Node> N createTitleBar() {
        return (N)new TitleAreaNodeImpl();
    }

    protected void requestCancelClose() {
        this.close(true);
    }

    private void handleFocus(ReadOnlyBooleanProperty readOnlyBooleanProperty) {
        readOnlyBooleanProperty.addListener(o -> this.pseudoClassStateChanged(ACTIVE_PSEUDO_CLASS, readOnlyBooleanProperty.get()));
    }

    @Override
    protected StringProperty impl_titleProperty() {
        return this.titleProperty;
    }

    @Override
    protected ObjectProperty<Node> impl_menuBarProperty() {
        return this.menuBar;
    }

    private void updateMenuBar(ObservableValue<? extends Node> o, Node oldMenuBar, Node newMenuBar) {
        if (oldMenuBar != null) {
            ((Pane)this.lookup("#menu-bar-area")).getChildren().remove((Object)oldMenuBar);
            oldMenuBar.getStyleClass().remove((Object)"window-menubar");
        }
        if (newMenuBar != null) {
            ((Pane)this.lookup("#menu-bar-area")).getChildren().add(0, (Object)newMenuBar);
            newMenuBar.getStyleClass().add((Object)"window-menubar");
            HBox.setHgrow((Node)newMenuBar, (Priority)Priority.ALWAYS);
        }
    }

    @Override
    protected ObjectProperty<Node> impl_clientAreaProperty() {
        return this.clientArea;
    }

    private void updateClientArea(ObservableValue<? extends Node> o, Node oldClientArea, Node newClientArea) {
        if (oldClientArea != null) {
            ((Pane)this.lookup("#client-area")).getChildren().remove((Object)oldClientArea);
        }
        if (newClientArea != null) {
            ((Pane)this.lookup("#client-area")).getChildren().add((Object)newClientArea);
        }
    }

    @Override
    public ObjectProperty<Node> impl_contentProperty() {
        return this.contentProperty;
    }

    public String getUserAgentStylesheet() {
        return DefaultTrimmedWindowPane.class.getResource("window.css").toExternalForm();
    }

    public static interface TitleAreaNode {
        public StringProperty titleProperty();

        public Node getMinButton();
    }

    class TitleAreaNodeImpl
    extends HBox
    implements TitleAreaNode {
        private static final int HEADER_HEIGHT = 28;
        private Label titleLabel;
        private WindowButton minButton;

        public TitleAreaNodeImpl() {
            this.getStyleClass().add((Object)"window-header");
            this.setPrefHeight(28.0);
            this.setMinHeight(28.0);
            this.setMaxHeight(28.0);
            this.titleLabel = new Label();
            this.titleLabel.setMaxHeight(Double.MAX_VALUE);
            this.titleLabel.setId("window-label-title");
            this.titleLabel.getStyleClass().add((Object)"window-title");
            Region spacer = new Region();
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            WindowButton closeButton = new WindowButton("close");
            closeButton.setFocusTraversable(false);
            closeButton.setOnAction(e -> DefaultTrimmedWindowPane.this.requestCancelClose());
            this.minButton = new WindowButton("minimize");
            this.minButton.setFocusTraversable(false);
            this.minButton.setOnAction(e -> DefaultTrimmedWindowPane.this.minimize());
            WindowButton maxButton = new WindowButton("maximize");
            maxButton.setFocusTraversable(false);
            maxButton.setOnAction(e -> DefaultTrimmedWindowPane.this.maximize());
            HBox windowBtns = new HBox();
            windowBtns.getStyleClass().add((Object)"window-buttons");
            windowBtns.getChildren().addAll((Object[])new Node[]{this.minButton, maxButton, closeButton});
            this.getChildren().addAll((Object[])new Node[]{this.titleLabel, spacer, windowBtns});
        }

        @Override
        public StringProperty titleProperty() {
            return this.titleLabel.textProperty();
        }

        @Override
        public Node getMinButton() {
            return this.minButton;
        }
    }

    private static class WindowButton
    extends Button {
        WindowButton(String name) {
            this.getStyleClass().setAll((Object[])new String[]{"window-button"});
            this.getStyleClass().add((Object)("window-" + name + "-button"));
            StackPane graphic = new StackPane();
            graphic.getStyleClass().setAll((Object[])new String[]{"graphic"});
            this.setGraphic((Node)graphic);
            this.setMinSize(17.0, 17.0);
            this.setPrefSize(17.0, 17.0);
        }
    }
}

