/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.text.TextEditAction;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;

public class TriggerActionMapping {
    private Map<Trigger, TextEditAction> mapping = new HashMap<Trigger, TextEditAction>();
    private ObjectProperty<TriggerActionMapping> overrideProperty = new SimpleObjectProperty((Object)this, "override");
    protected List<BiFunction<TextEditAction, Context, Boolean>> eventHandler = new ArrayList<BiFunction<TextEditAction, Context, Boolean>>();

    public ObjectProperty<TriggerActionMapping> overrideProperty() {
        return this.overrideProperty;
    }

    public void setOverride(TriggerActionMapping override) {
        this.overrideProperty.set((Object)override);
    }

    public void map(String keyCombo, TextEditAction action) {
        this.mapping.put(new KeyCombinationTrigger(keyCombo), action);
    }

    public void map(char typedChar, TextEditAction action) {
        this.mapping.put(new TypedCharTrigger(typedChar), action);
    }

    public void mapConditional(String conditionId, Supplier<Boolean> condition, String keyCombo, TextEditAction action) {
        this.mapping.put(new KeyCombinationTrigger(conditionId, condition, keyCombo), action);
    }

    public void mapConditional(String conditionId, Supplier<Boolean> condition, char typedChar, TextEditAction action) {
        this.mapping.put(new TypedCharTrigger(conditionId, condition, typedChar), action);
    }

    private Stream<Trigger> applicableTriggers() {
        return this.mapping.keySet().stream().filter(x -> x.condition.get());
    }

    private Optional<KeyCombinationTrigger> findTrigger(KeyCombination combo) {
        return this.applicableTriggers().filter(t -> t instanceof KeyCombinationTrigger).map(t -> (KeyCombinationTrigger)t).filter(t -> t.keyCombo.equals((Object)combo)).findFirst();
    }

    private Optional<KeyCombinationTrigger> findTrigger(KeyEvent event) {
        return this.applicableTriggers().filter(t -> t instanceof KeyCombinationTrigger).map(t -> (KeyCombinationTrigger)t).filter(t -> t.keyCombo.match(event)).findFirst();
    }

    private Optional<TypedCharTrigger> findTrigger(char typedChar) {
        return this.applicableTriggers().filter(t -> t instanceof TypedCharTrigger).map(t -> (TypedCharTrigger)t).filter(t -> t.character == typedChar).findFirst();
    }

    public Optional<TextEditAction> get(KeyCombination combo) {
        Optional<TextEditAction> overridden;
        if (this.overrideProperty.get() != null && (overridden = ((TriggerActionMapping)this.overrideProperty.get()).get(combo)).isPresent()) {
            return overridden;
        }
        return this.findTrigger(combo).map(t -> this.mapping.get(t));
    }

    public Optional<TextEditAction> get(KeyEvent event) {
        Optional<TextEditAction> overridden;
        if (this.overrideProperty.get() != null && (overridden = ((TriggerActionMapping)this.overrideProperty.get()).get(event)).isPresent()) {
            return overridden;
        }
        return this.findTrigger(event).map(t -> this.mapping.get(t));
    }

    public Optional<TextEditAction> get(char typedChar) {
        Optional<TextEditAction> overridden;
        if (this.overrideProperty.get() != null && (overridden = ((TriggerActionMapping)this.overrideProperty.get()).get(typedChar)).isPresent()) {
            return overridden;
        }
        return this.findTrigger(typedChar).map(t -> this.mapping.get(t));
    }

    public boolean triggerAction(KeyCombination combo, Context context) {
        Optional<TextEditAction> optional = this.get(combo);
        return optional.map(a -> this.handle((TextEditAction)a, context)).orElse(false);
    }

    public boolean triggerAction(KeyEvent event, Context context) {
        Optional<TextEditAction> optional = this.get(event);
        return optional.map(a -> this.handle((TextEditAction)a, context)).orElse(false);
    }

    public boolean exists(KeyEvent event) {
        return this.get(event).isPresent();
    }

    public boolean exists(char c) {
        return this.get(c).isPresent();
    }

    public boolean triggerAction(char typedChar, Context context) {
        Optional<TextEditAction> optional = this.get(typedChar);
        return optional.map(a -> this.handle((TextEditAction)a, context)).orElse(false);
    }

    public boolean triggerAction(TextEditAction action, Context context) {
        return this.handle(action, context);
    }

    public Subscription subscribe(final BiFunction<TextEditAction, Context, Boolean> handler) {
        this.eventHandler.add(handler);
        return new Subscription(){

            public void dispose() {
                TriggerActionMapping.this.eventHandler.remove(handler);
            }
        };
    }

    private boolean handleInternal(TextEditAction action, Context context) {
        for (BiFunction<TextEditAction, Context, Boolean> handler : this.eventHandler) {
            boolean consumed = handler.apply(action, context);
            if (!consumed) continue;
            return true;
        }
        return false;
    }

    private boolean handle(TextEditAction action, Context context) {
        boolean result;
        if (this.overrideProperty.get() != null && (result = ((TriggerActionMapping)this.overrideProperty.get()).handle(action, context))) {
            return true;
        }
        return this.handleInternal(action, context);
    }

    public static class Context {
        public final StyledTextArea control;

        public Context(StyledTextArea control) {
            this.control = control;
        }
    }

    private static class KeyCombinationTrigger
    extends Trigger {
        public final KeyCombination keyCombo;

        public KeyCombinationTrigger(String keyCombo) {
            this.keyCombo = KeyCombination.keyCombination((String)keyCombo);
        }

        public KeyCombinationTrigger(String conditionId, Supplier<Boolean> condition, String keyCombo) {
            super(conditionId, condition);
            this.keyCombo = KeyCombination.keyCombination((String)keyCombo);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.keyCombo == null ? 0 : this.keyCombo.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyCombinationTrigger other = (KeyCombinationTrigger)obj;
            return !(this.keyCombo == null ? other.keyCombo != null : !this.keyCombo.equals((Object)other.keyCombo));
        }

        public String toString() {
            return "Combo(" + this.keyCombo + ")" + (this.conditionId != null ? "@" + this.conditionId : "");
        }
    }

    private static class Trigger {
        public final String conditionId;
        public final Supplier<Boolean> condition;

        public Trigger() {
            this.conditionId = null;
            this.condition = () -> true;
        }

        public Trigger(String conditionId, Supplier<Boolean> condition) {
            this.conditionId = conditionId;
            this.condition = condition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Trigger other = (Trigger)obj;
            return !(this.condition == null ? other.condition != null : !this.condition.equals(other.condition));
        }
    }

    private static class TypedCharTrigger
    extends Trigger {
        public final char character;

        public TypedCharTrigger(char character) {
            this.character = character;
        }

        public TypedCharTrigger(String conditionId, Supplier<Boolean> condition, char character) {
            super(conditionId, condition);
            this.character = character;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.character;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypedCharTrigger other = (TypedCharTrigger)obj;
            return this.character == other.character;
        }

        public String toString() {
            return "TypedChar(" + this.character + ")" + (this.conditionId != null ? "@" + this.conditionId : "");
        }
    }
}

