/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.fx.core.ObjectSerializer;
import org.osgi.service.component.annotations.Component;

@Component
public class JAXBObjectSerializer
implements ObjectSerializer {
    @Override
    public String getId() {
        return "jaxb";
    }

    @Override
    public String serialize(Object object) {
        return JAXBObjectSerializer.runWithThreadContextCL(() -> {
            ListWrapper obj = object;
            if (obj instanceof List) {
                obj = new ListWrapper((List)((Object)obj));
            } else if (obj instanceof Set) {
                obj = new SetWrapper((Set)((Object)obj));
            }
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (StringWriter w = new StringWriter();){
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
                    Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                    jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                    jaxbMarshaller.marshal((Object)obj, (Writer)w);
                    return w.toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public <O> String serializeCollection(Collection<O> data, Class<O> contentType) {
        return JAXBObjectSerializer.runWithThreadContextCL(() -> {
            Object object;
            if (data instanceof List) {
                object = new ListWrapper((List)data);
            } else if (data instanceof Set) {
                object = new SetWrapper((Set)data);
            } else {
                throw new IllegalArgumentException("Unsupported collection type");
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (StringWriter w = new StringWriter();){
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass(), contentType});
                    Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                    jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                    jaxbMarshaller.marshal(object, (Writer)w);
                    return w.toString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public <O> O deserialize(Class<O> clazz, String value) {
        return (O)JAXBObjectSerializer.runWithThreadContextCL(() -> {
            Class cl = clazz;
            if (cl == List.class) {
                cl = ListWrapper.class;
            } else if (cl == Set.class) {
                cl = SetWrapper.class;
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (StringReader r = new StringReader(value);){
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{cl});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    Object unmarshal = jaxbUnmarshaller.unmarshal((Reader)r);
                    if (unmarshal instanceof ListWrapper) {
                        return ((ListWrapper)unmarshal).list;
                    }
                    if (unmarshal instanceof SetWrapper) {
                        return ((SetWrapper)unmarshal).list;
                    }
                    return unmarshal;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public <O, T extends Collection<O>> T deserializeCollection(Class<T> type, Class<O> contentType, String value) {
        return (T)JAXBObjectSerializer.runWithThreadContextCL(() -> {
            Class clazz3;
            if (type == List.class) {
                clazz3 = ListWrapper.class;
            } else if (type == Set.class) {
                clazz3 = SetWrapper.class;
            } else {
                throw new IllegalArgumentException("Unsupported collection type");
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (StringReader r = new StringReader(value);){
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz3, contentType});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    Object unmarshal = jaxbUnmarshaller.unmarshal((Reader)r);
                    if (unmarshal instanceof ListWrapper) {
                        return ((ListWrapper)unmarshal).list;
                    }
                    if (unmarshal instanceof SetWrapper) {
                        return ((SetWrapper)unmarshal).list;
                    }
                    throw new IllegalStateException("Unsupported type");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    private static <T> T runWithThreadContextCL(Supplier<T> code) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JAXBObjectSerializer.class.getClassLoader());
            T t = code.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    @XmlRootElement
    public static class ListWrapper<O> {
        List<O> list = new ArrayList<O>();

        public ListWrapper() {
        }

        public ListWrapper(List<O> list) {
            this.list = list;
        }

        public List<O> getList() {
            return this.list;
        }

        public void setList(List<O> list) {
            this.list = list;
        }
    }

    @XmlRootElement
    public static class SetWrapper<O> {
        Set<O> list = new HashSet<O>();

        public SetWrapper() {
        }

        public SetWrapper(Set<O> list) {
            this.list = list;
        }

        public Set<O> getSet() {
            return this.list;
        }

        public void setSet(Set<O> list) {
            this.list = list;
        }
    }
}

