/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.fcore.NamedModelElement;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.Activator;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.PatternPreferences;
import org.eclipse.egf.pattern.collector.PatternCollector;
import org.eclipse.egf.pattern.collector.PatternElementCollector;
import org.eclipse.egf.pattern.collector.PatternLibraryCollector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternHelper {
    private final ResourceSet resourceSet;
    public static final PatternHelper TRANSACTIONNAL_COLLECTOR = new PatternHelper(TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID));

    public static String getFullLibraryName(Pattern pattern) {
        ArrayList<PatternLibrary> libs = new ArrayList<PatternLibrary>();
        PatternLibrary lib = pattern.getContainer();
        while (lib != null) {
            libs.add(lib);
            lib = lib.getContainer();
        }
        if (libs.isEmpty()) {
            return "";
        }
        if (libs.size() == 1) {
            return ((PatternLibrary)libs.get(0)).getName();
        }
        StringBuffer buf = new StringBuffer();
        for (PatternLibrary mylib : libs) {
            buf.append(mylib.getName()).append('.');
        }
        return buf.deleteCharAt(buf.length() - 1).toString();
    }

    public static IPlatformFcore getPlatformFcore(PatternElement pattern) {
        return EGFCorePlugin.getPlatformFcore((Resource)pattern.eResource());
    }

    public static String getFactoryConponentName(PatternElement element) {
        PatternLibrary container = element.getContainer();
        while (container.getContainer() != null) {
            container = container.getContainer();
        }
        Viewpoint vp = (Viewpoint)container.eContainer();
        ViewpointContainer vpc = vp.getViewpointContainer();
        return vpc.getFactoryComponent().getName();
    }

    public static IProject getProject(Pattern pattern) {
        IPlatformFcore fcore = PatternHelper.getPlatformFcore((PatternElement)pattern);
        return fcore.getPlatformBundle().getProject();
    }

    public Pattern getPattern(String id) {
        for (Pattern p : this.getAllPatterns()) {
            if (!p.getID().equals(id)) continue;
            return p;
        }
        return null;
    }

    public Set<Pattern> getPatterns(URI uri) {
        HashSet<Pattern> result = new HashSet<Pattern>();
        this.collectPatterns(uri, PatternCollector.EMPTY_ID_SET, result);
        return result;
    }

    public Map<String, PatternElement> getPatternElements(Set<String> ids) {
        IPlatformFcore[] platformFcores;
        HashSet result = new HashSet(200);
        IPlatformFcore[] iPlatformFcoreArray = platformFcores = EGFCorePlugin.getPlatformFcores();
        int n = platformFcores.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore platformFcore = iPlatformFcoreArray[n2];
            URI uri = platformFcore.getURI();
            try {
                Resource res = this.resourceSet.getResource(uri, true);
                PatternElementCollector.INSTANCE.collect((List<EObject>)res.getContents(), result, ids);
            }
            catch (Exception e) {
                Activator.getDefault().logError(Messages.bind((String)Messages.collect_error2, (Object)uri.toString()), e);
            }
            ++n2;
        }
        HashMap<String, PatternElement> map = new HashMap<String, PatternElement>(200);
        for (PatternElement pe : result) {
            map.put(pe.getID(), pe);
        }
        return map;
    }

    public Set<Pattern> getPatterns(IProject project, Set<String> ids) {
        IPlatformFcore[] platformFcores;
        if (ids == null) {
            ids = new HashSet<String>();
        }
        HashSet<Pattern> result = new HashSet<Pattern>();
        IPlatformFcore[] iPlatformFcoreArray = platformFcores = EGFCorePlugin.getPlatformFcores((IProject)project);
        int n = platformFcores.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore platformFcore = iPlatformFcoreArray[n2];
            this.collectPatterns(platformFcore.getURI(), ids, result);
            ++n2;
        }
        return result;
    }

    public Set<Pattern> getAllPatterns() {
        IPlatformFcore[] platformFcores;
        HashSet<Pattern> result = new HashSet<Pattern>(200);
        IPlatformFcore[] iPlatformFcoreArray = platformFcores = EGFCorePlugin.getPlatformFcores();
        int n = platformFcores.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore platformFcore = iPlatformFcoreArray[n2];
            URI uri = platformFcore.getURI();
            try {
                this.collectPatterns(uri, PatternCollector.EMPTY_ID_SET, result);
            }
            catch (Exception e) {
                Activator.getDefault().logError(Messages.bind((String)Messages.collect_error1, (Object)uri.toString()), e);
            }
            ++n2;
        }
        return result;
    }

    public Set<PatternLibrary> getAllLibraries() {
        IPlatformFcore[] platformFcores;
        HashSet<PatternLibrary> result = new HashSet<PatternLibrary>(200);
        IPlatformFcore[] iPlatformFcoreArray = platformFcores = EGFCorePlugin.getPlatformFcores();
        int n = platformFcores.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore platformFcore = iPlatformFcoreArray[n2];
            URI uri = platformFcore.getURI();
            try {
                Resource res = this.resourceSet.getResource(uri, true);
                PatternLibraryCollector.INSTANCE.collect((List<EObject>)res.getContents(), result, (Set<String>)PatternCollector.EMPTY_ID_SET);
            }
            catch (Exception e) {
                Activator.getDefault().logError(Messages.bind((String)Messages.collect_error2, (Object)uri.toString()), e);
            }
            ++n2;
        }
        return result;
    }

    private void collectPatterns(URI uri, Set<String> ids, Set<Pattern> collector) {
        Resource res = this.resourceSet.getResource(uri, true);
        PatternCollector.INSTANCE.collect((List<EObject>)res.getContents(), collector, ids);
    }

    public static String generateID() {
        return EcoreUtil.generateUUID().replaceAll("\\W", "");
    }

    public static String dropNonWordCharacter(String value) {
        return value.replaceAll("\\W", "");
    }

    public static String uniqueName(NamedModelElement parameter) {
        return String.valueOf(parameter.getName().replaceAll("\\W", "")) + "_" + parameter.getID().replaceAll("\\W", "");
    }

    public static String localizeName(PatternParameter parameter) {
        return String.valueOf(parameter.getName()) + "Parameter";
    }

    public static List<PatternMethod> getUserMethds(Pattern pattern) {
        ArrayList<PatternMethod> result = new ArrayList<PatternMethod>();
        for (PatternMethod m : pattern.getMethods()) {
            String name = m.getName();
            if (name.equals("init") || name.equals("header") || name.equals("footer") || name.equals("preCondition")) continue;
            result.add(m);
        }
        return result;
    }

    public void clear() {
        for (Resource res : this.resourceSet.getResources()) {
            res.unload();
        }
        this.resourceSet.getResources().clear();
    }

    private PatternHelper(TransactionalEditingDomain domain) {
        this(domain.getResourceSet());
    }

    private PatternHelper(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public static final PatternHelper createCollector() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.getURIConverter().getURIMap().clear();
        set.getURIConverter().getURIMap().putAll(EGFCorePlugin.computePlatformURIMap());
        return new PatternHelper((ResourceSet)set);
    }

    public static class Filename {
        private static final String PATTERN_TOKEN = "pattern.";
        private static final String METHOD_TOKEN = "method.";

        public static URI computeFileURI(PatternMethod method) {
            return URI.createFileURI((String)(String.valueOf(PatternPreferences.getTemplatesFolderName()) + '/' + PATTERN_TOKEN + method.getPattern().getID() + '/' + METHOD_TOKEN + method.getID() + '.' + "pt"));
        }

        public static String extractPatternId(IPath patternMethodPath) throws FilenameFormatException {
            if (patternMethodPath == null) {
                throw new FilenameFormatException(Messages.PatternFilename_error1);
            }
            int segmentCount = patternMethodPath.segmentCount();
            if (segmentCount < 3) {
                throw new FilenameFormatException(Messages.bind((String)Messages.PatternFilename_error2, (Object)patternMethodPath));
            }
            String segment = patternMethodPath.segment(segmentCount - 2);
            if (segment == null || "".equals(segment) || !segment.startsWith(PATTERN_TOKEN) || PATTERN_TOKEN.length() == segment.length()) {
                throw new FilenameFormatException(Messages.bind((String)Messages.PatternFilename_error3, (Object)segment, (Object)PATTERN_TOKEN));
            }
            return segment.substring(PATTERN_TOKEN.length());
        }

        private Filename() {
        }
    }

    public static class FilenameFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private FilenameFormatException(String message) {
            super(message);
        }
    }
}

