/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ftask.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.eclipse.egf.pattern.execution.ConsoleReporter;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.ftask.Messages;
import org.eclipse.egf.pattern.ftask.tasks.AbstractPatternTask;
import org.eclipse.egf.pattern.strategy.Strategy;

public abstract class AbstractStrategyTask
extends AbstractPatternTask {
    private final Strategy strategy;
    protected Object parameter;
    protected final List<PatternElement> patterns = new ArrayList<PatternElement>();

    protected AbstractStrategyTask(Strategy strategy) {
        this.strategy = strategy;
    }

    protected void readContext(ITaskProductionContext context, PatternContext ctx) throws InvocationException {
        super.readContext(context, ctx);
        PatternExecutionReporter reporter = (PatternExecutionReporter)ctx.getValue("pattern.execution.reporter");
        if (reporter == null) {
            reporter = new ConsoleReporter();
        }
        ctx.setValue("pattern.execution.reporter", (Object)reporter);
    }

    public void preExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        String ids = (String)context.getInputValue((Object)"pattern.ids", String.class);
        String[] idArray = ids.split(", ");
        HashSet<String> idSet = new HashSet<String>();
        idSet.addAll(Arrays.asList(idArray));
        Map patternElements = this.helper.getPatternElements(idSet);
        String[] stringArray = idArray;
        int n = idArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            PatternElement pe = (PatternElement)patternElements.get(id);
            if (pe != null) {
                this.patterns.add(pe);
            }
            ++n2;
        }
    }

    public final void doExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        if (this.parameter == null) {
            throw new InvocationException(Messages.taskInvocation_error1);
        }
        if (this.patterns.isEmpty()) {
            throw new InvocationException(Messages.taskInvocation_error3);
        }
        try {
            PatternContext ctx = this.createPatternContext(context);
            this.readContext(context, ctx);
            this.strategy.setPatternElements(this.patterns);
            this.strategy.execute(ctx, this.parameter);
            this.writeContext(context, ctx);
        }
        catch (ExtensionHelper.MissingExtensionException e) {
            throw new InvocationException((Throwable)e);
        }
        catch (PatternException e) {
            throw new InvocationException((Throwable)e);
        }
    }

    public void postExecute(ITaskProductionContext context, IProgressMonitor monitor) throws InvocationException {
        super.postExecute(context, monitor);
        this.parameter = null;
    }
}

