/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.graph;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.eclipse.elk.alg.disco.graph.DCDirection;
import org.eclipse.elk.alg.disco.graph.DCElement;
import org.eclipse.elk.alg.disco.graph.DCExtension;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;

public class DCComponent {
    private KVector offset = new KVector(0.0, 0.0);
    private Set<DCElement> shapes = Sets.newHashSet();
    private boolean changed = true;
    private KVector bounds;
    private KVector minCornerOfBoundingRectangle;
    private int id = -1;

    DCComponent() {
    }

    public void setOffset(KVector offset) {
        this.changed = true;
        this.offset = offset;
    }

    public KVector getOffset() {
        return this.offset;
    }

    public Set<DCElement> getElements() {
        return this.shapes;
    }

    public KVector getDimensionsOfBoundingRectangle() {
        if (this.changed) {
            this.update();
        }
        return this.bounds;
    }

    public KVector getMinCorner() {
        if (this.changed) {
            this.update();
        }
        return this.minCornerOfBoundingRectangle;
    }

    public boolean intersects(ElkRectangle rect) {
        for (DCElement elem : this.shapes) {
            if (!elem.intersects(rect)) continue;
            return true;
        }
        return false;
    }

    void addElement(DCElement element) {
        this.changed = true;
        this.shapes.add(element);
        element.setComponent(this);
    }

    <C extends Collection<DCElement>> void addElements(C elements) {
        for (DCElement elem : elements) {
            this.addElement(elem);
        }
    }

    private void update() {
        this.changed = false;
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (DCElement elem : this.shapes) {
            ElkRectangle elemBounds = elem.getBounds();
            minX = Math.min(minX, elemBounds.x);
            maxX = Math.max(maxX, elemBounds.x + elemBounds.width);
            minY = Math.min(minY, elemBounds.y);
            maxY = Math.max(maxY, elemBounds.y + elemBounds.height);
            for (DCExtension ext : elem.getExtensions()) {
                double maxPos;
                double minPos;
                DCDirection dir = ext.getDirection();
                if (dir.isHorizontal()) {
                    minPos = elemBounds.y + ext.getOffset().y;
                    maxPos = minPos + ext.getWidth();
                    minY = Math.min(minY, minPos);
                    maxY = Math.max(maxY, maxPos);
                    continue;
                }
                minPos = elemBounds.x + ext.getOffset().x;
                maxPos = minPos + ext.getWidth();
                minX = Math.min(minX, minPos);
                maxX = Math.max(maxX, maxPos);
            }
        }
        this.bounds = new KVector(maxX - minX, maxY - minY);
        this.minCornerOfBoundingRectangle = new KVector(minX + this.offset.x, minY + this.offset.y);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

