/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.redsquiggles;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.emfatic.core.lang.gen.ast.CompUnit;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EmfaticASTNode;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EmfaticASTNodeVisitor;
import org.eclipse.emf.emfatic.core.lang.gen.ast.MapEntryDecl;
import org.eclipse.emf.emfatic.core.lang.gen.ast.TopLevelDecl;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditor;
import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.ui.views.parsetree.IParseTreeChangedListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EmfaticCSTChangeListener
implements IParseTreeChangedListener {
    EmfaticEditor _editor;
    public static QualifiedName qnCST = new QualifiedName("de.tuhh.sts.emfatic", "cst");
    public static QualifiedName qnAST = new QualifiedName("de.tuhh.sts.emfatic", "ast");
    private List<Position> fPositions = new ArrayList<Position>();

    public EmfaticCSTChangeListener(EmfaticEditor editor) {
        this._editor = editor;
    }

    public void parseTreeChanged(ASTNode[] arg0) {
        IFile emfFile = this._editor.getFile();
        CompUnit compUnit = (CompUnit)this._editor.getParseRoot();
        try {
            if (emfFile != null) {
                emfFile.setSessionProperty(qnCST, (Object)compUnit);
                emfFile.setSessionProperty(qnAST, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (compUnit != null) {
            EPackage rootPackage = compUnit.getAST();
            try {
                emfFile.setSessionProperty(qnAST, (Object)rootPackage);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.updateFolding();
    }

    private void updateFolding() {
        this.fPositions = new ArrayList<Position>();
        CompUnit compUnit = (CompUnit)this._editor.getParseRoot();
        if (compUnit == null) {
            return;
        }
        new EmfaticASTNodeVisitor(){

            public boolean beginVisit(TopLevelDecl tld) {
                int length;
                int offset;
                if (!(tld instanceof MapEntryDecl) && EmfaticCSTChangeListener.this.spansSeveralLines(offset = tld.getRangeStart(), length = tld.getRangeLength())) {
                    EmfaticCSTChangeListener.this.fPositions.add(new Position(offset, length));
                }
                return true;
            }
        }.visit((EmfaticASTNode)compUnit.getTopLevelDecls());
        this._editor.updateFoldingStructure(this.fPositions);
    }

    private boolean spansSeveralLines(int offset, int length) {
        IDocumentProvider dp = this._editor.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)this._editor.getEditorInput());
        if (doc != null) {
            try {
                String[] lines = doc.get(offset, length).split("\n");
                boolean res = lines.length > 2;
                return res;
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }
}

