/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.navigator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecp.navigator.Activator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.PlatformUI;

public class TreeLabelProvider {
    private ILabelProvider defaultLabelProvider;
    private IBaseLabelProvider replacedLabelProvider;
    private ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public TreeLabelProvider() {
        this.defaultLabelProvider = new DecoratingLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        this.replaceLabelProvider();
    }

    private void replaceLabelProvider() {
        IConfigurationElement[] confs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.navigator.replaceLabelProvider");
        if (confs.length > 1) {
            IllegalStateException exception = new IllegalStateException("Two or more ReplaceLabel Providers registered");
            Activator.getDefault().logException(exception.getMessage(), exception);
        } else if (confs.length == 1) {
            IConfigurationElement element = confs[0];
            try {
                this.replacedLabelProvider = (IBaseLabelProvider)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.replacedLabelProvider != null) {
            return this.replacedLabelProvider;
        }
        return this.defaultLabelProvider;
    }

    public void dispose() {
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
    }
}

