/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.options.MergeTextOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AttributeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeConflict
extends Conflict {
    public AttributeConflict(List<AbstractOperation> myOperations, List<AbstractOperation> theirOperations, DecisionManager decisionManager) {
        super(myOperations, theirOperations, decisionManager);
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        description.setDescription("You have changed the [feature] attribute of [modelelement] to [myvalue]. This attribute was changed to [theirvalue] on the repository.");
        description.add("myvalue", this.getMyOperation(AttributeOperation.class).getNewValue());
        description.add("theirvalue", this.getTheirOperation(AttributeOperation.class).getNewValue());
        description.setImage("attribute.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        this.initOptionsWithOutMerge(options, true);
    }

    protected void initOptionsWithOutMerge(List<ConflictOption> options, boolean withMerge) {
        ConflictOption myOption = new ConflictOption(this.getMyOperation(AttributeOperation.class).getNewValue(), ConflictOption.OptionType.MyOperation);
        myOption.setDetailProvider("org.eclipse.emf.emfstore.client.ui.merge.widget.multiline");
        myOption.addOperations(this.getMyOperations());
        options.add(myOption);
        ConflictOption theirOption = new ConflictOption(this.getTheirOperation(AttributeOperation.class).getNewValue(), ConflictOption.OptionType.TheirOperation);
        theirOption.setDetailProvider("org.eclipse.emf.emfstore.client.ui.merge.widget.multiline");
        theirOption.addOperations(this.getTheirOperations());
        options.add(theirOption);
        if (withMerge && DecisionUtil.detailsNeeded(this)) {
            MergeTextOption mergeOption = new MergeTextOption();
            mergeOption.add(myOption);
            mergeOption.add(theirOption);
            options.add(mergeOption);
        }
    }
}

