/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.rdf.emf;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.rdf.emf.RDFDeserializer;
import org.eclipse.epsilon.rdf.emf.RDFGraphResourceImpl;

public class RDFGraphResourceUpdate {
    private static final boolean CONSOLE_OUTPUT_ACTIVE = false;
    private static final boolean SINGLE_MULTIVALUES_AS_STATEMENT = true;
    private RDFDeserializer deserializer;
    private RDFGraphResourceImpl rdfGraphResource;

    public RDFGraphResourceUpdate(RDFDeserializer deserializer, RDFGraphResourceImpl rdfGraphResource) {
        this.deserializer = deserializer;
        this.rdfGraphResource = rdfGraphResource;
    }

    private Literal createLiteral(Object value) {
        if (value.getClass().equals(Date.class)) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)value);
            String date = DateTimeUtils.calendarToXSDDateTimeString((Calendar)c);
            return ResourceFactory.createTypedLiteral((String)date, (RDFDatatype)XSDDatatype.XSDdateTime);
        }
        return ResourceFactory.createTypedLiteral((Object)value);
    }

    public Resource createNewEObjectResource(Model model, EObject eObject) {
        String iri = this.createEObjectIRI(model, eObject);
        return iri == null ? null : this.createNewEObjectResource(model, eObject, iri);
    }

    public Resource createNewEObjectResource(Model model, EObject eObject, String iri) {
        Resource eobResource = model.createResource(iri);
        this.deserializer.registerNewEObject(eObject, eobResource);
        return eobResource;
    }

    private Resource getEObjectResource(Model model, EObject eObject) {
        Resource valueResource = null;
        valueResource = this.rdfGraphResource.getRDFResource(eObject);
        if (valueResource != null) {
            return valueResource;
        }
        valueResource = this.deserializer.restoreEObjectResource(eObject);
        if (valueResource != null) {
            this.addAllEObjectStatements(model, eObject);
            return valueResource;
        }
        valueResource = this.createNewEObjectResource(model, eObject);
        if (valueResource != null) {
            this.addAllEObjectStatements(model, eObject);
            return valueResource;
        }
        return null;
    }

    private RDFNode createValueRDFNode(Object value, Model model) {
        if (value instanceof Resource) {
            return (Resource)value;
        }
        if (value instanceof Literal) {
            return (Literal)value;
        }
        if (value instanceof EObject) {
            return this.getEObjectResource(model, (EObject)value);
        }
        return this.createLiteral(value);
    }

    private Property createProperty(EStructuralFeature eStructuralFeature) {
        String ePackageNamespace = this.deserializer.normaliseEPackageNSURI(eStructuralFeature.getEContainingClass().getEPackage().getNsURI());
        return ResourceFactory.createProperty((String)ePackageNamespace, (String)eStructuralFeature.getName());
    }

    private RDFNode getObjectRDFNode(EObject eObject, EStructuralFeature eStructuralFeature, Model model) {
        Property property;
        Resource rdfNode = this.rdfGraphResource.getRDFResource(eObject);
        if (model.contains(rdfNode, property = this.createProperty(eStructuralFeature))) {
            List propertyObjects = model.listObjectsOfProperty(rdfNode, property).toList();
            if (propertyObjects.size() > 1) {
                // empty if block
            }
            return (RDFNode)propertyObjects.get(0);
        }
        return null;
    }

    private Statement findEquivalentStatement(Model model, EObject eob, EStructuralFeature eStructuralFeature, Object value) {
        return this.findEquivalentStatement(model, this.rdfGraphResource.getRDFResource(eob), eStructuralFeature, value);
    }

    private Statement findEquivalentStatement(Model model, Resource eobRes, EStructuralFeature eStructuralFeature, Object value) {
        ArrayList<Statement> matchedStatementList = new ArrayList<Statement>();
        Resource rdfNode = eobRes;
        Property property = this.createProperty(eStructuralFeature);
        RDFNode object = null;
        List modelStatementList = model.listStatements(rdfNode, property, object).toList();
        for (Statement modelStatement : modelStatementList) {
            Object deserialisedValue = this.deserializer.deserializeProperty(modelStatement.getSubject(), eStructuralFeature);
            if (!Objects.equals(value, deserialisedValue)) continue;
            matchedStatementList.add(modelStatement);
        }
        if (matchedStatementList.isEmpty()) {
            return null;
        }
        if (matchedStatementList.size() > 1) {
            StringBuilder statementList = new StringBuilder();
            for (Statement statement : modelStatementList) {
                statementList.append(String.format("\n - %s", statement));
            }
            System.err.println(String.format("Find equivalent statements method returned more than 1 statement. %s\n", statementList));
        }
        return (Statement)matchedStatementList.get(0);
    }

    private Statement createStatement(Model model, EObject eObject, EStructuralFeature eStructuralFeature, Object value) {
        Resource subject = this.rdfGraphResource.getRDFResource(eObject);
        if (subject == null) {
            System.err.println("createStatement() subject is null");
            return null;
        }
        return this.createStatement(model, subject, eStructuralFeature, value);
    }

    private Statement createStatement(Model model, Resource eObjectResource, EStructuralFeature eStructuralFeature, Object value) {
        Resource rdfNode = eObjectResource;
        Property property = this.createProperty(eStructuralFeature);
        RDFNode object = this.createValueRDFNode(value, model);
        if (object == null) {
            return null;
        }
        return ResourceFactory.createStatement((Resource)rdfNode, (Property)property, (RDFNode)object);
    }

    private String getEMFResourceURI(EObject eObject) {
        return eObject.eResource().getURI().toString();
    }

    private String createEObjectIRI(Model model, EObject eObject) {
        String eObjectName = EcoreUtil.generateUUID();
        Object eObjectNamespace = this.rdfGraphResource.getConfig().getDefaultModelNamespace();
        if (eObjectNamespace != null && !"".equals(((String)eObjectNamespace).trim())) {
            eObjectNamespace = this.deserializer.normaliseEPackageNSURI((String)eObjectNamespace);
        } else {
            String prefix = (String)model.getNsPrefixMap().get("");
            if (prefix != null) {
                eObjectNamespace = prefix;
            } else if (eObject.eResource() != null) {
                eObjectNamespace = this.getEMFResourceURI(eObject) + "#";
            } else {
                System.err.println("Cannot generate IRI for object without resource and without default namespace: " + String.valueOf(eObject));
                return null;
            }
        }
        String eObjectIRI = (String)eObjectNamespace + eObjectName;
        return eObjectIRI;
    }

    private String createEClassIRI(EObject eObject) {
        String eClassNamespacePrefix = this.deserializer.normaliseEPackageNSURI(eObject.eClass().getEPackage().getNsURI());
        String eClassName = eObject.eClass().getName();
        String eClassIRI = eClassNamespacePrefix + eClassName;
        return eClassIRI;
    }

    private Statement createEObjectEClassStatement(Model model, EObject eObject) {
        String eClassIRI = this.createEClassIRI(eObject);
        Resource subject = this.getEObjectResource(model, eObject);
        Property predicate = RDF.type;
        Resource object = model.createResource(eClassIRI);
        Statement statement = model.createStatement(subject, predicate, (RDFNode)object);
        return statement;
    }

    private void checkAndRemoveEmptyContainers(Container container, EObject onEObject, EStructuralFeature eStructuralFeature) {
        Model model = container.asResource().getModel();
        if (1 == container.size()) {
            RDFNode firstValue = container.iterator().next();
            container.removeProperties();
            model.remove(this.createStatement(model, onEObject, eStructuralFeature, (Object)container));
            model.add(this.createStatement(model, onEObject, eStructuralFeature, (Object)firstValue));
            return;
        }
        if (container.size() == 0) {
            container.removeProperties();
            model.remove(this.createStatement(model, onEObject, eStructuralFeature, (Object)container));
            return;
        }
    }

    private void searchContainerAndRemoveValue(Model model, Object value, Container container, EStructuralFeature sf) {
        List containerPropertyStatements = container.listProperties().toList();
        Iterator cpsItr = containerPropertyStatements.iterator();
        boolean done = false;
        while (!done) {
            if (cpsItr.hasNext()) {
                Statement statement = (Statement)cpsItr.next();
                Object deserializedValue = this.deserializer.deserializeValue(statement.getObject(), sf);
                if (!value.equals(deserializedValue)) continue;
                container.remove(statement);
                if (sf.isUnique()) continue;
                done = true;
                continue;
            }
            done = true;
        }
        if (this.checkContainment(sf, value)) {
            this.removeAllObjectStatements(model, value);
        }
    }

    private void removeFromContainer(Model model, Object values, Container container, EObject onEObject, EStructuralFeature eStructuralFeature) {
        EStructuralFeature sf = eStructuralFeature.eContainingFeature();
        if (values instanceof EList) {
            EList valuesList = (EList)values;
            valuesList.iterator().forEachRemaining(value -> this.searchContainerAndRemoveValue(model, value, container, sf));
        } else {
            this.searchContainerAndRemoveValue(model, values, container, sf);
        }
        this.checkAndRemoveEmptyContainers(container, onEObject, eStructuralFeature);
    }

    private void removeFromSeq(Model model, Object value, Container container, EObject onEObject, EStructuralFeature eStructuralFeature) {
        this.removeFromContainer(model, value, container, onEObject, eStructuralFeature);
    }

    private void removeFromBag(Model model, Object value, Container container, EObject onEObject, EStructuralFeature eStructuralFeature) {
        this.removeFromContainer(model, value, container, onEObject, eStructuralFeature);
    }

    private void addToSequence(Object values, Seq container, int position) {
        if (-1 == position) {
            position = container.size();
        }
        Model model = container.getModel();
        if (values instanceof List) {
            List list = (List)values;
            for (Object v : list) {
                container.add(++position, this.createValueRDFNode(v, model));
            }
        } else {
            container.add(++position, this.createValueRDFNode(values, model));
        }
    }

    private void addToBag(Object values, Bag container) {
        if (values instanceof Collection) {
            Collection list = (Collection)values;
            list.forEach(v -> {
                Container container = container.add(v);
            });
        } else {
            container.add(values);
        }
    }

    private Seq newSequence(Model model, EObject onEObject, EStructuralFeature eStructuralFeature) {
        Seq objectNode = model.createSeq();
        model.add(this.createStatement(model, onEObject, eStructuralFeature, (Object)objectNode));
        return objectNode;
    }

    private Bag newBag(Model model, EObject onEObject, EStructuralFeature eStructuralFeature) {
        Bag objectNode = model.createBag();
        model.add(this.createStatement(model, onEObject, eStructuralFeature, (Object)objectNode));
        return objectNode;
    }

    private void checkAndRemoveEmptyList(RDFList container, EObject onEObject, EStructuralFeature eStructuralFeature) {
        Model model = container.getModel();
        if (!container.isValid()) {
            Statement stmtToRemove = this.createStatement(model, onEObject, eStructuralFeature, (Object)container.asResource());
            model.remove(stmtToRemove);
            return;
        }
        if (1 == container.size()) {
            RDFNode firstValue = (RDFNode)container.iterator().next();
            container.removeList();
            model.remove(this.createStatement(model, onEObject, eStructuralFeature, (Object)container.asResource()));
            model.add(this.createStatement(model, onEObject, eStructuralFeature, (Object)firstValue));
            return;
        }
        if (container.isEmpty()) {
            model.remove(this.createStatement(model, onEObject, eStructuralFeature, (Object)container.asResource()));
            return;
        }
    }

    private RDFList removeOneValueFromListHandleUnique(RDFList container, EStructuralFeature sf, RDFNode valueRDFNode) {
        RDFList newContainer = container;
        if (sf.isUnique() && valueRDFNode != null) {
            while (newContainer.isValid() && newContainer.contains(valueRDFNode)) {
                newContainer = newContainer.remove(valueRDFNode);
            }
        } else {
            newContainer = container.remove(valueRDFNode);
        }
        return newContainer;
    }

    private RDFList removeOneValueFromList(Model model, Object value, RDFList container, EStructuralFeature eStructuralFeature) {
        if (value instanceof EObject && eStructuralFeature instanceof EReference) {
            Resource valueRDFNode = this.rdfGraphResource.getRDFResource((EObject)value);
            RDFList newContainer = this.removeOneValueFromListHandleUnique(container, eStructuralFeature, (RDFNode)valueRDFNode);
            if (this.checkContainment(eStructuralFeature, value)) {
                this.removeAllObjectStatements(model, value);
            }
            return newContainer;
        }
        for (RDFNode rdfNode : container) {
            Object deserializedValue = this.deserializer.deserializeValue(rdfNode, eStructuralFeature);
            if (!value.equals(deserializedValue)) continue;
            return this.removeOneValueFromListHandleUnique(container, eStructuralFeature, rdfNode);
        }
        return container;
    }

    private void removeFromList(Object values, RDFList container, EObject onEObject, EStructuralFeature eStructuralFeature, Model model) {
        RDFList newContainer = container;
        if (values instanceof List) {
            List valueList = (List)values;
            for (Object value : valueList) {
                newContainer = this.removeOneValueFromList(model, value, newContainer, eStructuralFeature);
            }
        } else {
            newContainer = this.removeOneValueFromList(model, values, newContainer, eStructuralFeature);
        }
        if (container != newContainer) {
            model.remove(this.createStatement(model, onEObject, eStructuralFeature, (Object)container.asResource()));
            model.add(this.createStatement(model, onEObject, eStructuralFeature, (Object)newContainer.asResource()));
        }
        this.checkAndRemoveEmptyList(newContainer, onEObject, eStructuralFeature);
    }

    private void addToList(Object values, RDFList container, int position, EStructuralFeature eStructuralFeature, EObject onEObject) {
        Model model = container.getModel();
        RDFList newList = this.createRDFListOnModel(values, model);
        if (container.isEmpty()) {
            container.concatenate(newList);
        } else if (!eStructuralFeature.isOrdered()) {
            container.concatenate(newList);
        } else if (container.size() == position) {
            container.concatenate(newList);
        } else if (position == 0) {
            model.remove(this.createStatement(model, onEObject, eStructuralFeature, (Object)container));
            model.add(this.createStatement(model, onEObject, eStructuralFeature, (Object)newList));
            newList.concatenate(container);
        } else {
            RDFList head = container;
            RDFList tail = head.getTail();
            int i = 1;
            while (i < position) {
                head = tail;
                tail = head.getTail();
                ++i;
            }
            newList.concatenate(tail);
            head.setTail(newList);
        }
    }

    private RDFList createRDFListOnModel(Object values, Model model) {
        ArrayList<RDFNode> rdfNodes = new ArrayList<RDFNode>();
        if (values instanceof List) {
            ((List)values).forEach(v -> {
                boolean bl = rdfNodes.add(this.createValueRDFNode(v, model));
            });
        } else {
            rdfNodes.add(this.createValueRDFNode(values, model));
        }
        return model.createList(rdfNodes.iterator());
    }

    private RDFList newList(Model model, EObject onEObject, EStructuralFeature eStructuralFeature, Object values) {
        RDFList objectNode = this.createRDFListOnModel(values, model);
        model.add(this.createStatement(model, onEObject, eStructuralFeature, (Object)objectNode));
        return objectNode;
    }

    private boolean checkContainment(EStructuralFeature eStructuralFeature, Object value) {
        return eStructuralFeature instanceof EReference && value instanceof EObject && ((EReference)eStructuralFeature).isContainment();
    }

    private void addAllEStructuralFeatureStatements(EObject eObject, Model model) {
        EList eStructuralFeatureList = eObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eStructuralFeatureList) {
            Object value = eObject.eGet(eStructuralFeature, true);
            if (value == null) continue;
            if (eStructuralFeature.isMany()) {
                if (value instanceof List) {
                    for (Object v : (List)value) {
                        this.addMultiValueEStructuralFeature(model, eObject, eStructuralFeature, v, -1);
                    }
                    continue;
                }
                this.addMultiValueEStructuralFeature(model, eObject, eStructuralFeature, value, -1);
                continue;
            }
            this.addSingleValueEStructuralFeatureStatements(model, eObject, eStructuralFeature, value);
        }
    }

    private void removeAllEStructuralFeatureStatements(EObject eObject, Model model) {
        EList eStructuralFeatureList = eObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eStructuralFeatureList) {
            Object value = eObject.eGet(eStructuralFeature);
            if (value == null) continue;
            if (eStructuralFeature.isMany()) {
                if (value instanceof List) {
                    List l = (List)value;
                    for (Object v : l) {
                        this.removeMultiEStructuralFeature(model, eObject, eStructuralFeature, v);
                    }
                    continue;
                }
                this.removeMultiEStructuralFeature(model, eObject, eStructuralFeature, value);
                continue;
            }
            this.removeSingleValueEStructuralFeatureStatements(model, eObject, eStructuralFeature, value);
        }
    }

    private void addEObjectEClassStatement(Model model, EObject eObject) {
        model.add(this.createEObjectEClassStatement(model, eObject));
    }

    private void removeEObjectEClassStatement(Model model, EObject eObject) {
        model.remove(this.createEObjectEClassStatement(model, eObject));
    }

    private void addAllEObjectStatements(Model model, EObject eObject) {
        this.addEObjectEClassStatement(model, eObject);
        this.addAllEStructuralFeatureStatements(eObject, model);
    }

    private void removeAllObjectStatements(Model model, Object oldValue) {
        if (oldValue instanceof EObject) {
            this.removeAllEObjectStatements(model, (EObject)oldValue);
        } else {
            System.err.println("removeAllObjectStatements() not an EObject: " + oldValue.getClass().getName());
        }
    }

    private void removeAllEObjectStatements(Model model, EObject eObject) {
        this.removeAllEStructuralFeatureStatements(eObject, model);
        this.removeEObjectEClassStatement(model, eObject);
        this.deserializer.deregisterEObject(eObject);
    }

    protected void addToResource(EObject eObject, Model model) {
        if (eObject.eContainer() == null) {
            this.addAllEObjectStatements(model, eObject);
        }
    }

    protected void removeFromResource(EObject eObject, Model model) {
        if (eObject.eContainer() == null) {
            this.removeAllEObjectStatements(model, eObject);
        }
    }

    public void addSingleValueEStructuralFeatureStatements(List<Resource> namedModelURIs, EObject onEObject, EStructuralFeature eStructuralFeature, Object newValue) {
        assert (newValue != null) : "new value must exist";
        List<Model> namedModelsToUpdate = this.rdfGraphResource.getNamedModels(namedModelURIs);
        for (Model model : namedModelsToUpdate) {
            this.addSingleValueEStructuralFeatureStatements(model, onEObject, eStructuralFeature, newValue);
        }
    }

    public void addSingleValueEStructuralFeatureStatements(Model model, EObject onEObject, EStructuralFeature eStructuralFeature, Object newValue) {
        assert (newValue != null) : "new value must exist";
        Statement newStatement = this.createStatement(model, onEObject, eStructuralFeature, newValue);
        Statement existingStatements = this.findEquivalentStatement(model, onEObject, eStructuralFeature, newValue);
        if (newStatement != null && existingStatements == null && !model.contains(newStatement)) {
            model.add(newStatement);
        }
    }

    public void removeSingleValueEStructuralFeatureStatements(List<Resource> namedModelURIs, EObject onEObject, EStructuralFeature eStructuralFeature, Object oldValue) {
        assert (oldValue != null) : "old value must exist";
        List<Model> namedModelsToUpdate = this.rdfGraphResource.getNamedModels(namedModelURIs);
        for (Model model : namedModelsToUpdate) {
            this.removeSingleValueEStructuralFeatureStatements(model, onEObject, eStructuralFeature, oldValue);
        }
    }

    public void removeSingleValueEStructuralFeatureStatements(Model model, EObject onEObject, EStructuralFeature eStructuralFeature, Object oldValue) {
        assert (oldValue != null) : "old value must exist";
        Statement oldStatement = this.createStatement(model, onEObject, eStructuralFeature, oldValue);
        if (oldStatement == null) {
            System.err.println("Can't make a statement, probably removed from deserialiser already");
        }
        if (oldStatement != null && model.contains(oldStatement)) {
            if (this.checkContainment(eStructuralFeature, oldValue)) {
                this.removeAllObjectStatements(model, oldValue);
            }
            model.remove(oldStatement);
            return;
        }
        Statement stmtToRemove = this.findEquivalentStatement(model, onEObject, eStructuralFeature, oldValue);
        if (stmtToRemove != null) {
            if (this.checkContainment(eStructuralFeature, oldValue)) {
                this.removeAllObjectStatements(model, oldValue);
            }
            model.remove(stmtToRemove);
            return;
        }
        if (oldValue.equals(eStructuralFeature.getDefaultValue())) {
            return;
        }
        System.err.println(String.format("Old statement not found during single removal: %s\n - eObject (subject): %s\n - feature (predicate): %s\n - value (object): %s ", oldStatement, onEObject, eStructuralFeature, oldValue));
    }

    public void updateSingleValueEStructuralFeatureStatements(List<Resource> namedModelURIs, EObject onEObject, EStructuralFeature eStructuralFeature, Object newValue, Object oldValue) {
        assert (oldValue != null) : "old value must exist";
        assert (newValue != null) : "new value must exist";
        List<Model> namedModelsToUpdate = this.rdfGraphResource.getNamedModels(namedModelURIs);
        for (Model model : namedModelsToUpdate) {
            this.updateSingleValueEStructuralFeatureStatements(model, onEObject, eStructuralFeature, newValue, oldValue);
        }
    }

    public void updateSingleValueEStructuralFeatureStatements(Model model, EObject onEObject, EStructuralFeature eStructuralFeature, Object newValue, Object oldValue) {
        this.removeSingleValueEStructuralFeatureStatements(model, onEObject, eStructuralFeature, oldValue);
        this.addSingleValueEStructuralFeatureStatements(model, onEObject, eStructuralFeature, newValue);
    }

    public void removeMultiEStructuralFeature(List<Resource> namedModelURIs, EObject onEObject, EStructuralFeature eStructuralFeature, Object oldValue) {
        List<Model> namedModelsToUpdate = this.rdfGraphResource.getNamedModels(namedModelURIs);
        for (Model model : namedModelsToUpdate) {
            this.removeMultiEStructuralFeature(model, onEObject, eStructuralFeature, oldValue);
        }
    }

    public void removeMultiEStructuralFeature(Model model, EObject onEObject, EStructuralFeature eStructuralFeature, Object oldValue) {
        Property property;
        Resource onEObjectNode = this.rdfGraphResource.getRDFResource(onEObject);
        if (!onEObjectNode.hasProperty(property = this.createProperty(eStructuralFeature))) {
            System.err.printf("Trying to remove the non-existing property %s in resource %s%s", property, onEObjectNode, System.lineSeparator());
        } else {
            RDFNode objectRDFNode = this.getObjectRDFNode(onEObject, eStructuralFeature, model);
            if (objectRDFNode != null) {
                if (objectRDFNode.isLiteral()) {
                    this.removeSingleValueEStructuralFeatureStatements(model, onEObject, eStructuralFeature, oldValue);
                } else if (objectRDFNode.isResource()) {
                    Resource objectResource = objectRDFNode.asResource();
                    if (objectResource.hasProperty(RDF.rest) && objectResource.hasProperty(RDF.first) || objectResource.hasProperty(RDF.type, (RDFNode)RDF.List)) {
                        RDFList list = model.getList(objectResource);
                        list.setStrict(true);
                        this.removeFromList(oldValue, list, onEObject, eStructuralFeature, model);
                    } else if (objectResource.equals((Object)RDF.nil)) {
                        System.err.println("Removing from Empty list");
                    } else if (objectResource.hasProperty(RDF.type, (RDFNode)RDF.Bag)) {
                        Bag bag = model.getBag(objectResource);
                        this.removeFromBag(model, oldValue, (Container)bag, onEObject, eStructuralFeature);
                    } else if (objectResource.hasProperty(RDF.type, (RDFNode)RDF.Seq)) {
                        Seq seq = model.getSeq(objectResource);
                        this.removeFromSeq(model, oldValue, (Container)seq, onEObject, eStructuralFeature);
                    } else {
                        this.removeSingleValueEStructuralFeatureStatements(model, onEObject, eStructuralFeature, oldValue);
                    }
                }
            }
        }
    }

    public void addMultiValueEStructuralFeature(List<Resource> namedModelURIs, EObject onEObject, EStructuralFeature eStructuralFeature, Object newValue, Object oldValue, int position) {
        List<Model> namedModelsToUpdate = this.rdfGraphResource.getNamedModels(namedModelURIs);
        for (Model model : namedModelsToUpdate) {
            this.addMultiValueEStructuralFeature(model, onEObject, eStructuralFeature, newValue, position);
        }
    }

    public void addMultiValueEStructuralFeature(Model model, EObject onEObject, EStructuralFeature eStructuralFeature, Object newValue, int position) {
        Resource onEObjectNode = this.rdfGraphResource.getRDFResource(onEObject);
        if (!onEObjectNode.hasProperty(this.createProperty(eStructuralFeature))) {
            if (newValue instanceof List) {
                this.createContainerAndAdd(model, onEObject, eStructuralFeature, newValue, position, null);
            } else {
                this.addSingleValueEStructuralFeatureStatements(model, onEObject, eStructuralFeature, newValue);
            }
        } else {
            RDFNode objectRDFNode = this.getObjectRDFNode(onEObject, eStructuralFeature, model);
            if (objectRDFNode.isLiteral()) {
                this.createContainerAndAdd(model, onEObject, eStructuralFeature, newValue, position, objectRDFNode.asLiteral().getValue());
            } else if (objectRDFNode.isResource()) {
                Resource objectResource = objectRDFNode.asResource();
                if (objectResource.hasProperty(RDF.type, (RDFNode)RDF.List) || objectResource.hasProperty(RDF.rest) && objectResource.hasProperty(RDF.first)) {
                    RDFList list = model.getList(objectResource);
                    this.addToList(newValue, list, position, eStructuralFeature, onEObject);
                } else if (objectResource.equals((Object)RDF.nil)) {
                    Statement stmt = this.createStatement(model, onEObject, eStructuralFeature, (Object)objectResource);
                    model.remove(stmt);
                    this.newList(model, onEObject, eStructuralFeature, newValue);
                } else if (objectResource.hasProperty(RDF.type, (RDFNode)RDF.Bag)) {
                    Bag bag = model.getBag(objectResource);
                    this.addToBag(newValue, bag);
                } else if (objectResource.hasProperty(RDF.type, (RDFNode)RDF.Seq)) {
                    Seq seq = model.getSeq(objectResource);
                    this.addToSequence(newValue, seq, position);
                } else {
                    this.createContainerAndAdd(model, onEObject, eStructuralFeature, newValue, position, objectResource);
                }
            }
        }
    }

    private void createContainerAndAdd(Model model, EObject onEObject, EStructuralFeature eStructuralFeature, Object newValue, int position, Object firstValue) {
        if (firstValue != null) {
            this.removeSingleValueEStructuralFeatureStatements(model, onEObject, eStructuralFeature, firstValue);
        }
        if (this.rdfGraphResource.getConfig().getRawMultiValueAttributeMode().useLists()) {
            RDFList list = null;
            if (firstValue != null) {
                list = this.newList(model, onEObject, eStructuralFeature, firstValue);
                this.addToList(newValue, list, position, eStructuralFeature, onEObject);
            } else {
                list = this.newList(model, onEObject, eStructuralFeature, newValue);
            }
        } else if (eStructuralFeature.isOrdered()) {
            Seq sequence = this.newSequence(model, onEObject, eStructuralFeature);
            if (firstValue != null) {
                this.addToSequence(firstValue, sequence, 0);
            }
            this.addToSequence(newValue, sequence, position);
        } else {
            Bag bag = this.newBag(model, onEObject, eStructuralFeature);
            if (firstValue != null) {
                this.addToBag(firstValue, bag);
            }
            this.addToBag(newValue, bag);
        }
    }

    private static void reportContainer(String label, Container container) {
        boolean hasType = container.hasProperty(RDF.type);
        if (hasType) {
            System.out.println(String.format("\n%s Container: Type %s, Size %s", label, container.getProperty(RDF.type), container.size()));
            container.iterator().forEach(i -> System.out.println("  * " + String.valueOf(i)));
        }
    }

    private static void reportRDFList(String label, RDFList container) {
        System.out.println(String.format("\n%s List: Strict %s, Size: %s", label, container.getStrict(), container.size()));
        RDFList item = container;
        while (item != null) {
            Statement restStatement = item.getProperty(RDF.rest);
            Statement firstStatement = item.getProperty(RDF.first);
            if (restStatement != null) {
                System.out.println(String.format(" * RDFnode %s \n\t--> rest: %s \n\t--> first: %s ", item, restStatement.getObject(), firstStatement.getObject()));
                item = item.getProperty(RDF.rest).getResource();
                continue;
            }
            item = null;
        }
    }

    private String getEObjectInstanceLabel(EObject eObject) {
        return String.format("%s#%s", eObject.eClass().getName(), eObject.hashCode());
    }
}

