/*******************************************************************************
 * Copyright (c) 2008 The University of York.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     Dimitrios Kolovos - initial API and implementation
 ******************************************************************************/
package org.eclipse.epsilon.eol.exceptions;

import java.util.Objects;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.types.EolNoType;

public class EolIllegalOperationException extends EolRuntimeException {
	
	// Generated by Eclipse
	private static final long serialVersionUID = 1418757189757495698L;
	
	protected String methodName = "";
	protected Object object = null;
	protected PrettyPrinterManager prettyPrintManager;
	
	public EolIllegalOperationException(Object object, String methodName, ModuleElement ast, PrettyPrinterManager prettyPrintManger) {
		this.ast = ast;
		this.methodName = methodName;
		this.object = object;
		this.prettyPrintManager = prettyPrintManger;
	}
	
	public String getMethodName() {
		return methodName;
	}
	
	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}
	
	public Object getObject() {
		return object;
	}
	
	public void setObject(Object object) {
		this.object = object;
	}
	
	@Override
	public String getReason() {
		if (object == null) {
			return "Called method '" + methodName + "' on undefined object";
		}
		
		String reason = "Method '" + methodName + "' not found";
		if (!object.equals(EolNoType.NoInstance)) {
			reason += " for: ";
			if (prettyPrintManager != null) {
				reason += prettyPrintManager.print(object);
			}
			else {
				reason += Objects.toString(object);
			}
		}
	
		return reason;
	}
}
